# アセット

エントリや他のコンテンツタイプと同様に、プロジェクトのメディアと文書ファイル（アセット）を Craft で管理することができます。

## ボリューム

すべてのアセットは「ボリューム」にあります。ボリュームは、ストレージコンテナです。ウェブサーバーのディレクトリ、または、Amazon S3 のようなリモートストレージサービスをボリュームにできます。

「設定 > アセット」から、プロジェクトのボリュームを管理できます。

すべてのボリュームは、その中に含まれるアセットがパプリック URL を持つかどうか、持つ場合に**ベース URL** をどうするかを選択できます。

::: tip
ボリュームのベース URL は環境変数をセットしたり、エイリアスではじめることができます。詳細については、[環境設定](config/environments.md)を参照してください。
:::

### ローカルボリューム

デフォルトで、ボリュームの1つのタイプ「ローカル」を作成できます。ローカルボリュームは、ローカルウェブサーバー上のディレクトリを表します。

ローカルボリュームは、**ファイルシステムのパス**という1つの設定があります。この設定を使用して、サーバー上のボリュームのルートディレクトリからのパスを定義します。

::: tip
ボリュームのファイルシステムのパスは環境変数をセットしたり、エイリアスではじめることができます。詳細については、[環境設定](config/environments.md)を参照してください。
:::

Craft もしくは PHP が、作成したディレクトリに書き込み可能でなければならないことに注意してください。

### リモートボリューム

Amazon S3 のようなリモートストレージサービスにアセットを保存したい場合は、インテグレーション機能を提供するプラグインをインストールできます。

- [Amazon S3](https://github.com/craftcms/aws-s3)（ファーストパーティ）
- [Google Cloud Storage](https://github.com/craftcms/google-cloud)（ファーストパーティ）
- [Rackspace Cloud Files](https://github.com/craftcms/rackspace)（ファーストパーティ）
- [DigitalOcean Spaces](https://github.com/vaersaagod/dospaces)（Værsågod）
- [fortrabbit Object Storage](https://github.com/fortrabbit/craft-object-storage)（fortrabbit）

## アセットのカスタムフィールド

それぞれのアセットボリュームはフィールドレイアウトを持ち、そのボリュームに含まれるアセットが利用可能な[フィールド](fields.md)をセットできます。ボリュームの編集中に「フィールドの配置」タブをクリックすることで、ボリュームのフィールドレイアウトを編集できます。

ここで選択したフィールドは、（[アセットページ](#assets-page) または [アセットフィールド](assets-fields.md) のいずれかにある）アセットをダブルクリックした際に開く、アセットエディタの HUD に表示されます。

## アセットページ

最初のボリュームを作成すると、コントロールパネルのメインナビゲーションに「アセット」項目が追加されます。これをクリックすると、左サイドバーにすべてのボリュームのリスト、メインコンテンツエリアに選択されたボリュームのファイルが表示されたアセットページに移動します。

このページでは、次のことができます。

- 新しいファイルのアップロード
- ファイルのリネーム
- ファイルのタイトルやファイル名の編集
- 選択されたイメージ向けのイメージエディタの起動
- サブフォルダの管理
- （ドラッグアンドドロップによる）別のボリュームやサブフォルダへのファイルの移動
- ファイルの削除

### サブフォルダの管理

左サイドバーのボリュームで右クリックし「新しいサブフォルダー」を選択すると、ボリュームの1つにサブフォルダを作成できます。

サブフォルダを作成すると、その中にファイルをドラックできるようになります。

左サイドバーのサブフォルダで右クリックし「新しいサブフォルダー」を選択すると、サブフォルダの中にネストされたサブフォルダを作成できます。

左サイドバーのサブフォルダを右クリックし「フォルダ名を変更する」を選択すると、サブフォルダをリネームできます。

左サイドバーのサブフォルダを右クリックし「フォルダを削除する」を選択すると、サブフォルダ（および、それに含まれるすべてのアセット）を削除できます。

## アセットインデックスのアップデート

（FTP などの）Craft 外で追加、編集、または、削除されたファイルがある場合、Craft にそのボリュームのインデックスをアップデートするよう伝える必要があります。「ユーティリティ > アセットインデックス」から実行できます。

リモート画像をキャッシュするオプションがあります。（Amazon S3 など）リモートボリュームがない場合は、無視して問題ありません。設定を有効にすると、インデックス処理が完了するまでの時間が長くなりますが、[画像の変形](image-transforms.md)の生成スピードが向上します。

## 画像の変形

Craft はアセットに様々な画像変形を行う手段を提供します。詳細については、[画像の変形](image-transforms.md)を参照してください。

## イメージエディタ

Craft は画像を変更するための組み込みのイメージエディタを提供します。画像を切り抜いたり、まっすぐにしたり、回転させたり、反転させたり、さらに焦点を選択することもできます。

イメージエディタを起動するには、（アセットページまたは[アセットフィールド](assets-fields.md)のいずれかにある）画像をダブルクリックし、HUD の画像プレビューエリアの右上にある「編集」ボタンをクリックします。または、[アセットページ](#assets-page)で任意のアセットを選択し、タスクメニュー（歯車アイコン）から「画像の編集」 を選択することもできます。

### 焦点

[画像の変形](image-transforms.md)でどのように切り抜くかを決定する際、画像のどの部分を優先させるか Craft が認識するために、画像に焦点をセットします。焦点は、画像の変形の「デフォルトの焦点」設定よりも優先されます。

焦点を設定するには、イメージエディタを開き「焦点」ボタンをクリックします。画像の中央に円形のアイコンが表示されます。画像の焦点にしたい場所へ、アイコンをドラッグします。

焦点を削除するには、再度「焦点」ボタンをクリックします。

イメージエディタの他の変更と同様に、画像を保存するまで焦点は有効になりません。

