# `{% cache %}` タグ

このタグはテンプレートの一部をキャッシュするため、後からのリクエストのパフォーマンスを向上させます。

```twig
{% cache %}
    {% for block in entry.myMatrixField.all() %}
        <p>{{ block.text }}</p>
    {% endfor %}
{% endcache %}
```

警告：異常なページの読み込み時間で苦しむ場合、最適なホスティング環境を経験していないかもしれません。`{% cache %}` を試す前に、専門家に相談してください。`{% cache %}` は高速なデータベース接続、効率的なテンプレート、または適度なクエリ数に代わるものではありません。可能性のある副作用には、古くなったコンテンツ、過度に時間のかかるバックグラウンドタスク、動かなくなったタスク、および、稀に消滅があります。`{% cache %}` が適切かどうかをホスティングプロバイダに問い合わせてください。

## パラメータ

`{% cache %}` タグは、次のパラメータをサポートしています。

### `globally`

URL ごとではなく、（現在のサイトロケールのための）グローバルな出力をキャッシュします。

```twig
{% cache globally %}
```

### `using key`

キャッシュが使用するキーの名前を指定します。これを指定しない場合、Twig が最初にテンプレートを解析するときにランダムなキーが生成されます。

```twig
{% cache using key "page-header" %}
```

::: tip
クエリ文字列の変数をパスに含めることなく、ページごとのテンプレートをキャッシュするために [globally](#globally) パラメータを組み合わせることができます。

```twig
{% cache globally using key craft.app.request.pathInfo %}
```

:::

::: warning
カスタムキーを利用している `{% cache %}` 内のテンプレートコードを変更する場合、既存のテンプレートキャッシュは自動的にパージされません。タグに新しいキーを割り当てるか、「設定」の「キャッシュをクリア」ツールを使用して既存のテンプレートキャッシュを手動でクリアする必要があります。
:::

### `for`

キャッシュが有効期限になるまでの時間。

```twig
{% cache for 3 weeks %}
```

許可される継続時間の単位は、次の通りです。

- `sec`(`s`)
- `second`(`s`)
- `min`(`s`)
- `minute`(`s`)
- `hour`(`s`)
- `day`(`s`)
- `fortnight`(`s`)
- `forthnight`(`s`)
- `month`(`s`)
- `year`(`s`)
- `week`(`s`)

ヒント：このパラメータが省略される場合、コンフィグ設定の <config:cacheDuration> がデフォルトの継続時間を定義するために使用されます。

### `until`

キャッシュの有効期限を [DateTime](http://php.net/manual/en/class.datetime.php) オブジェクトで定義します。

```twig
{% cache until entry.eventDate %}
```

::: tip
[for](#for)  **_または_** [ until](#until) のいずれかを1つの `{% cache %}` タグで使用できます。
:::

### `if`

ある条件が満足される場合のみ、 `{% cache %}` タグを作動させます。

```twig
{# Only cache if this is a mobile browser #}
{% cache if craft.app.request.isMobileBrowser() %}
```

### `unless`

ある条件が満たされる場合、`{% cache %}` タグが作動しないようにします。

```twig
{# Don't cache if someone is logged in #}
{% cache unless currentUser %}
```

::: tip
[if](#if)  **_または_** [ unless](#unless) のいずれかを1つの `{% cache %}`タグで使用できます。
:::

## キャッシュのクリア

タグ内のエレメント（エントリ、アセットなど）が保存または削除されると、キャッシュは自動的にクリアされます。

タグ内にエレメント _クエリ_（例：`craft.entries`）を持ち、クエリの1つによって返される新しいエレメントを作成する場合、Craft はそれを判断してキャッシュをクリアすることもできます。

「キャッシュをクリア」ツールを使用して、「設定」ページからすべてのテンプレートキャッシュを手動でクリアすることもできます。

## どんなときに `{% cache %}` タグを使うのか

沢山のデータベースクエリを引き起こすテンプレートがある場合、または Twig の計算上非常にコストがかかる処理を行っているときは、`{% cache %}` タグを使うべきです。

それらを使用する場合のいくつかの例です。

* エントリの大きなリスト
* いくつかのブロックが関連フィールドを持ち、独自のデータベースクエリをページに追加している行列フィールドのループ
* 他のサイトからデータを取得しているときはいつでも

それらを使用するのがよいアイデア _ではない_ 場合のいくつかの例です。

* 静的なテキストにキャッシュを使用しないでください。シンプルにテキストを出力するよりも、コストが高くなります。

* 他を拡張するテンプレート内で、トップレベルの `{% block %}` タグの外側で使用することはできません。

* `{% cache %}` タグは HTML のみキャッシュします。そのため、キャッシュ対象となる実際の HTML を出力しない [{% css %}](css.md) や [{% js %}](js.md) のようなタグの内部で使うことは、意味をなしません。

   ```twig
    {# Bad: #}
    
    {% extends "_layout" %}
    {% cache %}
        {% block "content" %}
            ...
        {% endblock %}
    {% endcache %}
    
    {# Good: #}
    
    {% extends "_layout" %}
    {% block "content" %}
        {% cache %}
            ...
        {% endcache %}
    {% endblock %}
   ```

ヒント：`{% cache %}` タグは、その中にまだ生成されていない [画像の変形](../../image-transforms.md) URL が含まれるかどうかを検出します。それが含まれる場合、次のリクエストまでテンプレートのキャッシュを保留するため、一時的な画像 URL はキャッシュされません。

