# `{% exit %}` タグ

このタグは残りのテンプレートの実行を防ぎ、リクエストを終了します。

```twig
{% set entry = craft.entries.id(entryId).one() %}

{% if not entry %}
    {% exit 404 %}
{% endif %}
```

## パラメータ

`{% exit %}` タグは、次のパラメータをサポートしています。

### ステータス

レスポンスに含まれるべき HTTP ステータスコードをオプションでセットできます。その場合、Craft はレンダリングするための適切なエラーテンプレートを探します。例えば、`{% exit 404 %}` は Craft に `404.twig` テンプレートを返します。テンプレートが存在しない場合、Craft はそのステータスコードに対応する独自のテンプレートをフォールバックします。

