# 更新履歴とアップデート

プラグインストアでプラグインを[公開する](plugin-store.md)とき、リポジトリのプラグインの更新履歴のパスを指定することができます。

有効な更新履歴のパスがセットされている場合、プラグインの新しいアップデートをリリースするごとにプラグインストアは更新履歴を再ダウンロードし、「ユーティリティ > アップデート」ページに利用可能なプラグインアップデートのリリースノートを表示するために使用されます。

## 更新履歴のセットアップ

プラグイン向けのリリースノートの文書化をはじめる際、プラグインのリポジトリのルートに `CHANGELOG.md` ファイルを作成してください。このようなものを出発点として使用してください。

```markdown
# Release Notes for <Plugin Name>
```

更新履歴内では、リリースは**降順**（最新から古い順）でリストされている必要があります。（利用可能なプラグインアップデートを表示する際、プラグインストアはユーザーのインストールしているバージョンより古いか同じバージョンを見つけた時点で、プラグインの更新履歴のパースをストップします。）

## バージョン見出し

更新履歴のバージョン見出しは、次のフォーマットに従う必要があります。

```markdown
## X.Y.Z - YYYY-MM-DD
```

そこには多少の余地があります。

- プラグイン名のような他のテキストが、バージョン番号の前に来ることができます。
- 4番目のバージョン番号は許可されています（例：`1.2.3.4`）。
- プレリリース版は許可されています（例：`1.0.0-alpha.1`）。
- バージョンは `v` ではじめることができます（例：`v1.2.3`）。
- バージョンをハイパーリンクにすることができます（例：`[1.2.3]`）。
- 日付のセパレーターにハイフンではなくドットを使用できます（例：`2017.01.21`）。

このフォーマットに従わない H2 は、次の H2 までに続くいかなるコンテンツも含めて無視されます。

## リリースノート

バージョン見出し（次の H2 まで）に続くすべてのコンテンツは、そのアップデートのリリースノートとして扱われます。

リリースノートを書く際は [keepachangelog.com](https://keepachangelog.com/) のガイドラインに従うことをお勧めしますが、[GitHub Flavored Markdown](https://guides.github.com/features/mastering-markdown/#GitHub-flavored-markdown) のすべての形式が許可されています。許可 *されない* 唯一のものは、実際の HTML コードで、エスケープされます。

### ヒントと警告

次の構文を使用して、ヒント、警告、および、その他の注釈をリリースノートに含めることができます。

```markdown
> {tip} A helpful tip.

> {warning} A word of warning.

> {note} A note.
```

これらのいずれかを含むアップデートは、「ユーティリティ > アップデート」ページで自動的に展開されます。

### リンク

リリースノートに参照スタイルのリンクを持つ場合、次のバージョン見出しの *前に* URL を定義する必要があります。

```markdown
## 2.0.1 - 2017-02-01
### Fixed issue [#123]

[#123]: https://github.com/pixelandtonic/foo/issues/123

## 2.0.0 - 2017-01-31
### Added
- New [superFoo] config setting

[superFoo]: https://docs.foo.com/config#superFoo
```

## 重大なアップデート

重大なセキュリティ脆弱性や他の危険なバグの修正が含まれているアップデートの場合、バージョン見出しの最後に `[CRITICAL]` を追加することによってユーザーに警告することができます。

```markdown
## 2.0.1 - 2017-01-21 [CRITICAL]
### Fixed
- Reverted change to `$potus` due to security vulnerabilities
```

Craft は重大なアップデートが利用可能であることを知ったとき、すべてのコントロールパネルページの最上部にメッセージを掲載し、「ユーティリティ > アップデート」ページでアップデートに特別な注目を与えます。

