# プラグインストアでの配布

プラグインをシステム内のプラグインストアと [plugins.craftcms.com](https://plugins.craftcms.com/) で利用可能にしたい場合、このガイドに従ってください。

## ライセンスの選択

プラグインストア内のすべてのプラグインは、2つのライセンスのうちのいずれかでなければなりません。

- **[MIT](https://opensource.org/licenses/MIT)** – プラグインに対して請求を予定していない場合に使用します。あなたにクレジットを返す限り、あなたのコードで他の人がしたいことを行うことを許可します。（[実例](https://github.com/craftcms/element-api/blob/v2/LICENSE.md)）
- **[Craft](https://craftcms.github.io/license/)** – プラグインに対して請求を予定し、支払いなしであなたのコードを使用することを阻止したい場合に使用します。（[実例](https://github.com/craftcms/cms/blob/develop/LICENSE.md)）

プラグインリポジトリのルートに `LICENSE.md` ファイルを作成し、著作権表示からはじめて、ライセンステキストをペーストします。

```
Copyright © <YourName>
```

::: tip
Craft ライセンスにする場合、`composer.json` ファイルの `license` の値を `MIT` から `proprietary` に変更することを忘れないでください。
:::

## プラグインの登録

プラグインを登録するには、はじめに GitHub の公開リポジトリに公開されていることを確認してください。次に [id.craftcms.com](https://id.craftcms.com) で Craft ID アカウントを作成し、GitHub アカウントに接続します。

::: warning
プラグインが GitHub の organization アカウントで公開されている場合、GitHub アカウントの認証時にその組織がチェックされていることを確認してください。
:::

Craft ID アカウントから「Plugins」へ移動後に「Add a plugin」をクリックし、プラグインのリポジトリの横にある「Select」ボタンをクリックします。説明文、スクリーンショット、および、その他の詳細を編集できます。

### 価格の選択

プラグインを販売したい場合、筋が通っている価格を選択してください。考慮すべき推奨される価格帯は次の通りです。

| 価格帯 | 使用例 |
| ----------- | ------------------------------------------------------ |
| $10-$29 | 軽量な「プラグアンドプレイ」ユーティリティとインテグレーション |
| $49-$99 | 複雑なフィールドタイプとインテグレーション |
| $149-$249 | 重要な新しいシステム機能を追加するプラグイン |
| $499-$999 | 主要、または、高度にニッチなアプリケーション |

また、2年目以降に新しいアップデートをインストールしたい顧客にプラグインストアが請求する年額料金である更新価格を選択する必要があります。最初の価格のおよそ 20-50% で更新価格を選択してください。例えば、プラグインで $99 請求する場合、更新価格は $19-$49 の間にするべきです。

::: warning
最初にプラグインを無料で提出した場合、あとから商用に変更することはできません。ただし、無料エディションから重要な機能を削除しない限り、拡張機能を提供する商用[エディション](plugin-editions.md)を提供できます。
:::

### 承認のための提出

プラグインを提出するための準備ができたら、「Submit for approval」ボタンをクリックしてください。プラグインが承認されると、[plugins.craftcms.com](https://plugins.craftcms.com/) で表示されるようになります。プラグインが少なくとも1つの[リリース](#plugin-releases)を持っていない限り、アプリ内のプラグインストアで利用可能にならない点に注意してください。

::: tip
人々がコマンドラインからプラグインのインストールとアップデートすることもできるよう、プラグインストアに加えて [Packagist](https://packagist.org/) でプラグインを登録したいかもしれません。しかし、Packagist はプラグインストアの必須要件ではありません。
:::

## プラグインのリリース

プラグインの新しいバージョンをリリースするために、はじめにバージョン番号を決定してください。プラグインストアは Composer でサポートされているのと同じ [Semantic Versioning](https://semver.org/) 規約に従います。

- バージョンは3つ、または、4つのセグメント（例：`1.2.3` または `1.2.3.4`）が必要です。
- プレリリースバージョンには、リリース識別子（`-alpha.X`、`-beta.X`、または、`-RCX`）が必要です。

バージョンを決定したら、次のステップに従います。

1. プラグインが[更新履歴](changelogs-and-updates.md)を持つ場合、新しいバージョンがリリース日を含めた正しいフォーマットの見出しを持つことを確認してください。

   ```markdown
   ## 3.0.0 - 2018-03-31
   ```

2. プラグインの `composer.json` ファイルに `version` プロパティを含む場合、新しいバージョンがセットされていることを確認してください。

3. すべて問題なく Git にコミットされたら、オプションとして `v` からはじめてバージョン番号にちなんで名付けられた[タグを作成](https://git-scm.com/book/en/v2/Git-Basics-Tagging)してください（例：`v3.0.0` または `v3.0.0-beta.1`）。タグ名の接頭辞に `release-` を付けることも許可されています（例：`release-3.0.0` または `release-v3.0.0`）。

4. 最新のコミットと新しいバージョンタグを GitHub にプッシュしてください。この時点で、プラグインストアはそのリリースについて自動的に通知を受け取り、それを記録しはじめます。すべてうまくいった場合、1〜2分でプラグインストアに表示されます。

