# ガイド：ローカライズされたサイトの設定

これは、Craft のマルチサイト機能と翻訳サポートを利用して、一般的に必要となるすべてのステップを段階的に説明するガイドです。

## ステップ 1：サイトと言語の定義

ローカライズされたサイトを作成する最初のステップは、サポートが必要な言語を決定することです。その後、[Craft のマルチサイトをセットアップする際のガイド](sites.md)を使用して、サポートされる言語ごとの新しいサイトを Craft で作成します。 

## ステップ 2：セクションのアップデート

言語向けに新しいサイトを作成したら、それぞれのセクションで新しいサイトを有効にします。「設定 > セクション」で、ローカライズしたいサイトを含むセクションの設定に移動し、サイト設定でサイトを有効にします。そのサイトをどのような URL 構造にしたいかを反映するため、（チャンネルとストラクチャーセクション向けに）エントリー URI 形式、または（シングルセクション向けに）URI を記入します。

## ステップ 3：翻訳可能なフィールドの定義

「設定 > フィールド」で、翻訳可能にするフィールドを選択します。翻訳方法で「各言語に対して翻訳する」を選択します。

Craft は、それぞれのエントリにあるこのフィールドのコンテンツを言語単位で更新することを許可します。

## ステップ 4：テンプレートのアップデート

特定のサイトからだけ配信したいテンプレートがある場合、テンプレートフォルダに新しいサブフォルダを作成し、サイトのハンドルをフォルダ名にして、その中に手テンプレートを配置します。

例えば、ドイツ語のサイトのホームページを独自のテンプレートにする場合、テンプレートフォルダを次のように設定します。

```
templates/
├── index.twig      --> default homepage template
└── de/
    └── index.twig  --> German homepage template
```

`craft.app.language` を利用して、言語に依存するテンプレートの特定パーツを切り替えます。

```twig
{% if craft.app.language == 'de' %}
    <p>I like bread and beer.</p>
{% endif %}
```

テンプレート全体の文字列に Craft の[静的翻訳](static-translations.html)サポートを利用することもできます。

```twig
{{ "Welcome!"|t }}
```

## ステップ 5：投稿者にサイトへのアクセス権を付与

インストールされた Craft にサイトを追加すると、Craft はユーザーがコンテンツの編集を試みるたびに、サイトのパーミッションをチェックしはじめます。デフォルトでは、ユーザーやグループはどのサイトにもアクセスできないため、それらを割り当てる必要があります。

ユーザーグループやユーザーアカウントを編集するとき、すべてのサイトのリストに新しいサイトの「権利」セクションが表示されます。権限を与えたいものを割り当ててください。

