# サイト

Craft 3では、1つインストールするだけで複数のウェブサイトをホストできます。

ドメインが異なったり、異なるテンプレートセットを使用したり、エントリコンテンツの異なるバージョンを持っている、1つ以上のサイトを定義できます。

Craft のマルチサイト機能は、同じパブリッシングチームを持つサイトに向いています。サイトに含めたいセクションだけを有効化できる能力により、エントリレベルでマルチサイトのコンテンツを管理します。

## サイトの作成

Craft のインストールは、1つのデフォルトサイトからはじまります。サイト名はインストール時に定義され、ハンドルは `default` となります。

サイトを追加するには、「設定 > サイト」を使用します。

それぞれのサイトは、次の属性を持っています。

* グループ
* 名前
* ハンドル
* 言語
* これはプライマリサイトですか？
* ベース URL

### サイトグループ

サイトグループでは、言語や種類などの共通点によってサイトをひとまとめに整理できます。

Craft は（デフォルトサイトの名前を付けた）最初のサイトグループを作成し、そのグループにデフォルトサイトを割り当てます。

フィールドグループに似ていて、サイトグループは整理するためだけにあります。

現在のサイトグループの情報には、次のようにアクセスできます。

```twig
Site ID:            {{ currentSite.id }}
Site Handle:        {{ currentSite.handle }}
Site Name:          {{ currentSite.name }}
Site Language:      {{ currentSite.language }}
Is Primary Site?:   {{ currentSite.primary }}
Base URL:           {{ currentSite.baseUrl }}
```

### 言語

サイトの言語を選択すると、日付、時間、および、数字の書式と、翻訳の静的メッセージで使用するための言語を Craft に伝えます。

テンプレート内では、`craft.app.language` 経由で言語設定にアクセスすることもできます。これを条件文で使えます。

```twig
{% if craft.app.language == 'de' %}
    <p>Guten Tag!</p>
{% endif %}
```

あるいは、言語ごとの固有なテンプレートを自動的に含む方法もあります。

```twig
{% include '_share/footer-' ~ craft.app.language %}
```

この例では、読み込まれるテンプレート名は `_share/footer-de` になります。

### プライマリサイト

Craft はデフォルトサイトをプライマリサイトとしてセットします。すなわち、どのサイトをロードするか決定できない場合に Craft がフロントエンドのデフォルトとしてロードします。1つしかサイトがない場合、プライマリサイトを無効にできません。

追加のサイトを作成すると、プライマリサイトを変更できます。Craft は現在のプライマリサイトを自動的に切り替えます。

### サイト URL

すべてのサイトはベース URL を持っていて、Craft がエントリや他のサイトコンテンツの動的なリンクを生成する際に出発点として使用します。

マルチサイトは `https://craftcms.com/` や `https://craftcms.com/de/` のように同じホスト名を共有したり、`https://craftcms.com/` や `https://de.craftcms.com/` のように異なるホスト名を持つこともできます。

異なるホスト名でサイトを作成したい場合、それに対するトラフィックを処理するようサーバーを設定しなければなりません。ホスト名は現在のサイトと同じウェブルート（`web/`）を指すことも、独自の別のウェブルートにすることもできます。後者の場合、`.htaccess`、および、`index.php` ファイルを新しいウェブルートへ確実にコピーしてください。

::: tip
`https://site-a.com` と `https://site-b.com` のような異なるルートドメインを使用するマルチサイトを持つ場合、Craft の [license enforcements works](https://craftcms.com/support/license-enforcement) の仕組みによって、_すべて_ のサイトのためにアクセスする Craft コントロールパネルのドメインをその中の1つから選択することができます。
:::

::: warning
サイトのベース URL を定義する場合、`@web` エイリアスを使用しないでください。それは [cache poisoning](https://www.owasp.org/index.php/Cache_Poisoning) の脆弱性をもたらすことができ、リクエストされたサイトを Craft が確実に判断することができなくなります。
:::

## すべての有効サイトにエントリを広げる

それぞれのチャンネルセクションの設定には、すべてのサイトにエントリを広げるためのオプションがあります。これはデフォルトで有効になっていて、シングルやストラクチャーセクションでは、必ず有効な状態となります。

有効にすると、Craft は送信されたコンテンツを使用して、そのセクションで有効になっているそれぞれのサイトに新しいエントリを作成します。

セクションのコンテンツをサイトごとに分離したい場合、そのセクションにあるこのオプションを無効にします。

## ガイド：新しいサイトの設定

これは、Craft で新しいサイトをセットアップするステップを段階的に説明するショートガイドです。このガイドは、すでに Craft がインストールされていて、デフォルトのセットアップや設定が済んでいることを前提としています。

### ステップ 1：設定でサイトを作成

最初のステップは、インストール済みの Craft の設定で新しいサイトを作成することです。

1. 「設定 > サイト」に移動し、「新しいサイト」ボタンをクリックします。
2. ドロップダウンメニューからサイトが所属するグループを選択します。グループの選択により、サイトの機能に影響することはありません。
3. 名前を付けてください。Craft はコントロールパネルのサイト名を利用し、`{{ siteName }}` を使ってテンプレート内に表示することもできます。
4. サイト名をベースにして、Craft はサイトのハンドルを生成します。あなたが望むなら、ハンドルを編集できます。テンプレート内でこのサイトを参照するために、サイトハンドルを利用します。
5. サイトの言語を選択してください。（言語の使い方の詳細は、上記を参照してください）
6. このサイトをプライマリサイトにする場合は、「これはプライマリサイトですか？」をオンにします。to enable it.
7. 「このサイトには独自の基本 URL があります」のチェックボックスをオンにし、ベース URL を入力します。この例では `https://beta.craftcms.com` になります。
8. 新しいサイトを保存します。

### ステップ 2：テンプレートディレクトリの作成

新しいサイト向けに、テンプレートディレクトリとテンプレートを作成します。

サイトハンドルを名前に付けたテンプレートディレクトリ（例： `templates/default` と `templates/beta`）を持たせることをオススメします。それぞれのサイトのテンプレートディレクトリに、サイト固有のテンプレートを保管します。

### ステップ 3：サイトのセクションとフィールドのアップデート

1. 新しいサイトで有効にしたいセクションに移動し、「サイト設定」テーブルを利用してサイトを有効にします。
2. 各セクションの新しいサイト向けに、エントリー URI 形式、テンプレート、および、デフォルトのステータスを定義します。
3. すべての有効サイトにエントリを広げるかどうかを選択します。チェックした場合、Craft はシステム内のすべてのサイトに新しいエントリを作成します。このオプションがチェックされていない場合、Craft は現在選択されているサイトのみに新しエントリを保存します。

### ステップ 4：フィールドの翻訳方法の定義

デフォルトでは、カスタムフィールドはサイト単位で値を保存します。本文フィールドがある場合、それぞれのサイトはそのフィールドのコンテンツだけを保存できます。

サイトがデフォルトの言語と異なる言語を持つ場合、それぞれのフィールドを（サイト、言語、またはサイトグループに対して）翻訳可能に設定する必要があります。

翻訳方法をセットするには、翻訳したいそれぞれのフィールドに移動し、翻訳方法で適切なオプションを選択します。

### ステップ 5：設定のテスト

新規または既存のエントリを利用し、セクション、フィールド、および、翻訳方法の設定が期待通りに機能しているかテストします。

### ステップ 6：アセットボリューム設定の確認

ローカルのアセットボリュームがある場合、それらのアセットがそれぞれのサイトから利用可能であることを確認する必要があります。

* 「ファイルシステムのパス」設定は、相対的（`uploads/images/`）であるべきです
* URL の設定は、 相対的（`/images`）であるべきです

### ステップ 7：ウェブサーバーと DNS の設定

1. ドメイン（例： `beta.craftcms.com`）が `web` ディレクトリを参照するよう、ウェブサーバーを設定します。Craft はブラウザがどのサイトを要求しているかを自動的に検出します。
2. ドメインがウェブサーバーを指すよう、DNS レコードをアップデートします。

