# アップデートガイド

## コントロールパネルからのアップデート

アップデートが可能になると、Craft のアップデート権限を持つユーザーは CP のサイドバーにあるナビゲーション項目「ユーティリティ」の横にバッジを確認できるようになります。「ユーティリティ」をクリックし、その後「アップデート」を選択します。デフォルトでインストールされているコントロールパネルのダッシュボードにあるアップデートウィジェットを利用することもできます。

このセクションには、Craft CMS のアップデートとプラグインのアップデートの両方を表示します。それぞれのアップデートは、それ自身の「アップデート」ボタンを持っています。クリックすると、 Craft の自動更新プロセスが開始されます。

アップデートページの左上にある「すべてを更新」ボタンを使用して、（アップデート可能な Craft とプラグイン）すべてのアップデートを実行できます。

## ターミナルからのアップデート

Craft 3.0.38 および 3.1.4 では、Craft およびプラグインのアップデートで利用可能な新しい `update` コンソールコマンドが導入されました。

利用可能なアップデートを確認するには、ターミナルで Craft プロジェクトに移動し、次のコマンドを実行してください。

```bash
./craft update
```

![`update` コマンドによるインタラクションの例。](./images/cli-update-info.png)

一度にすべてをアップデートするには、次のコマンドを実行します。

```bash
./craft update all
```

特定のものをアップデートするには、`all` をそのハンドル（Craft をアップデートするための `craft`、または、プラグインのハンドルのいずれか）に置き換えます。

```bash
./craft update element-api
```

![`update <handle>` コマンドによるインタラクションの例。](./images/cli-update-plugin.png)

一度に複数のハンドルを渡すこともできます。

```bash
./craft update element-api commerce
```

デフォルトでは、Craft は利用可能な最新バージョンにアップデートします。特定バージョンにアップデートするには、ハンドルに `:<version>` を追加します。

```bash
./craft update element-api:2.5.4
```

Craft は `composer install` コマンドのように動作する `update/composer-install` コマンドも提供しますが、Composer をインストールする必要はありません。

