# Craft 2 からのアップグレード

サイトを Craft 3 にアップグレードするための最初のステップは、CMS 自体をアップデートすることです。

## アップグレードのための準備

はじめる前に、次のことを確認してください。

- あなたは[Craft 3 の変更点](changes-in-craft-3.md)を確認しました。
- あなたのサーバーは Craft 3 の[最小要件](requirements.md)（Craft 3 には PHP 7 以降が必要で、PHP 割当メモリが少なくとも 256 MB 必要です）を満たしています。
- あなたのサイトは、少なくとも **Craft 2.6.2788** が実行されています。
- プラグインはすべて最新の状態で、それらが Craft 3 向けにアップデートされていることを確かめました。（Craft 2 コントロールパネルのアップデートページから、プラグインの Craft 3 互換ステータスのレポートを見ることができます。）
- なんらかの問題が起こった場合に備えて、**データベースをバックアップ**してあります。

上記リストをすべて満たしているなら、アップグレードプロセスを続行できます。

## アップグレードの実行

Craft 2 サイトをアップグレードする最善の方法は、新しい Craft 3 サイトを構築するときと同様のアプローチをとることです。はじめに、既存のプロジェクトと並行する新しいディレクトリを作成し、[インストールガイド](installation.md)のステップ 1 〜 3 に従ってください。

Craft 3 をダウンロードして準備したら、次のステップに従ってアップグレードを完了します。

1. 古い `craft/config/db.php` から新しいプロジェクトの `.env` ファイルにデータベース接続設定を定義します。

    ::: tip
    現在のテーブル接頭辞がそれである場合、`DB_TABLE_PREFIX="craft"` を忘れずにセットしてください。
    :::

2. 古い `craft/config/general.php` ファイルのすべての設定を新しいプロジェクトの `config/general.php` ファイルにコピーします。

3. 古い `craft/config/license.key` ファイルを新しいプロジェクトの `config/` フォルダにコピーします。

4. 古いカスタムの Redactor 設定ファイルを `craft/config/redactor/` から新しいプロジェクトの `config/redactor/` ディレクトリにコピーします。

5. 古いカスタムのログインページのロゴやサイトアイコンファイルを `craft/storage/rebrand/` から新しいプロジェクトの `storage/rebrand/` ディレクトリにコピーします。

6. 古いユーザーフォトを `craft/storage/userphotos/` から新しいプロジェクトの `storage/userphotos/` ディレクトリにコピーします。

7. 古いテンプレートを `craft/templates/` から新しいプロジェクトの `templates/` ディレクトリにコピーします。

8. `public/index.php` ファイルに何らかの変更を加えていた場合、それらを新しいプロジェクトの `web/index.php` ファイルにコピーします。

9. 古い `public/` ディレクトリに含まれるすべてのファイルを新しいプロジェクトの `web/` ディレクトリにコピーします。

10. 新しいプロジェクトの `web/` ディレクトリを参照するよう、ウェブサーバーの設定をアップデートします。

11. ブラウザでコントロールパネルの URL（例： `http://my-project.test/admin`）にアクセスします。アップデートのプロンプトが表示されたら、すべてが正しく実行されています！「Finish up（完了）」ボタンをクリックしてデータベースを更新してください。

12. プラグインをインストールしている場合、コントロールパネルの「プラグインストア」セクションから Craft 3 対応版をインストールする必要があります。（追加のアップグレードガイドについては、プラグインのドキュメントを参照してください。）

これで Craft 2 プロジェクトから Craft 3 へのアップグレードが完了しました。[Craft 3 の変更点](changes-in-craft-3.md)を確認する時間を設けてください。

## トラブルシューティング

#### コントロールパネルにアクセスすると Craft のインストーラーが表示されます。

これが起こるのは、`.env` ファイルのデータベース接続情報が実際に必要な情報と完全に一致しないためです。多くの場合、正しい `DB_TABLE_PREFIX` を設定するのを忘れています。

#### 「Setting unknown property: craft\config\DbConfig::initSQLs」エラーが表示されます。

Craft 2 の MySQL 5.7 サポートのための修正のみに使用され、もはや必要ではなくなった `initSQLs` データベース設定が Craft 3 で削除されました。`config/db.php` ファイルを開いて、`'initSQLs'` からはじまる行を削除してください。

