<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd/M/y',
            'time' => 'HH.mm',
            'datetime' => 'd/M/y HH.mm',
        ],
        'medium' => [
            'date' => 'd. MMM y',
            'time' => 'HH.mm.ss',
            'datetime' => 'd. MMM y HH.mm.ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'HH.mm.ss z',
            'datetime' => 'd. MMMM y \'kl\'. HH.mm.ss z',
        ],
        'full' => [
            'date' => 'EEEE \'den\' d. MMMM y',
            'time' => 'HH.mm.ss zzzz',
            'datetime' => 'EEEE \'den\' d. MMMM y \'kl\'. HH.mm.ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan',
            'feb',
            'mar',
            'apr',
            'maj',
            'jun',
            'jul',
            'aug',
            'sep',
            'okt',
            'nov',
            'dec',
        ],
        'full' => [
            'januar',
            'februar',
            'marts',
            'april',
            'maj',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maj',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'januar',
            'februar',
            'marts',
            'april',
            'maj',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø',
            'ma',
            'ti',
            'on',
            'to',
            'fr',
            'lø',
        ],
        'medium' => [
            'søn',
            'man',
            'tir',
            'ons',
            'tor',
            'fre',
            'lør',
        ],
        'full' => [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø',
            'ma',
            'ti',
            'on',
            'to',
            'fr',
            'lø',
        ],
        'medium' => [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.',
        ],
        'full' => [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Sydafrika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Cameroun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amharisk',
        'am-ET' => 'amharisk (Etiopien)',
        'ar' => 'arabisk',
        'ar-001' => 'arabisk (Verden)',
        'ar-AE' => 'arabisk (De Forenede Arabiske Emirater)',
        'ar-BH' => 'arabisk (Bahrain)',
        'ar-DJ' => 'arabisk (Djibouti)',
        'ar-DZ' => 'arabisk (Algeriet)',
        'ar-EG' => 'arabisk (Egypten)',
        'ar-EH' => 'arabisk (Vestsahara)',
        'ar-ER' => 'arabisk (Eritrea)',
        'ar-IL' => 'arabisk (Israel)',
        'ar-IQ' => 'arabisk (Irak)',
        'ar-JO' => 'arabisk (Jordan)',
        'ar-KM' => 'arabisk (Comorerne)',
        'ar-KW' => 'arabisk (Kuwait)',
        'ar-LB' => 'arabisk (Libanon)',
        'ar-LY' => 'arabisk (Libyen)',
        'ar-MA' => 'arabisk (Marokko)',
        'ar-MR' => 'arabisk (Mauretanien)',
        'ar-OM' => 'arabisk (Oman)',
        'ar-PS' => 'arabisk (De palæstinensiske områder)',
        'ar-QA' => 'arabisk (Qatar)',
        'ar-SA' => 'arabisk (Saudi-Arabien)',
        'ar-SD' => 'arabisk (Sudan)',
        'ar-SO' => 'arabisk (Somalia)',
        'ar-SS' => 'arabisk (Sydsudan)',
        'ar-SY' => 'arabisk (Syrien)',
        'ar-TD' => 'arabisk (Tchad)',
        'ar-TN' => 'arabisk (Tunesien)',
        'ar-YE' => 'arabisk (Yemen)',
        'as' => 'assamesisk',
        'as-IN' => 'assamesisk (Indien)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturisk',
        'ast-ES' => 'asturisk (Spanien)',
        'az' => 'aserbajdsjansk',
        'az-Cyrl' => 'aserbajdsjansk (kyrillisk)',
        'az-Cyrl-AZ' => 'aserbajdsjansk (kyrillisk, Aserbajdsjan)',
        'az-Latn' => 'aserbajdsjansk (latinsk)',
        'az-Latn-AZ' => 'aserbajdsjansk (latinsk, Aserbajdsjan)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Cameroun)',
        'be' => 'hviderussisk',
        'be-BY' => 'hviderussisk (Hviderusland)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'bulgarsk',
        'bg-BG' => 'bulgarsk (Bulgarien)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (Indien)',
        'bo' => 'tibetansk',
        'bo-CN' => 'tibetansk (Kina)',
        'bo-IN' => 'tibetansk (Indien)',
        'br' => 'bretonsk',
        'br-FR' => 'bretonsk (Frankrig)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (Indien)',
        'bs' => 'bosnisk',
        'bs-Cyrl' => 'bosnisk (kyrillisk)',
        'bs-Cyrl-BA' => 'bosnisk (kyrillisk, Bosnien-Hercegovina)',
        'bs-Latn' => 'bosnisk (latinsk)',
        'bs-Latn-BA' => 'bosnisk (latinsk, Bosnien-Hercegovina)',
        'ca' => 'catalansk',
        'ca-AD' => 'catalansk (Andorra)',
        'ca-ES' => 'catalansk (Spanien)',
        'ca-FR' => 'catalansk (Frankrig)',
        'ca-IT' => 'catalansk (Italien)',
        'ce' => 'tjetjensk',
        'ce-RU' => 'tjetjensk (Rusland)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'cherokee',
        'chr-US' => 'cherokee (USA)',
        'cs' => 'tjekkisk',
        'cs-CZ' => 'tjekkisk (Tjekkiet)',
        'cy' => 'walisisk',
        'cy-GB' => 'walisisk (Storbritannien)',
        'da' => 'dansk',
        'da-DK' => 'dansk (Danmark)',
        'da-GL' => 'dansk (Grønland)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'tysk',
        'de-AT' => 'tysk (Østrig)',
        'de-BE' => 'tysk (Belgien)',
        'de-CH' => 'tysk (Schweiz)',
        'de-DE' => 'tysk (Tyskland)',
        'de-LI' => 'tysk (Liechtenstein)',
        'de-LU' => 'tysk (Luxembourg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'nedersorbisk',
        'dsb-DE' => 'nedersorbisk (Tyskland)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Cameroun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhutan)',
        'ebu' => 'kiembu',
        'ebu-KE' => 'kiembu (Kenya)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'græsk',
        'el-CY' => 'græsk (Cypern)',
        'el-GR' => 'græsk (Grækenland)',
        'en' => 'engelsk',
        'en-001' => 'engelsk (Verden)',
        'en-150' => 'engelsk (Europa)',
        'en-AG' => 'engelsk (Antigua og Barbuda)',
        'en-AI' => 'engelsk (Anguilla)',
        'en-AS' => 'engelsk (Amerikansk Samoa)',
        'en-AT' => 'engelsk (Østrig)',
        'en-AU' => 'engelsk (Australien)',
        'en-BB' => 'engelsk (Barbados)',
        'en-BE' => 'engelsk (Belgien)',
        'en-BI' => 'engelsk (Burundi)',
        'en-BM' => 'engelsk (Bermuda)',
        'en-BS' => 'engelsk (Bahamas)',
        'en-BW' => 'engelsk (Botswana)',
        'en-BZ' => 'engelsk (Belize)',
        'en-CA' => 'engelsk (Canada)',
        'en-CC' => 'engelsk (Cocosøerne)',
        'en-CH' => 'engelsk (Schweiz)',
        'en-CK' => 'engelsk (Cookøerne)',
        'en-CM' => 'engelsk (Cameroun)',
        'en-CX' => 'engelsk (Juleøen)',
        'en-CY' => 'engelsk (Cypern)',
        'en-DE' => 'engelsk (Tyskland)',
        'en-DG' => 'engelsk (Diego Garcia)',
        'en-DK' => 'engelsk (Danmark)',
        'en-DM' => 'engelsk (Dominica)',
        'en-ER' => 'engelsk (Eritrea)',
        'en-FI' => 'engelsk (Finland)',
        'en-FJ' => 'engelsk (Fiji)',
        'en-FK' => 'engelsk (Falklandsøerne)',
        'en-FM' => 'engelsk (Mikronesiens Forenede Stater)',
        'en-GB' => 'engelsk (Storbritannien)',
        'en-GD' => 'engelsk (Grenada)',
        'en-GG' => 'engelsk (Guernsey)',
        'en-GH' => 'engelsk (Ghana)',
        'en-GI' => 'engelsk (Gibraltar)',
        'en-GM' => 'engelsk (Gambia)',
        'en-GU' => 'engelsk (Guam)',
        'en-GY' => 'engelsk (Guyana)',
        'en-HK' => 'engelsk (Hongkong SAR)',
        'en-IE' => 'engelsk (Irland)',
        'en-IL' => 'engelsk (Israel)',
        'en-IM' => 'engelsk (Isle of Man)',
        'en-IN' => 'engelsk (Indien)',
        'en-IO' => 'engelsk (Det britiske territorium i Det Indiske Ocean)',
        'en-JE' => 'engelsk (Jersey)',
        'en-JM' => 'engelsk (Jamaica)',
        'en-KE' => 'engelsk (Kenya)',
        'en-KI' => 'engelsk (Kiribati)',
        'en-KN' => 'engelsk (Saint Kitts og Nevis)',
        'en-KY' => 'engelsk (Caymanøerne)',
        'en-LC' => 'engelsk (Saint Lucia)',
        'en-LR' => 'engelsk (Liberia)',
        'en-LS' => 'engelsk (Lesotho)',
        'en-MG' => 'engelsk (Madagaskar)',
        'en-MH' => 'engelsk (Marshalløerne)',
        'en-MO' => 'engelsk (Macao SAR)',
        'en-MP' => 'engelsk (Nordmarianerne)',
        'en-MS' => 'engelsk (Montserrat)',
        'en-MT' => 'engelsk (Malta)',
        'en-MU' => 'engelsk (Mauritius)',
        'en-MW' => 'engelsk (Malawi)',
        'en-MY' => 'engelsk (Malaysia)',
        'en-NA' => 'engelsk (Namibia)',
        'en-NF' => 'engelsk (Norfolk Island)',
        'en-NG' => 'engelsk (Nigeria)',
        'en-NL' => 'engelsk (Holland)',
        'en-NR' => 'engelsk (Nauru)',
        'en-NU' => 'engelsk (Niue)',
        'en-NZ' => 'engelsk (New Zealand)',
        'en-PG' => 'engelsk (Papua Ny Guinea)',
        'en-PH' => 'engelsk (Filippinerne)',
        'en-PK' => 'engelsk (Pakistan)',
        'en-PN' => 'engelsk (Pitcairn)',
        'en-PR' => 'engelsk (Puerto Rico)',
        'en-PW' => 'engelsk (Palau)',
        'en-RW' => 'engelsk (Rwanda)',
        'en-SB' => 'engelsk (Salomonøerne)',
        'en-SC' => 'engelsk (Seychellerne)',
        'en-SD' => 'engelsk (Sudan)',
        'en-SE' => 'engelsk (Sverige)',
        'en-SG' => 'engelsk (Singapore)',
        'en-SH' => 'engelsk (St. Helena)',
        'en-SI' => 'engelsk (Slovenien)',
        'en-SL' => 'engelsk (Sierra Leone)',
        'en-SS' => 'engelsk (Sydsudan)',
        'en-SX' => 'engelsk (Sint Maarten)',
        'en-SZ' => 'engelsk (Swaziland)',
        'en-TC' => 'engelsk (Turks- og Caicosøerne)',
        'en-TK' => 'engelsk (Tokelau)',
        'en-TO' => 'engelsk (Tonga)',
        'en-TT' => 'engelsk (Trinidad og Tobago)',
        'en-TV' => 'engelsk (Tuvalu)',
        'en-TZ' => 'engelsk (Tanzania)',
        'en-UG' => 'engelsk (Uganda)',
        'en-UM' => 'engelsk (Amerikanske oversøiske øer)',
        'en-US' => 'engelsk (USA)',
        'en-US-POSIX' => 'engelsk (USA, computer)',
        'en-VC' => 'engelsk (Saint Vincent og Grenadinerne)',
        'en-VG' => 'engelsk (De Britiske Jomfruøer)',
        'en-VI' => 'engelsk (De Amerikanske Jomfruøer)',
        'en-VU' => 'engelsk (Vanuatu)',
        'en-WS' => 'engelsk (Samoa)',
        'en-ZA' => 'engelsk (Sydafrika)',
        'en-ZM' => 'engelsk (Zambia)',
        'en-ZW' => 'engelsk (Zimbabwe)',
        'eo' => 'esperanto',
        'es' => 'spansk',
        'es-419' => 'spansk (Latinamerika)',
        'es-AR' => 'spansk (Argentina)',
        'es-BO' => 'spansk (Bolivia)',
        'es-CL' => 'spansk (Chile)',
        'es-CO' => 'spansk (Colombia)',
        'es-CR' => 'spansk (Costa Rica)',
        'es-CU' => 'spansk (Cuba)',
        'es-DO' => 'spansk (Den Dominikanske Republik)',
        'es-EA' => 'spansk (Ceuta og Melilla)',
        'es-EC' => 'spansk (Ecuador)',
        'es-ES' => 'spansk (Spanien)',
        'es-GQ' => 'spansk (Ækvatorialguinea)',
        'es-GT' => 'spansk (Guatemala)',
        'es-HN' => 'spansk (Honduras)',
        'es-IC' => 'spansk (Kanariske øer)',
        'es-MX' => 'spansk (Mexico)',
        'es-NI' => 'spansk (Nicaragua)',
        'es-PA' => 'spansk (Panama)',
        'es-PE' => 'spansk (Peru)',
        'es-PH' => 'spansk (Filippinerne)',
        'es-PR' => 'spansk (Puerto Rico)',
        'es-PY' => 'spansk (Paraguay)',
        'es-SV' => 'spansk (El Salvador)',
        'es-US' => 'spansk (USA)',
        'es-UY' => 'spansk (Uruguay)',
        'es-VE' => 'spansk (Venezuela)',
        'et' => 'estisk',
        'et-EE' => 'estisk (Estland)',
        'eu' => 'baskisk',
        'eu-ES' => 'baskisk (Spanien)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Cameroun)',
        'fa' => 'persisk',
        'fa-AF' => 'persisk (Afghanistan)',
        'fa-IR' => 'persisk (Iran)',
        'ff' => 'fulah',
        'ff-CM' => 'fulah (Cameroun)',
        'ff-GN' => 'fulah (Guinea)',
        'ff-MR' => 'fulah (Mauretanien)',
        'ff-SN' => 'fulah (Senegal)',
        'fi' => 'finsk',
        'fi-FI' => 'finsk (Finland)',
        'fil' => 'filippinsk',
        'fil-PH' => 'filippinsk (Filippinerne)',
        'fo' => 'færøsk',
        'fo-DK' => 'færøsk (Danmark)',
        'fo-FO' => 'færøsk (Færøerne)',
        'fr' => 'fransk',
        'fr-BE' => 'fransk (Belgien)',
        'fr-BF' => 'fransk (Burkina Faso)',
        'fr-BI' => 'fransk (Burundi)',
        'fr-BJ' => 'fransk (Benin)',
        'fr-BL' => 'fransk (Saint Barthélemy)',
        'fr-CA' => 'fransk (Canada)',
        'fr-CD' => 'fransk (Congo-Kinshasa)',
        'fr-CF' => 'fransk (Den Centralafrikanske Republik)',
        'fr-CG' => 'fransk (Congo-Brazzaville)',
        'fr-CH' => 'fransk (Schweiz)',
        'fr-CI' => 'fransk (Elfenbenskysten)',
        'fr-CM' => 'fransk (Cameroun)',
        'fr-DJ' => 'fransk (Djibouti)',
        'fr-DZ' => 'fransk (Algeriet)',
        'fr-FR' => 'fransk (Frankrig)',
        'fr-GA' => 'fransk (Gabon)',
        'fr-GF' => 'fransk (Fransk Guyana)',
        'fr-GN' => 'fransk (Guinea)',
        'fr-GP' => 'fransk (Guadeloupe)',
        'fr-GQ' => 'fransk (Ækvatorialguinea)',
        'fr-HT' => 'fransk (Haiti)',
        'fr-KM' => 'fransk (Comorerne)',
        'fr-LU' => 'fransk (Luxembourg)',
        'fr-MA' => 'fransk (Marokko)',
        'fr-MC' => 'fransk (Monaco)',
        'fr-MF' => 'fransk (Saint Martin)',
        'fr-MG' => 'fransk (Madagaskar)',
        'fr-ML' => 'fransk (Mali)',
        'fr-MQ' => 'fransk (Martinique)',
        'fr-MR' => 'fransk (Mauretanien)',
        'fr-MU' => 'fransk (Mauritius)',
        'fr-NC' => 'fransk (Ny Kaledonien)',
        'fr-NE' => 'fransk (Niger)',
        'fr-PF' => 'fransk (Fransk Polynesien)',
        'fr-PM' => 'fransk (Saint Pierre og Miquelon)',
        'fr-RE' => 'fransk (Réunion)',
        'fr-RW' => 'fransk (Rwanda)',
        'fr-SC' => 'fransk (Seychellerne)',
        'fr-SN' => 'fransk (Senegal)',
        'fr-SY' => 'fransk (Syrien)',
        'fr-TD' => 'fransk (Tchad)',
        'fr-TG' => 'fransk (Togo)',
        'fr-TN' => 'fransk (Tunesien)',
        'fr-VU' => 'fransk (Vanuatu)',
        'fr-WF' => 'fransk (Wallis og Futuna)',
        'fr-YT' => 'fransk (Mayotte)',
        'fur' => 'friulian',
        'fur-IT' => 'friulian (Italien)',
        'fy' => 'frisisk',
        'fy-NL' => 'frisisk (Holland)',
        'ga' => 'irsk',
        'ga-IE' => 'irsk (Irland)',
        'gd' => 'skotsk gælisk',
        'gd-GB' => 'skotsk gælisk (Storbritannien)',
        'gl' => 'galicisk',
        'gl-ES' => 'galicisk (Spanien)',
        'gsw' => 'schweizertysk',
        'gsw-CH' => 'schweizertysk (Schweiz)',
        'gsw-FR' => 'schweizertysk (Frankrig)',
        'gsw-LI' => 'schweizertysk (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (Indien)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenya)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Isle of Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiiansk',
        'haw-US' => 'hawaiiansk (USA)',
        'he' => 'hebraisk',
        'he-IL' => 'hebraisk (Israel)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (Indien)',
        'hr' => 'kroatisk',
        'hr-BA' => 'kroatisk (Bosnien-Hercegovina)',
        'hr-HR' => 'kroatisk (Kroatien)',
        'hsb' => 'øvresorbisk',
        'hsb-DE' => 'øvresorbisk (Tyskland)',
        'hu' => 'ungarsk',
        'hu-HU' => 'ungarsk (Ungarn)',
        'hy' => 'armensk',
        'hy-AM' => 'armensk (Armenien)',
        'id' => 'indonesisk',
        'id-ID' => 'indonesisk (Indonesien)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigeria)',
        'ii' => 'sichuan yi',
        'ii-CN' => 'sichuan yi (Kina)',
        'is' => 'islandsk',
        'is-IS' => 'islandsk (Island)',
        'it' => 'italiensk',
        'it-CH' => 'italiensk (Schweiz)',
        'it-IT' => 'italiensk (Italien)',
        'it-SM' => 'italiensk (San Marino)',
        'ja' => 'japansk',
        'ja-JP' => 'japansk (Japan)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Cameroun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzania)',
        'ka' => 'georgisk',
        'ka-GE' => 'georgisk (Georgien)',
        'kab' => 'kabylisk',
        'kab-DZ' => 'kabylisk (Algeriet)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'kapverdisk',
        'kea-CV' => 'kapverdisk (Kap Verde)',
        'khq' => 'koyra-chiini',
        'khq-ML' => 'koyra-chiini (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kasakhisk',
        'kk-KZ' => 'kasakhisk (Kasakhstan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Cameroun)',
        'kl' => 'grønlandsk',
        'kl-GL' => 'grønlandsk (Grønland)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Cambodja)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (Indien)',
        'ko' => 'koreansk',
        'ko-KP' => 'koreansk (Nordkorea)',
        'ko-KR' => 'koreansk (Sydkorea)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (Indien)',
        'ks' => 'kashmiri',
        'ks-IN' => 'kashmiri (Indien)',
        'ksb' => 'shambala',
        'ksb-TZ' => 'shambala (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Cameroun)',
        'ksh' => 'kölsch',
        'ksh-DE' => 'kölsch (Tyskland)',
        'kw' => 'cornisk',
        'kw-GB' => 'cornisk (Storbritannien)',
        'ky' => 'kirgisisk',
        'ky-KG' => 'kirgisisk (Kirgisistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'luxembourgsk',
        'lb-LU' => 'luxembourgsk (Luxembourg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (USA)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Congo-Kinshasa)',
        'ln-CF' => 'lingala (Den Centralafrikanske Republik)',
        'ln-CG' => 'lingala (Congo-Brazzaville)',
        'lo' => 'lao',
        'lo-LA' => 'lao (Laos)',
        'lrc' => 'nordluri',
        'lrc-IQ' => 'nordluri (Irak)',
        'lrc-IR' => 'nordluri (Iran)',
        'lt' => 'litauisk',
        'lt-LT' => 'litauisk (Litauen)',
        'lu' => 'luba-Katanga',
        'lu-CD' => 'luba-Katanga (Congo-Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'luyana',
        'luy-KE' => 'luyana (Kenya)',
        'lv' => 'lettisk',
        'lv-LV' => 'lettisk (Letland)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenya)',
        'mfe' => 'morisyen',
        'mfe-MU' => 'morisyen (Mauritius)',
        'mg' => 'malagassisk',
        'mg-MG' => 'malagassisk (Madagaskar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mozambique)',
        'mgo' => 'meta',
        'mgo-CM' => 'meta (Cameroun)',
        'mk' => 'makedonsk',
        'mk-MK' => 'makedonsk (Makedonien)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (Indien)',
        'mn' => 'mongolsk',
        'mn-MN' => 'mongolsk (Mongoliet)',
        'mr' => 'marathisk',
        'mr-IN' => 'marathisk (Indien)',
        'ms' => 'malajisk',
        'ms-BN' => 'malajisk (Brunei)',
        'ms-MY' => 'malajisk (Malaysia)',
        'ms-SG' => 'malajisk (Singapore)',
        'mt' => 'maltesisk',
        'mt-MT' => 'maltesisk (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Cameroun)',
        'my' => 'burmesisk',
        'my-MM' => 'burmesisk (Myanmar [Burma])',
        'mzn' => 'mazenisk',
        'mzn-IR' => 'mazenisk (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'norsk bokmål',
        'nb-NO' => 'norsk bokmål (Norge)',
        'nb-SJ' => 'norsk bokmål (Svalbard og Jan Mayen)',
        'nd' => 'nordndebele',
        'nd-ZW' => 'nordndebele (Zimbabwe)',
        'ne' => 'nepalesisk',
        'ne-IN' => 'nepalesisk (Indien)',
        'ne-NP' => 'nepalesisk (Nepal)',
        'nl' => 'hollandsk',
        'nl-AW' => 'hollandsk (Aruba)',
        'nl-BE' => 'hollandsk (Belgien)',
        'nl-BQ' => 'hollandsk (De Nederlandske Antiller)',
        'nl-CW' => 'hollandsk (Curaçao)',
        'nl-NL' => 'hollandsk (Holland)',
        'nl-SR' => 'hollandsk (Surinam)',
        'nl-SX' => 'hollandsk (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Cameroun)',
        'nn' => 'nynorsk',
        'nn-NO' => 'nynorsk (Norge)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Cameroun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sydsudan)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopien)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'oriya',
        'or-IN' => 'oriya (Indien)',
        'os' => 'ossetisk',
        'os-GE' => 'ossetisk (Georgien)',
        'os-RU' => 'ossetisk (Rusland)',
        'pa' => 'punjabi',
        'pa-Arab' => 'punjabi (arabisk)',
        'pa-Arab-PK' => 'punjabi (arabisk, Pakistan)',
        'pa-Guru' => 'punjabi (gurmukhi)',
        'pa-Guru-IN' => 'punjabi (gurmukhi, Indien)',
        'pl' => 'polsk',
        'pl-PL' => 'polsk (Polen)',
        'ps' => 'pashto',
        'ps-AF' => 'pashto (Afghanistan)',
        'pt' => 'portugisisk',
        'pt-AO' => 'portugisisk (Angola)',
        'pt-BR' => 'portugisisk (Brasilien)',
        'pt-CV' => 'portugisisk (Kap Verde)',
        'pt-GW' => 'portugisisk (Guinea-Bissau)',
        'pt-MO' => 'portugisisk (Macao SAR)',
        'pt-MZ' => 'portugisisk (Mozambique)',
        'pt-PT' => 'portugisisk (Portugal)',
        'pt-ST' => 'portugisisk (São Tomé og Príncipe)',
        'pt-TL' => 'portugisisk (Timor-Leste)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Peru)',
        'rm' => 'rætoromansk',
        'rm-CH' => 'rætoromansk (Schweiz)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumænsk',
        'ro-MD' => 'rumænsk (Moldova)',
        'ro-RO' => 'rumænsk (Rumænien)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'russisk',
        'ru-BY' => 'russisk (Hviderusland)',
        'ru-KG' => 'russisk (Kirgisistan)',
        'ru-KZ' => 'russisk (Kasakhstan)',
        'ru-MD' => 'russisk (Moldova)',
        'ru-RU' => 'russisk (Rusland)',
        'ru-UA' => 'russisk (Ukraine)',
        'rw' => 'kinyarwanda',
        'rw-RW' => 'kinyarwanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'yakut',
        'sah-RU' => 'yakut (Rusland)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'nordsamisk',
        'se-FI' => 'nordsamisk (Finland)',
        'se-NO' => 'nordsamisk (Norge)',
        'se-SE' => 'nordsamisk (Sverige)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambique)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Den Centralafrikanske Republik)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (latinsk)',
        'shi-Latn-MA' => 'tachelhit (latinsk, Marokko)',
        'shi-Tfng' => 'tachelhit (tifinagh)',
        'shi-Tfng-MA' => 'tachelhit (tifinagh, Marokko)',
        'si' => 'singalesisk',
        'si-LK' => 'singalesisk (Sri Lanka)',
        'sk' => 'slovakisk',
        'sk-SK' => 'slovakisk (Slovakiet)',
        'sl' => 'slovensk',
        'sl-SI' => 'slovensk (Slovenien)',
        'smn' => 'enaresamisk',
        'smn-FI' => 'enaresamisk (Finland)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somalisk',
        'so-DJ' => 'somalisk (Djibouti)',
        'so-ET' => 'somalisk (Etiopien)',
        'so-KE' => 'somalisk (Kenya)',
        'so-SO' => 'somalisk (Somalia)',
        'sq' => 'albansk',
        'sq-AL' => 'albansk (Albanien)',
        'sq-MK' => 'albansk (Makedonien)',
        'sq-XK' => 'albansk (Kosovo)',
        'sr' => 'serbisk',
        'sr-Cyrl' => 'serbisk (kyrillisk)',
        'sr-Cyrl-BA' => 'serbisk (kyrillisk, Bosnien-Hercegovina)',
        'sr-Cyrl-ME' => 'serbisk (kyrillisk, Montenegro)',
        'sr-Cyrl-RS' => 'serbisk (kyrillisk, Serbien)',
        'sr-Cyrl-XK' => 'serbisk (kyrillisk, Kosovo)',
        'sr-Latn' => 'serbisk (latinsk)',
        'sr-Latn-BA' => 'serbisk (latinsk, Bosnien-Hercegovina)',
        'sr-Latn-ME' => 'serbisk (latinsk, Montenegro)',
        'sr-Latn-RS' => 'serbisk (latinsk, Serbien)',
        'sr-Latn-XK' => 'serbisk (latinsk, Kosovo)',
        'sv' => 'svensk',
        'sv-AX' => 'svensk (Åland)',
        'sv-FI' => 'svensk (Finland)',
        'sv-SE' => 'svensk (Sverige)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Congo-Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzania)',
        'sw-UG' => 'swahili (Uganda)',
        'ta' => 'tamilsk',
        'ta-IN' => 'tamilsk (Indien)',
        'ta-LK' => 'tamilsk (Sri Lanka)',
        'ta-MY' => 'tamilsk (Malaysia)',
        'ta-SG' => 'tamilsk (Singapore)',
        'te' => 'telugu',
        'te-IN' => 'telugu (Indien)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenya)',
        'teo-UG' => 'teso (Uganda)',
        'th' => 'thai',
        'th-TH' => 'thai (Thailand)',
        'ti' => 'tigrinya',
        'ti-ER' => 'tigrinya (Eritrea)',
        'ti-ET' => 'tigrinya (Etiopien)',
        'to' => 'tongansk',
        'to-TO' => 'tongansk (Tonga)',
        'tr' => 'tyrkisk',
        'tr-CY' => 'tyrkisk (Cypern)',
        'tr-TR' => 'tyrkisk (Tyrkiet)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'centralmarokkansk tamazight',
        'tzm-MA' => 'centralmarokkansk tamazight (Marokko)',
        'ug' => 'uygurisk',
        'ug-CN' => 'uygurisk (Kina)',
        'uk' => 'ukrainsk',
        'uk-UA' => 'ukrainsk (Ukraine)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (Indien)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'usbekisk',
        'uz-Arab' => 'usbekisk (arabisk)',
        'uz-Arab-AF' => 'usbekisk (arabisk, Afghanistan)',
        'uz-Cyrl' => 'usbekisk (kyrillisk)',
        'uz-Cyrl-UZ' => 'usbekisk (kyrillisk, Usbekistan)',
        'uz-Latn' => 'usbekisk (latinsk)',
        'uz-Latn-UZ' => 'usbekisk (latinsk, Usbekistan)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latinsk)',
        'vai-Latn-LR' => 'vai (latinsk, Liberia)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Liberia)',
        'vi' => 'vietnamesisk',
        'vi-VN' => 'vietnamesisk (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walsertysk',
        'wae-CH' => 'walsertysk (Schweiz)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Cameroun)',
        'yi' => 'jiddisch',
        'yi-001' => 'jiddisch (Verden)',
        'yo' => 'yoruba',
        'yo-BJ' => 'yoruba (Benin)',
        'yo-NG' => 'yoruba (Nigeria)',
        'yue' => 'kantonesisk',
        'yue-HK' => 'kantonesisk (Hongkong SAR)',
        'zgh' => 'tamazight',
        'zgh-MA' => 'tamazight (Marokko)',
        'zh' => 'kinesisk',
        'zh-Hans' => 'kinesisk (forenklet)',
        'zh-Hans-CN' => 'kinesisk (forenklet, Kina)',
        'zh-Hans-HK' => 'kinesisk (forenklet, Hongkong SAR)',
        'zh-Hans-MO' => 'kinesisk (forenklet, Macao SAR)',
        'zh-Hans-SG' => 'kinesisk (forenklet, Singapore)',
        'zh-Hant' => 'kinesisk (traditionelt)',
        'zh-Hant-HK' => 'kinesisk (traditionelt, Hongkong SAR)',
        'zh-Hant-MO' => 'kinesisk (traditionelt, Macao SAR)',
        'zh-Hant-TW' => 'kinesisk (traditionelt, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Sydafrika)',
    ],
];
