<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'yyyy-M-d',
            'time' => 'HH:mm',
            'datetime' => 'yyyy-M-d HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y \'à\' HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE d MMMM y \'à\' HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '$',
        'intlCurrency' => 'CAD',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => '$ AU',
        'BRL' => 'R$',
        'CAD' => '$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => '$ HK',
        'ILS' => 'ILS',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => 'KRW',
        'MXN' => 'MXN',
        'NZD' => '$ NZ',
        'THB' => 'THB',
        'TWD' => 'TWD',
        'USD' => '$ US',
        'VND' => 'VND',
        'XAF' => 'XAF',
        'XCD' => 'XCD',
        'XOF' => 'XOF',
        'XPF' => 'XPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.',
        ],
        'full' => [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.',
        ],
        'full' => [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'M',
            'J',
            'V',
            'S',
        ],
        'short' => [
            'di',
            'lu',
            'ma',
            'me',
            'je',
            've',
            'sa',
        ],
        'medium' => [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.',
        ],
        'full' => [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'D',
            'L',
            'M',
            'M',
            'J',
            'V',
            'S',
        ],
        'short' => [
            'di',
            'lu',
            'ma',
            'me',
            'je',
            've',
            'sa',
        ],
        'medium' => [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.',
        ],
        'full' => [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibie)',
        'af-ZA' => 'afrikaans (Afrique du Sud)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Cameroun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amharique',
        'am-ET' => 'amharique (Éthiopie)',
        'ar' => 'arabe',
        'ar-001' => 'arabe (Monde)',
        'ar-AE' => 'arabe (Émirats arabes unis)',
        'ar-BH' => 'arabe (Bahreïn)',
        'ar-DJ' => 'arabe (Djibouti)',
        'ar-DZ' => 'arabe (Algérie)',
        'ar-EG' => 'arabe (Égypte)',
        'ar-EH' => 'arabe (Sahara occidental)',
        'ar-ER' => 'arabe (Érythrée)',
        'ar-IL' => 'arabe (Israël)',
        'ar-IQ' => 'arabe (Irak)',
        'ar-JO' => 'arabe (Jordanie)',
        'ar-KM' => 'arabe (Comores)',
        'ar-KW' => 'arabe (Koweït)',
        'ar-LB' => 'arabe (Liban)',
        'ar-LY' => 'arabe (Libye)',
        'ar-MA' => 'arabe (Maroc)',
        'ar-MR' => 'arabe (Mauritanie)',
        'ar-OM' => 'arabe (Oman)',
        'ar-PS' => 'arabe (Territoires palestiniens)',
        'ar-QA' => 'arabe (Qatar)',
        'ar-SA' => 'arabe (Arabie saoudite)',
        'ar-SD' => 'arabe (Soudan)',
        'ar-SO' => 'arabe (Somalie)',
        'ar-SS' => 'arabe (Soudan du Sud)',
        'ar-SY' => 'arabe (Syrie)',
        'ar-TD' => 'arabe (Tchad)',
        'ar-TN' => 'arabe (Tunisie)',
        'ar-YE' => 'arabe (Yémen)',
        'as' => 'assamais',
        'as-IN' => 'assamais (Inde)',
        'asa' => 'assou',
        'asa-TZ' => 'assou (Tanzanie)',
        'ast' => 'asturien',
        'ast-ES' => 'asturien (Espagne)',
        'az' => 'azéri',
        'az-Cyrl' => 'azéri (cyrillique)',
        'az-Cyrl-AZ' => 'azéri (cyrillique, Azerbaïdjan)',
        'az-Latn' => 'azéri (latin)',
        'az-Latn-AZ' => 'azéri (latin, Azerbaïdjan)',
        'bas' => 'bassa',
        'bas-CM' => 'bassa (Cameroun)',
        'be' => 'biélorusse',
        'be-BY' => 'biélorusse (Bélarus)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambie)',
        'bez' => 'béna',
        'bez-TZ' => 'béna (Tanzanie)',
        'bg' => 'bulgare',
        'bg-BG' => 'bulgare (Bulgarie)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (Inde)',
        'bo' => 'tibétain',
        'bo-CN' => 'tibétain (Chine)',
        'bo-IN' => 'tibétain (Inde)',
        'br' => 'breton',
        'br-FR' => 'breton (France)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (Inde)',
        'bs' => 'bosniaque',
        'bs-Cyrl' => 'bosniaque (cyrillique)',
        'bs-Cyrl-BA' => 'bosniaque (cyrillique, Bosnie-Herzégovine)',
        'bs-Latn' => 'bosniaque (latin)',
        'bs-Latn-BA' => 'bosniaque (latin, Bosnie-Herzégovine)',
        'ca' => 'catalan',
        'ca-AD' => 'catalan (Andorre)',
        'ca-ES' => 'catalan (Espagne)',
        'ca-FR' => 'catalan (France)',
        'ca-IT' => 'catalan (Italie)',
        'ce' => 'tchétchène',
        'ce-RU' => 'tchétchène (Russie)',
        'cgg' => 'kiga',
        'cgg-UG' => 'kiga (Ouganda)',
        'chr' => 'cherokee',
        'chr-US' => 'cherokee (États-Unis)',
        'cs' => 'tchèque',
        'cs-CZ' => 'tchèque (République tchèque)',
        'cy' => 'gallois',
        'cy-GB' => 'gallois (Royaume-Uni)',
        'da' => 'danois',
        'da-DK' => 'danois (Danemark)',
        'da-GL' => 'danois (Groenland)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'allemand',
        'de-AT' => 'allemand (Autriche)',
        'de-BE' => 'allemand (Belgique)',
        'de-CH' => 'allemand (Suisse)',
        'de-DE' => 'allemand (Allemagne)',
        'de-LI' => 'allemand (Liechtenstein)',
        'de-LU' => 'allemand (Luxembourg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'bas-sorabe',
        'dsb-DE' => 'bas-sorabe (Allemagne)',
        'dua' => 'douala',
        'dua-CM' => 'douala (Cameroun)',
        'dyo' => 'diola-fogny',
        'dyo-SN' => 'diola-fogny (Sénégal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhoutan)',
        'ebu' => 'embou',
        'ebu-KE' => 'embou (Kenya)',
        'ee' => 'éwé',
        'ee-GH' => 'éwé (Ghana)',
        'ee-TG' => 'éwé (Togo)',
        'el' => 'grec',
        'el-CY' => 'grec (Chypre)',
        'el-GR' => 'grec (Grèce)',
        'en' => 'anglais',
        'en-001' => 'anglais (Monde)',
        'en-150' => 'anglais (Europe)',
        'en-AG' => 'anglais (Antigua-et-Barbuda)',
        'en-AI' => 'anglais (Anguilla)',
        'en-AS' => 'anglais (Samoa américaines)',
        'en-AT' => 'anglais (Autriche)',
        'en-AU' => 'anglais (Australie)',
        'en-BB' => 'anglais (Barbade)',
        'en-BE' => 'anglais (Belgique)',
        'en-BI' => 'anglais (Burundi)',
        'en-BM' => 'anglais (Bermudes)',
        'en-BS' => 'anglais (Bahamas)',
        'en-BW' => 'anglais (Botswana)',
        'en-BZ' => 'anglais (Belize)',
        'en-CA' => 'anglais (Canada)',
        'en-CC' => 'anglais (Îles Cocos [Keeling])',
        'en-CH' => 'anglais (Suisse)',
        'en-CK' => 'anglais (Îles Cook)',
        'en-CM' => 'anglais (Cameroun)',
        'en-CX' => 'anglais (Île Christmas)',
        'en-CY' => 'anglais (Chypre)',
        'en-DE' => 'anglais (Allemagne)',
        'en-DG' => 'anglais (Diego Garcia)',
        'en-DK' => 'anglais (Danemark)',
        'en-DM' => 'anglais (Dominique)',
        'en-ER' => 'anglais (Érythrée)',
        'en-FI' => 'anglais (Finlande)',
        'en-FJ' => 'anglais (Fidji)',
        'en-FK' => 'anglais (Îles Malouines)',
        'en-FM' => 'anglais (Micronésie)',
        'en-GB' => 'anglais (Royaume-Uni)',
        'en-GD' => 'anglais (Grenade)',
        'en-GG' => 'anglais (Guernesey)',
        'en-GH' => 'anglais (Ghana)',
        'en-GI' => 'anglais (Gibraltar)',
        'en-GM' => 'anglais (Gambie)',
        'en-GU' => 'anglais (Guam)',
        'en-GY' => 'anglais (Guyana)',
        'en-HK' => 'anglais (R.A.S. chinoise de Hong Kong)',
        'en-IE' => 'anglais (Irlande)',
        'en-IL' => 'anglais (Israël)',
        'en-IM' => 'anglais (Île de Man)',
        'en-IN' => 'anglais (Inde)',
        'en-IO' => 'anglais (Territoire britannique de l’océan Indien)',
        'en-JE' => 'anglais (Jersey)',
        'en-JM' => 'anglais (Jamaïque)',
        'en-KE' => 'anglais (Kenya)',
        'en-KI' => 'anglais (Kiribati)',
        'en-KN' => 'anglais (Saint-Christophe-et-Niévès)',
        'en-KY' => 'anglais (Îles Caïmans)',
        'en-LC' => 'anglais (Sainte-Lucie)',
        'en-LR' => 'anglais (Libéria)',
        'en-LS' => 'anglais (Lesotho)',
        'en-MG' => 'anglais (Madagascar)',
        'en-MH' => 'anglais (Îles Marshall)',
        'en-MO' => 'anglais (R.A.S. chinoise de Macao)',
        'en-MP' => 'anglais (Îles Mariannes du Nord)',
        'en-MS' => 'anglais (Montserrat)',
        'en-MT' => 'anglais (Malte)',
        'en-MU' => 'anglais (Maurice)',
        'en-MW' => 'anglais (Malawi)',
        'en-MY' => 'anglais (Malaisie)',
        'en-NA' => 'anglais (Namibie)',
        'en-NF' => 'anglais (Île Norfolk)',
        'en-NG' => 'anglais (Nigéria)',
        'en-NL' => 'anglais (Pays-Bas)',
        'en-NR' => 'anglais (Nauru)',
        'en-NU' => 'anglais (Niue)',
        'en-NZ' => 'anglais (Nouvelle-Zélande)',
        'en-PG' => 'anglais (Papouasie-Nouvelle-Guinée)',
        'en-PH' => 'anglais (Philippines)',
        'en-PK' => 'anglais (Pakistan)',
        'en-PN' => 'anglais (Îles Pitcairn)',
        'en-PR' => 'anglais (Porto Rico)',
        'en-PW' => 'anglais (Palaos)',
        'en-RW' => 'anglais (Rwanda)',
        'en-SB' => 'anglais (Îles Salomon)',
        'en-SC' => 'anglais (Seychelles)',
        'en-SD' => 'anglais (Soudan)',
        'en-SE' => 'anglais (Suède)',
        'en-SG' => 'anglais (Singapour)',
        'en-SH' => 'anglais (Sainte-Hélène)',
        'en-SI' => 'anglais (Slovénie)',
        'en-SL' => 'anglais (Sierra Leone)',
        'en-SS' => 'anglais (Soudan du Sud)',
        'en-SX' => 'anglais (Saint-Martin [Pays-Bas])',
        'en-SZ' => 'anglais (Swaziland)',
        'en-TC' => 'anglais (Îles Turques-et-Caïques)',
        'en-TK' => 'anglais (Tokelau)',
        'en-TO' => 'anglais (Tonga)',
        'en-TT' => 'anglais (Trinité-et-Tobago)',
        'en-TV' => 'anglais (Tuvalu)',
        'en-TZ' => 'anglais (Tanzanie)',
        'en-UG' => 'anglais (Ouganda)',
        'en-UM' => 'anglais (Îles mineures éloignées des États-Unis)',
        'en-US' => 'anglais (États-Unis)',
        'en-US-POSIX' => 'anglais (États-Unis, informatique)',
        'en-VC' => 'anglais (Saint-Vincent-et-les Grenadines)',
        'en-VG' => 'anglais (Îles Vierges britanniques)',
        'en-VI' => 'anglais (Îles Vierges des États-Unis)',
        'en-VU' => 'anglais (Vanuatu)',
        'en-WS' => 'anglais (Samoa)',
        'en-ZA' => 'anglais (Afrique du Sud)',
        'en-ZM' => 'anglais (Zambie)',
        'en-ZW' => 'anglais (Zimbabwe)',
        'eo' => 'espéranto',
        'es' => 'espagnol',
        'es-419' => 'espagnol (Amérique latine)',
        'es-AR' => 'espagnol (Argentine)',
        'es-BO' => 'espagnol (Bolivie)',
        'es-CL' => 'espagnol (Chili)',
        'es-CO' => 'espagnol (Colombie)',
        'es-CR' => 'espagnol (Costa Rica)',
        'es-CU' => 'espagnol (Cuba)',
        'es-DO' => 'espagnol (République dominicaine)',
        'es-EA' => 'espagnol (Ceuta et Melilla)',
        'es-EC' => 'espagnol (Équateur)',
        'es-ES' => 'espagnol (Espagne)',
        'es-GQ' => 'espagnol (Guinée équatoriale)',
        'es-GT' => 'espagnol (Guatemala)',
        'es-HN' => 'espagnol (Honduras)',
        'es-IC' => 'espagnol (Îles Canaries)',
        'es-MX' => 'espagnol (Mexique)',
        'es-NI' => 'espagnol (Nicaragua)',
        'es-PA' => 'espagnol (Panama)',
        'es-PE' => 'espagnol (Pérou)',
        'es-PH' => 'espagnol (Philippines)',
        'es-PR' => 'espagnol (Porto Rico)',
        'es-PY' => 'espagnol (Paraguay)',
        'es-SV' => 'espagnol (El Salvador)',
        'es-US' => 'espagnol (États-Unis)',
        'es-UY' => 'espagnol (Uruguay)',
        'es-VE' => 'espagnol (Venezuela)',
        'et' => 'estonien',
        'et-EE' => 'estonien (Estonie)',
        'eu' => 'basque',
        'eu-ES' => 'basque (Espagne)',
        'ewo' => 'éwondo',
        'ewo-CM' => 'éwondo (Cameroun)',
        'fa' => 'persan',
        'fa-AF' => 'persan (Afghanistan)',
        'fa-IR' => 'persan (Iran)',
        'ff' => 'peul',
        'ff-CM' => 'peul (Cameroun)',
        'ff-GN' => 'peul (Guinée)',
        'ff-MR' => 'peul (Mauritanie)',
        'ff-SN' => 'peul (Sénégal)',
        'fi' => 'finnois',
        'fi-FI' => 'finnois (Finlande)',
        'fil' => 'filipino',
        'fil-PH' => 'filipino (Philippines)',
        'fo' => 'féroïen',
        'fo-DK' => 'féroïen (Danemark)',
        'fo-FO' => 'féroïen (Îles Féroé)',
        'fr' => 'français',
        'fr-BE' => 'français (Belgique)',
        'fr-BF' => 'français (Burkina Faso)',
        'fr-BI' => 'français (Burundi)',
        'fr-BJ' => 'français (Bénin)',
        'fr-BL' => 'français (Saint-Barthélemy)',
        'fr-CA' => 'français (Canada)',
        'fr-CD' => 'français (Congo-Kinshasa)',
        'fr-CF' => 'français (République centrafricaine)',
        'fr-CG' => 'français (Congo-Brazzaville)',
        'fr-CH' => 'français (Suisse)',
        'fr-CI' => 'français (Côte d’Ivoire)',
        'fr-CM' => 'français (Cameroun)',
        'fr-DJ' => 'français (Djibouti)',
        'fr-DZ' => 'français (Algérie)',
        'fr-FR' => 'français (France)',
        'fr-GA' => 'français (Gabon)',
        'fr-GF' => 'français (Guyane française)',
        'fr-GN' => 'français (Guinée)',
        'fr-GP' => 'français (Guadeloupe)',
        'fr-GQ' => 'français (Guinée équatoriale)',
        'fr-HT' => 'français (Haïti)',
        'fr-KM' => 'français (Comores)',
        'fr-LU' => 'français (Luxembourg)',
        'fr-MA' => 'français (Maroc)',
        'fr-MC' => 'français (Monaco)',
        'fr-MF' => 'français (Saint-Martin [France])',
        'fr-MG' => 'français (Madagascar)',
        'fr-ML' => 'français (Mali)',
        'fr-MQ' => 'français (Martinique)',
        'fr-MR' => 'français (Mauritanie)',
        'fr-MU' => 'français (Maurice)',
        'fr-NC' => 'français (Nouvelle-Calédonie)',
        'fr-NE' => 'français (Niger)',
        'fr-PF' => 'français (Polynésie française)',
        'fr-PM' => 'français (Saint-Pierre-et-Miquelon)',
        'fr-RE' => 'français (La Réunion)',
        'fr-RW' => 'français (Rwanda)',
        'fr-SC' => 'français (Seychelles)',
        'fr-SN' => 'français (Sénégal)',
        'fr-SY' => 'français (Syrie)',
        'fr-TD' => 'français (Tchad)',
        'fr-TG' => 'français (Togo)',
        'fr-TN' => 'français (Tunisie)',
        'fr-VU' => 'français (Vanuatu)',
        'fr-WF' => 'français (Wallis-et-Futuna)',
        'fr-YT' => 'français (Mayotte)',
        'fur' => 'frioulan',
        'fur-IT' => 'frioulan (Italie)',
        'fy' => 'frison occidental',
        'fy-NL' => 'frison occidental (Pays-Bas)',
        'ga' => 'irlandais',
        'ga-IE' => 'irlandais (Irlande)',
        'gd' => 'gaélique écossais',
        'gd-GB' => 'gaélique écossais (Royaume-Uni)',
        'gl' => 'galicien',
        'gl-ES' => 'galicien (Espagne)',
        'gsw' => 'suisse allemand',
        'gsw-CH' => 'suisse allemand (Suisse)',
        'gsw-FR' => 'suisse allemand (France)',
        'gsw-LI' => 'suisse allemand (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (Inde)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenya)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Île de Man)',
        'ha' => 'haoussa',
        'ha-GH' => 'haoussa (Ghana)',
        'ha-NE' => 'haoussa (Niger)',
        'ha-NG' => 'haoussa (Nigéria)',
        'haw' => 'hawaïen',
        'haw-US' => 'hawaïen (États-Unis)',
        'he' => 'hébreu',
        'he-IL' => 'hébreu (Israël)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (Inde)',
        'hr' => 'croate',
        'hr-BA' => 'croate (Bosnie-Herzégovine)',
        'hr-HR' => 'croate (Croatie)',
        'hsb' => 'haut-sorabe',
        'hsb-DE' => 'haut-sorabe (Allemagne)',
        'hu' => 'hongrois',
        'hu-HU' => 'hongrois (Hongrie)',
        'hy' => 'arménien',
        'hy-AM' => 'arménien (Arménie)',
        'id' => 'indonésien',
        'id-ID' => 'indonésien (Indonésie)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigéria)',
        'ii' => 'yi du Sichuan',
        'ii-CN' => 'yi du Sichuan (Chine)',
        'is' => 'islandais',
        'is-IS' => 'islandais (Islande)',
        'it' => 'italien',
        'it-CH' => 'italien (Suisse)',
        'it-IT' => 'italien (Italie)',
        'it-SM' => 'italien (Saint-Marin)',
        'ja' => 'japonais',
        'ja-JP' => 'japonais (Japon)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Cameroun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzanie)',
        'ka' => 'géorgien',
        'ka-GE' => 'géorgien (Géorgie)',
        'kab' => 'kabyle',
        'kab-DZ' => 'kabyle (Algérie)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzanie)',
        'kea' => 'capverdien',
        'kea-CV' => 'capverdien (Cap-Vert)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kazakh',
        'kk-KZ' => 'kazakh (Kazakhstan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Cameroun)',
        'kl' => 'groenlandais',
        'kl-GL' => 'groenlandais (Groenland)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Cambodge)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (Inde)',
        'ko' => 'coréen',
        'ko-KP' => 'coréen (Corée du Nord)',
        'ko-KR' => 'coréen (Corée du Sud)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (Inde)',
        'ks' => 'kashmiri',
        'ks-IN' => 'kashmiri (Inde)',
        'ksb' => 'chambala',
        'ksb-TZ' => 'chambala (Tanzanie)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Cameroun)',
        'ksh' => 'francique ripuaire',
        'ksh-DE' => 'francique ripuaire (Allemagne)',
        'kw' => 'cornique',
        'kw-GB' => 'cornique (Royaume-Uni)',
        'ky' => 'kirghize',
        'ky-KG' => 'kirghize (Kirghizistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzanie)',
        'lb' => 'luxembourgeois',
        'lb-LU' => 'luxembourgeois (Luxembourg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Ouganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (États-Unis)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Congo-Kinshasa)',
        'ln-CF' => 'lingala (République centrafricaine)',
        'ln-CG' => 'lingala (Congo-Brazzaville)',
        'lo' => 'lao',
        'lo-LA' => 'lao (Laos)',
        'lrc' => 'lori du Nord',
        'lrc-IQ' => 'lori du Nord (Irak)',
        'lrc-IR' => 'lori du Nord (Iran)',
        'lt' => 'lituanien',
        'lt-LT' => 'lituanien (Lituanie)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Congo-Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'oluluyia',
        'luy-KE' => 'oluluyia (Kenya)',
        'lv' => 'letton',
        'lv-LV' => 'letton (Lettonie)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzanie)',
        'mer' => 'merou',
        'mer-KE' => 'merou (Kenya)',
        'mfe' => 'créole mauricien',
        'mfe-MU' => 'créole mauricien (Maurice)',
        'mg' => 'malgache',
        'mg-MG' => 'malgache (Madagascar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mozambique)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Cameroun)',
        'mk' => 'macédonien',
        'mk-MK' => 'macédonien (Macédoine)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (Inde)',
        'mn' => 'mongol',
        'mn-MN' => 'mongol (Mongolie)',
        'mr' => 'marathe',
        'mr-IN' => 'marathe (Inde)',
        'ms' => 'malais',
        'ms-BN' => 'malais (Brunéi Darussalam)',
        'ms-MY' => 'malais (Malaisie)',
        'ms-SG' => 'malais (Singapour)',
        'mt' => 'maltais',
        'mt-MT' => 'maltais (Malte)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Cameroun)',
        'my' => 'birman',
        'my-MM' => 'birman (Myanmar)',
        'mzn' => 'mazandérani',
        'mzn-IR' => 'mazandérani (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibie)',
        'nb' => 'norvégien bokmål',
        'nb-NO' => 'norvégien bokmål (Norvège)',
        'nb-SJ' => 'norvégien bokmål (Svalbard et Jan Mayen)',
        'nd' => 'ndébélé du Nord',
        'nd-ZW' => 'ndébélé du Nord (Zimbabwe)',
        'ne' => 'népalais',
        'ne-IN' => 'népalais (Inde)',
        'ne-NP' => 'népalais (Népal)',
        'nl' => 'néerlandais',
        'nl-AW' => 'néerlandais (Aruba)',
        'nl-BE' => 'néerlandais (Belgique)',
        'nl-BQ' => 'néerlandais (Pays-Bas caribéens)',
        'nl-CW' => 'néerlandais (Curaçao)',
        'nl-NL' => 'néerlandais (Pays-Bas)',
        'nl-SR' => 'néerlandais (Suriname)',
        'nl-SX' => 'néerlandais (Saint-Martin [Pays-Bas])',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Cameroun)',
        'nn' => 'norvégien nynorsk',
        'nn-NO' => 'norvégien nynorsk (Norvège)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Cameroun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Soudan du Sud)',
        'nyn' => 'nyankolé',
        'nyn-UG' => 'nyankolé (Ouganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Éthiopie)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'oriya',
        'or-IN' => 'oriya (Inde)',
        'os' => 'ossète',
        'os-GE' => 'ossète (Géorgie)',
        'os-RU' => 'ossète (Russie)',
        'pa' => 'pendjabi',
        'pa-Arab' => 'pendjabi (arabe)',
        'pa-Arab-PK' => 'pendjabi (arabe, Pakistan)',
        'pa-Guru' => 'pendjabi (gourmoukhî)',
        'pa-Guru-IN' => 'pendjabi (gourmoukhî, Inde)',
        'pl' => 'polonais',
        'pl-PL' => 'polonais (Pologne)',
        'ps' => 'pachto',
        'ps-AF' => 'pachto (Afghanistan)',
        'pt' => 'portugais',
        'pt-AO' => 'portugais (Angola)',
        'pt-BR' => 'portugais (Brésil)',
        'pt-CV' => 'portugais (Cap-Vert)',
        'pt-GW' => 'portugais (Guinée-Bissau)',
        'pt-MO' => 'portugais (R.A.S. chinoise de Macao)',
        'pt-MZ' => 'portugais (Mozambique)',
        'pt-PT' => 'portugais (Portugal)',
        'pt-ST' => 'portugais (Sao Tomé-et-Principe)',
        'pt-TL' => 'portugais (Timor oriental)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivie)',
        'qu-EC' => 'quechua (Équateur)',
        'qu-PE' => 'quechua (Pérou)',
        'rm' => 'romanche',
        'rm-CH' => 'romanche (Suisse)',
        'rn' => 'roundi',
        'rn-BI' => 'roundi (Burundi)',
        'ro' => 'roumain',
        'ro-MD' => 'roumain (Moldavie)',
        'ro-RO' => 'roumain (Roumanie)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzanie)',
        'ru' => 'russe',
        'ru-BY' => 'russe (Bélarus)',
        'ru-KG' => 'russe (Kirghizistan)',
        'ru-KZ' => 'russe (Kazakhstan)',
        'ru-MD' => 'russe (Moldavie)',
        'ru-RU' => 'russe (Russie)',
        'ru-UA' => 'russe (Ukraine)',
        'rw' => 'rwanda',
        'rw-RW' => 'rwanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzanie)',
        'sah' => 'iakoute',
        'sah-RU' => 'iakoute (Russie)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzanie)',
        'se' => 'sami du Nord',
        'se-FI' => 'sami du Nord (Finlande)',
        'se-NO' => 'sami du Nord (Norvège)',
        'se-SE' => 'sami du Nord (Suède)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambique)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sangho',
        'sg-CF' => 'sangho (République centrafricaine)',
        'shi' => 'chleuh',
        'shi-Latn' => 'chleuh (latin)',
        'shi-Latn-MA' => 'chleuh (latin, Maroc)',
        'shi-Tfng' => 'chleuh (tifinagh)',
        'shi-Tfng-MA' => 'chleuh (tifinagh, Maroc)',
        'si' => 'cinghalais',
        'si-LK' => 'cinghalais (Sri Lanka)',
        'sk' => 'slovaque',
        'sk-SK' => 'slovaque (Slovaquie)',
        'sl' => 'slovène',
        'sl-SI' => 'slovène (Slovénie)',
        'smn' => 'sami d’Inari',
        'smn-FI' => 'sami d’Inari (Finlande)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somali',
        'so-DJ' => 'somali (Djibouti)',
        'so-ET' => 'somali (Éthiopie)',
        'so-KE' => 'somali (Kenya)',
        'so-SO' => 'somali (Somalie)',
        'sq' => 'albanais',
        'sq-AL' => 'albanais (Albanie)',
        'sq-MK' => 'albanais (Macédoine)',
        'sq-XK' => 'albanais (Kosovo)',
        'sr' => 'serbe',
        'sr-Cyrl' => 'serbe (cyrillique)',
        'sr-Cyrl-BA' => 'serbe (cyrillique, Bosnie-Herzégovine)',
        'sr-Cyrl-ME' => 'serbe (cyrillique, Monténégro)',
        'sr-Cyrl-RS' => 'serbe (cyrillique, Serbie)',
        'sr-Cyrl-XK' => 'serbe (cyrillique, Kosovo)',
        'sr-Latn' => 'serbe (latin)',
        'sr-Latn-BA' => 'serbe (latin, Bosnie-Herzégovine)',
        'sr-Latn-ME' => 'serbe (latin, Monténégro)',
        'sr-Latn-RS' => 'serbe (latin, Serbie)',
        'sr-Latn-XK' => 'serbe (latin, Kosovo)',
        'sv' => 'suédois',
        'sv-AX' => 'suédois (Îles Åland)',
        'sv-FI' => 'suédois (Finlande)',
        'sv-SE' => 'suédois (Suède)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Congo-Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzanie)',
        'sw-UG' => 'swahili (Ouganda)',
        'ta' => 'tamoul',
        'ta-IN' => 'tamoul (Inde)',
        'ta-LK' => 'tamoul (Sri Lanka)',
        'ta-MY' => 'tamoul (Malaisie)',
        'ta-SG' => 'tamoul (Singapour)',
        'te' => 'télougou',
        'te-IN' => 'télougou (Inde)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenya)',
        'teo-UG' => 'teso (Ouganda)',
        'th' => 'thaï',
        'th-TH' => 'thaï (Thaïlande)',
        'ti' => 'tigrigna',
        'ti-ER' => 'tigrigna (Érythrée)',
        'ti-ET' => 'tigrigna (Éthiopie)',
        'to' => 'tonguien',
        'to-TO' => 'tonguien (Tonga)',
        'tr' => 'turc',
        'tr-CY' => 'turc (Chypre)',
        'tr-TR' => 'turc (Turquie)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'tamazight',
        'tzm-MA' => 'tamazight (Maroc)',
        'ug' => 'ouïghour',
        'ug-CN' => 'ouïghour (Chine)',
        'uk' => 'ukrainien',
        'uk-UA' => 'ukrainien (Ukraine)',
        'ur' => 'ourdou',
        'ur-IN' => 'ourdou (Inde)',
        'ur-PK' => 'ourdou (Pakistan)',
        'uz' => 'ouzbek',
        'uz-Arab' => 'ouzbek (arabe)',
        'uz-Arab-AF' => 'ouzbek (arabe, Afghanistan)',
        'uz-Cyrl' => 'ouzbek (cyrillique)',
        'uz-Cyrl-UZ' => 'ouzbek (cyrillique, Ouzbékistan)',
        'uz-Latn' => 'ouzbek (latin)',
        'uz-Latn-UZ' => 'ouzbek (latin, Ouzbékistan)',
        'vai' => 'vaï',
        'vai-Latn' => 'vaï (latin)',
        'vai-Latn-LR' => 'vaï (latin, Libéria)',
        'vai-Vaii' => 'vaï (vaï)',
        'vai-Vaii-LR' => 'vaï (vaï, Libéria)',
        'vi' => 'vietnamien',
        'vi-VN' => 'vietnamien (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzanie)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Suisse)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Ouganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Cameroun)',
        'yi' => 'yiddish',
        'yi-001' => 'yiddish (Monde)',
        'yo' => 'yoruba',
        'yo-BJ' => 'yoruba (Bénin)',
        'yo-NG' => 'yoruba (Nigéria)',
        'yue' => 'cantonais',
        'yue-HK' => 'cantonais (R.A.S. chinoise de Hong Kong)',
        'zgh' => 'amazighe standard marocain',
        'zgh-MA' => 'amazighe standard marocain (Maroc)',
        'zh' => 'chinois',
        'zh-Hans' => 'chinois (simplifié)',
        'zh-Hans-CN' => 'chinois (simplifié, Chine)',
        'zh-Hans-HK' => 'chinois (simplifié, R.A.S. chinoise de Hong Kong)',
        'zh-Hans-MO' => 'chinois (simplifié, R.A.S. chinoise de Macao)',
        'zh-Hans-SG' => 'chinois (simplifié, Singapour)',
        'zh-Hant' => 'chinois (traditionnel)',
        'zh-Hant-HK' => 'chinois (traditionnel, R.A.S. chinoise de Hong Kong)',
        'zh-Hant-MO' => 'chinois (traditionnel, R.A.S. chinoise de Macao)',
        'zh-Hant-TW' => 'chinois (traditionnel, Taïwan)',
        'zu' => 'zoulou',
        'zu-ZA' => 'zoulou (Afrique du Sud)',
    ],
];
