<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.y',
            'time' => 'H:mm',
            'datetime' => 'd.M.y, H:mm',
        ],
        'medium' => [
            'date' => 'd בMMM y',
            'time' => 'H:mm:ss',
            'datetime' => 'd בMMM y, H:mm:ss',
        ],
        'long' => [
            'date' => 'd בMMMM y',
            'time' => 'H:mm:ss z',
            'datetime' => 'd בMMMM y בשעה H:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d בMMMM y',
            'time' => 'H:mm:ss zzzz',
            'datetime' => 'EEEE, d בMMMM y בשעה H:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'לפנה״צ',
    'pmName' => 'אחה״צ',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '‎-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '‎-',
        'plusSign' => '‎+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳',
        ],
        'full' => [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳',
        ],
        'full' => [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'short' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'medium' => [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת',
        ],
        'full' => [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'short' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'medium' => [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת',
        ],
        'full' => [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'אפריקאנס',
        'af-NA' => 'אפריקאנס (נמיביה)',
        'af-ZA' => 'אפריקאנס (דרום אפריקה)',
        'agq' => 'אהיים',
        'agq-CM' => 'אהיים (קמרון)',
        'ak' => 'אקאן',
        'ak-GH' => 'אקאן (גאנה)',
        'am' => 'אמהרית',
        'am-ET' => 'אמהרית (אתיופיה)',
        'ar' => 'ערבית',
        'ar-001' => 'ערבית (העולם)',
        'ar-AE' => 'ערבית (איחוד האמירויות הערביות)',
        'ar-BH' => 'ערבית (בחריין)',
        'ar-DJ' => 'ערבית (ג׳יבוטי)',
        'ar-DZ' => 'ערבית (אלג׳יריה)',
        'ar-EG' => 'ערבית (מצרים)',
        'ar-EH' => 'ערבית (סהרה המערבית)',
        'ar-ER' => 'ערבית (אריתריאה)',
        'ar-IL' => 'ערבית (ישראל)',
        'ar-IQ' => 'ערבית (עיראק)',
        'ar-JO' => 'ערבית (ירדן)',
        'ar-KM' => 'ערבית (קומורו)',
        'ar-KW' => 'ערבית (כווית)',
        'ar-LB' => 'ערבית (לבנון)',
        'ar-LY' => 'ערבית (לוב)',
        'ar-MA' => 'ערבית (מרוקו)',
        'ar-MR' => 'ערבית (מאוריטניה)',
        'ar-OM' => 'ערבית (עומאן)',
        'ar-PS' => 'ערבית (השטחים הפלסטיניים)',
        'ar-QA' => 'ערבית (קטאר)',
        'ar-SA' => 'ערבית (ערב הסעודית)',
        'ar-SD' => 'ערבית (סודן)',
        'ar-SO' => 'ערבית (סומליה)',
        'ar-SS' => 'ערבית (דרום סודן)',
        'ar-SY' => 'ערבית (סוריה)',
        'ar-TD' => 'ערבית (צ׳אד)',
        'ar-TN' => 'ערבית (תוניסיה)',
        'ar-YE' => 'ערבית (תימן)',
        'as' => 'אסאמית',
        'as-IN' => 'אסאמית (הודו)',
        'asa' => 'אסו',
        'asa-TZ' => 'אסו (טנזניה)',
        'ast' => 'אסטורית',
        'ast-ES' => 'אסטורית (ספרד)',
        'az' => 'אזרית',
        'az-Cyrl' => 'אזרית (קירילי)',
        'az-Cyrl-AZ' => 'אזרית (קירילי, אזרבייג׳ן)',
        'az-Latn' => 'אזרית (לטיני)',
        'az-Latn-AZ' => 'אזרית (לטיני, אזרבייג׳ן)',
        'bas' => 'בסאא',
        'bas-CM' => 'בסאא (קמרון)',
        'be' => 'בלארוסית',
        'be-BY' => 'בלארוסית (בלארוס)',
        'bem' => 'במבה',
        'bem-ZM' => 'במבה (זמביה)',
        'bez' => 'בנה',
        'bez-TZ' => 'בנה (טנזניה)',
        'bg' => 'בולגרית',
        'bg-BG' => 'בולגרית (בולגריה)',
        'bm' => 'במבארה',
        'bm-ML' => 'במבארה (מאלי)',
        'bn' => 'בנגלית',
        'bn-BD' => 'בנגלית (בנגלדש)',
        'bn-IN' => 'בנגלית (הודו)',
        'bo' => 'טיבטית',
        'bo-CN' => 'טיבטית (סין)',
        'bo-IN' => 'טיבטית (הודו)',
        'br' => 'ברטונית',
        'br-FR' => 'ברטונית (צרפת)',
        'brx' => 'בודו',
        'brx-IN' => 'בודו (הודו)',
        'bs' => 'בוסנית',
        'bs-Cyrl' => 'בוסנית (קירילי)',
        'bs-Cyrl-BA' => 'בוסנית (קירילי, בוסניה והרצגובינה)',
        'bs-Latn' => 'בוסנית (לטיני)',
        'bs-Latn-BA' => 'בוסנית (לטיני, בוסניה והרצגובינה)',
        'ca' => 'קטלאנית',
        'ca-AD' => 'קטלאנית (אנדורה)',
        'ca-ES' => 'קטלאנית (ספרד)',
        'ca-FR' => 'קטלאנית (צרפת)',
        'ca-IT' => 'קטלאנית (איטליה)',
        'ce' => 'צ׳צ׳נית',
        'ce-RU' => 'צ׳צ׳נית (רוסיה)',
        'cgg' => 'צ׳יגה',
        'cgg-UG' => 'צ׳יגה (אוגנדה)',
        'chr' => 'צ׳רוקי',
        'chr-US' => 'צ׳רוקי (ארצות הברית)',
        'cs' => 'צ׳כית',
        'cs-CZ' => 'צ׳כית (צ׳כיה)',
        'cy' => 'ולשית',
        'cy-GB' => 'ולשית (הממלכה המאוחדת)',
        'da' => 'דנית',
        'da-DK' => 'דנית (דנמרק)',
        'da-GL' => 'דנית (גרינלנד)',
        'dav' => 'טאיטה',
        'dav-KE' => 'טאיטה (קניה)',
        'de' => 'גרמנית',
        'de-AT' => 'גרמנית (אוסטריה)',
        'de-BE' => 'גרמנית (בלגיה)',
        'de-CH' => 'גרמנית (שווייץ)',
        'de-DE' => 'גרמנית (גרמניה)',
        'de-LI' => 'גרמנית (ליכטנשטיין)',
        'de-LU' => 'גרמנית (לוקסמבורג)',
        'dje' => 'זארמה',
        'dje-NE' => 'זארמה (ניז׳ר)',
        'dsb' => 'סורבית נמוכה',
        'dsb-DE' => 'סורבית נמוכה (גרמניה)',
        'dua' => 'דואלה',
        'dua-CM' => 'דואלה (קמרון)',
        'dyo' => 'הולה-פוניי',
        'dyo-SN' => 'הולה-פוניי (סנגל)',
        'dz' => 'דזונקה',
        'dz-BT' => 'דזונקה (בהוטן)',
        'ebu' => 'אמבו',
        'ebu-KE' => 'אמבו (קניה)',
        'ee' => 'אווה',
        'ee-GH' => 'אווה (גאנה)',
        'ee-TG' => 'אווה (טוגו)',
        'el' => 'יוונית',
        'el-CY' => 'יוונית (קפריסין)',
        'el-GR' => 'יוונית (יוון)',
        'en' => 'אנגלית',
        'en-001' => 'אנגלית (העולם)',
        'en-150' => 'אנגלית (אירופה)',
        'en-AG' => 'אנגלית (אנטיגואה וברבודה)',
        'en-AI' => 'אנגלית (אנגילה)',
        'en-AS' => 'אנגלית (סמואה האמריקנית)',
        'en-AT' => 'אנגלית (אוסטריה)',
        'en-AU' => 'אנגלית (אוסטרליה)',
        'en-BB' => 'אנגלית (ברבדוס)',
        'en-BE' => 'אנגלית (בלגיה)',
        'en-BI' => 'אנגלית (בורונדי)',
        'en-BM' => 'אנגלית (ברמודה)',
        'en-BS' => 'אנגלית (איי בהאמה)',
        'en-BW' => 'אנגלית (בוטסוואנה)',
        'en-BZ' => 'אנגלית (בליז)',
        'en-CA' => 'אנגלית (קנדה)',
        'en-CC' => 'אנגלית (איי קוקוס [קילינג])',
        'en-CH' => 'אנגלית (שווייץ)',
        'en-CK' => 'אנגלית (איי קוק)',
        'en-CM' => 'אנגלית (קמרון)',
        'en-CX' => 'אנגלית (אי חג המולד)',
        'en-CY' => 'אנגלית (קפריסין)',
        'en-DE' => 'אנגלית (גרמניה)',
        'en-DG' => 'אנגלית (דייגו גרסיה)',
        'en-DK' => 'אנגלית (דנמרק)',
        'en-DM' => 'אנגלית (דומיניקה)',
        'en-ER' => 'אנגלית (אריתריאה)',
        'en-FI' => 'אנגלית (פינלנד)',
        'en-FJ' => 'אנגלית (פיג׳י)',
        'en-FK' => 'אנגלית (איי פוקלנד)',
        'en-FM' => 'אנגלית (מיקרונזיה)',
        'en-GB' => 'אנגלית (הממלכה המאוחדת)',
        'en-GD' => 'אנגלית (גרנדה)',
        'en-GG' => 'אנגלית (גרנסי)',
        'en-GH' => 'אנגלית (גאנה)',
        'en-GI' => 'אנגלית (גיברלטר)',
        'en-GM' => 'אנגלית (גמביה)',
        'en-GU' => 'אנגלית (גואם)',
        'en-GY' => 'אנגלית (גיאנה)',
        'en-HK' => 'אנגלית (הונג קונג - מחוז מנהלי מיוחד של סין)',
        'en-IE' => 'אנגלית (אירלנד)',
        'en-IL' => 'אנגלית (ישראל)',
        'en-IM' => 'אנגלית (האי מאן)',
        'en-IN' => 'אנגלית (הודו)',
        'en-IO' => 'אנגלית (הטריטוריה הבריטית באוקיינוס ההודי)',
        'en-JE' => 'אנגלית (ג׳רסי)',
        'en-JM' => 'אנגלית (ג׳מייקה)',
        'en-KE' => 'אנגלית (קניה)',
        'en-KI' => 'אנגלית (קיריבאטי)',
        'en-KN' => 'אנגלית (סנט קיטס ונוויס)',
        'en-KY' => 'אנגלית (איי קיימן)',
        'en-LC' => 'אנגלית (סנט לוסיה)',
        'en-LR' => 'אנגלית (ליבריה)',
        'en-LS' => 'אנגלית (לסוטו)',
        'en-MG' => 'אנגלית (מדגסקר)',
        'en-MH' => 'אנגלית (איי מרשל)',
        'en-MO' => 'אנגלית (מקאו - מחוז מנהלי מיוחד של סין)',
        'en-MP' => 'אנגלית (איי מריאנה הצפוניים)',
        'en-MS' => 'אנגלית (מונסראט)',
        'en-MT' => 'אנגלית (מלטה)',
        'en-MU' => 'אנגלית (מאוריציוס)',
        'en-MW' => 'אנגלית (מלאווי)',
        'en-MY' => 'אנגלית (מלזיה)',
        'en-NA' => 'אנגלית (נמיביה)',
        'en-NF' => 'אנגלית (איי נורפוק)',
        'en-NG' => 'אנגלית (ניגריה)',
        'en-NL' => 'אנגלית (הולנד)',
        'en-NR' => 'אנגלית (נאורו)',
        'en-NU' => 'אנגלית (ניווה)',
        'en-NZ' => 'אנגלית (ניו זילנד)',
        'en-PG' => 'אנגלית (פפואה גיניאה החדשה)',
        'en-PH' => 'אנגלית (פיליפינים)',
        'en-PK' => 'אנגלית (פקיסטן)',
        'en-PN' => 'אנגלית (איי פיטקרן)',
        'en-PR' => 'אנגלית (פוארטו ריקו)',
        'en-PW' => 'אנגלית (פאלאו)',
        'en-RW' => 'אנגלית (רואנדה)',
        'en-SB' => 'אנגלית (איי שלמה)',
        'en-SC' => 'אנגלית (איי סיישל)',
        'en-SD' => 'אנגלית (סודן)',
        'en-SE' => 'אנגלית (שוודיה)',
        'en-SG' => 'אנגלית (סינגפור)',
        'en-SH' => 'אנגלית (סנט הלנה)',
        'en-SI' => 'אנגלית (סלובניה)',
        'en-SL' => 'אנגלית (סיירה לאונה)',
        'en-SS' => 'אנגלית (דרום סודן)',
        'en-SX' => 'אנגלית (סנט מארטן)',
        'en-SZ' => 'אנגלית (סווזילנד)',
        'en-TC' => 'אנגלית (איי טורקס וקאיקוס)',
        'en-TK' => 'אנגלית (טוקלאו)',
        'en-TO' => 'אנגלית (טונגה)',
        'en-TT' => 'אנגלית (טרינידד וטובגו)',
        'en-TV' => 'אנגלית (טובלו)',
        'en-TZ' => 'אנגלית (טנזניה)',
        'en-UG' => 'אנגלית (אוגנדה)',
        'en-UM' => 'אנגלית (איים לחוף ארצות הברית)',
        'en-US' => 'אנגלית (ארצות הברית)',
        'en-US-POSIX' => 'אנגלית (ארצות הברית, מחשב)',
        'en-VC' => 'אנגלית (סנט וינסנט והגרנדינים)',
        'en-VG' => 'אנגלית (איי הבתולה הבריטיים)',
        'en-VI' => 'אנגלית (איי הבתולה של ארצות הברית)',
        'en-VU' => 'אנגלית (ונואטו)',
        'en-WS' => 'אנגלית (סמואה)',
        'en-ZA' => 'אנגלית (דרום אפריקה)',
        'en-ZM' => 'אנגלית (זמביה)',
        'en-ZW' => 'אנגלית (זימבאבווה)',
        'eo' => 'אספרנטו',
        'es' => 'ספרדית',
        'es-419' => 'ספרדית (אמריקה הלטינית)',
        'es-AR' => 'ספרדית (ארגנטינה)',
        'es-BO' => 'ספרדית (בוליביה)',
        'es-CL' => 'ספרדית (צ׳ילה)',
        'es-CO' => 'ספרדית (קולומביה)',
        'es-CR' => 'ספרדית (קוסטה ריקה)',
        'es-CU' => 'ספרדית (קובה)',
        'es-DO' => 'ספרדית (הרפובליקה הדומיניקנית)',
        'es-EA' => 'ספרדית (סאוטה ומלייה)',
        'es-EC' => 'ספרדית (אקוודור)',
        'es-ES' => 'ספרדית (ספרד)',
        'es-GQ' => 'ספרדית (גיניאה המשוונית)',
        'es-GT' => 'ספרדית (גואטמלה)',
        'es-HN' => 'ספרדית (הונדורס)',
        'es-IC' => 'ספרדית (האיים הקנריים)',
        'es-MX' => 'ספרדית (מקסיקו)',
        'es-NI' => 'ספרדית (ניקרגואה)',
        'es-PA' => 'ספרדית (פנמה)',
        'es-PE' => 'ספרדית (פרו)',
        'es-PH' => 'ספרדית (פיליפינים)',
        'es-PR' => 'ספרדית (פוארטו ריקו)',
        'es-PY' => 'ספרדית (פרגוואי)',
        'es-SV' => 'ספרדית (אל סלבדור)',
        'es-US' => 'ספרדית (ארצות הברית)',
        'es-UY' => 'ספרדית (אורוגוואי)',
        'es-VE' => 'ספרדית (ונצואלה)',
        'et' => 'אסטונית',
        'et-EE' => 'אסטונית (אסטוניה)',
        'eu' => 'בסקית',
        'eu-ES' => 'בסקית (ספרד)',
        'ewo' => 'אוונדו',
        'ewo-CM' => 'אוונדו (קמרון)',
        'fa' => 'פרסית',
        'fa-AF' => 'פרסית (אפגניסטן)',
        'fa-IR' => 'פרסית (איראן)',
        'ff' => 'פולה',
        'ff-CM' => 'פולה (קמרון)',
        'ff-GN' => 'פולה (גיניאה)',
        'ff-MR' => 'פולה (מאוריטניה)',
        'ff-SN' => 'פולה (סנגל)',
        'fi' => 'פינית',
        'fi-FI' => 'פינית (פינלנד)',
        'fil' => 'פיליפינית',
        'fil-PH' => 'פיליפינית (פיליפינים)',
        'fo' => 'פארואזית',
        'fo-DK' => 'פארואזית (דנמרק)',
        'fo-FO' => 'פארואזית (איי פארו)',
        'fr' => 'צרפתית',
        'fr-BE' => 'צרפתית (בלגיה)',
        'fr-BF' => 'צרפתית (בורקינה פאסו)',
        'fr-BI' => 'צרפתית (בורונדי)',
        'fr-BJ' => 'צרפתית (בנין)',
        'fr-BL' => 'צרפתית (סנט ברתולומיאו)',
        'fr-CA' => 'צרפתית (קנדה)',
        'fr-CD' => 'צרפתית (קונגו - קינשאסה)',
        'fr-CF' => 'צרפתית (הרפובליקה של מרכז אפריקה)',
        'fr-CG' => 'צרפתית (קונגו - ברזאויל)',
        'fr-CH' => 'צרפתית (שווייץ)',
        'fr-CI' => 'צרפתית (חוף השנהב)',
        'fr-CM' => 'צרפתית (קמרון)',
        'fr-DJ' => 'צרפתית (ג׳יבוטי)',
        'fr-DZ' => 'צרפתית (אלג׳יריה)',
        'fr-FR' => 'צרפתית (צרפת)',
        'fr-GA' => 'צרפתית (גאבון)',
        'fr-GF' => 'צרפתית (גיאנה הצרפתית)',
        'fr-GN' => 'צרפתית (גיניאה)',
        'fr-GP' => 'צרפתית (גוואדלופ)',
        'fr-GQ' => 'צרפתית (גיניאה המשוונית)',
        'fr-HT' => 'צרפתית (האיטי)',
        'fr-KM' => 'צרפתית (קומורו)',
        'fr-LU' => 'צרפתית (לוקסמבורג)',
        'fr-MA' => 'צרפתית (מרוקו)',
        'fr-MC' => 'צרפתית (מונקו)',
        'fr-MF' => 'צרפתית (סן מרטן)',
        'fr-MG' => 'צרפתית (מדגסקר)',
        'fr-ML' => 'צרפתית (מאלי)',
        'fr-MQ' => 'צרפתית (מרטיניק)',
        'fr-MR' => 'צרפתית (מאוריטניה)',
        'fr-MU' => 'צרפתית (מאוריציוס)',
        'fr-NC' => 'צרפתית (קלדוניה החדשה)',
        'fr-NE' => 'צרפתית (ניז׳ר)',
        'fr-PF' => 'צרפתית (פולינזיה הצרפתית)',
        'fr-PM' => 'צרפתית (סנט פייר ומיקלון)',
        'fr-RE' => 'צרפתית (ראוניון)',
        'fr-RW' => 'צרפתית (רואנדה)',
        'fr-SC' => 'צרפתית (איי סיישל)',
        'fr-SN' => 'צרפתית (סנגל)',
        'fr-SY' => 'צרפתית (סוריה)',
        'fr-TD' => 'צרפתית (צ׳אד)',
        'fr-TG' => 'צרפתית (טוגו)',
        'fr-TN' => 'צרפתית (תוניסיה)',
        'fr-VU' => 'צרפתית (ונואטו)',
        'fr-WF' => 'צרפתית (איי ווליס ופוטונה)',
        'fr-YT' => 'צרפתית (מאיוט)',
        'fur' => 'פריולית',
        'fur-IT' => 'פריולית (איטליה)',
        'fy' => 'פריזית',
        'fy-NL' => 'פריזית (הולנד)',
        'ga' => 'אירית',
        'ga-IE' => 'אירית (אירלנד)',
        'gd' => 'גאלית סקוטית',
        'gd-GB' => 'גאלית סקוטית (הממלכה המאוחדת)',
        'gl' => 'גליציאנית',
        'gl-ES' => 'גליציאנית (ספרד)',
        'gsw' => 'גרמנית שוויצרית',
        'gsw-CH' => 'גרמנית שוויצרית (שווייץ)',
        'gsw-FR' => 'גרמנית שוויצרית (צרפת)',
        'gsw-LI' => 'גרמנית שוויצרית (ליכטנשטיין)',
        'gu' => 'גוג׳ראטית',
        'gu-IN' => 'גוג׳ראטית (הודו)',
        'guz' => 'גוסי',
        'guz-KE' => 'גוסי (קניה)',
        'gv' => 'מאנית',
        'gv-IM' => 'מאנית (האי מאן)',
        'ha' => 'האוסה',
        'ha-GH' => 'האוסה (גאנה)',
        'ha-NE' => 'האוסה (ניז׳ר)',
        'ha-NG' => 'האוסה (ניגריה)',
        'haw' => 'הוואית',
        'haw-US' => 'הוואית (ארצות הברית)',
        'he' => 'עברית',
        'he-IL' => 'עברית (ישראל)',
        'hi' => 'הינדי',
        'hi-IN' => 'הינדי (הודו)',
        'hr' => 'קרואטית',
        'hr-BA' => 'קרואטית (בוסניה והרצגובינה)',
        'hr-HR' => 'קרואטית (קרואטיה)',
        'hsb' => 'סורבית גבוהה',
        'hsb-DE' => 'סורבית גבוהה (גרמניה)',
        'hu' => 'הונגרית',
        'hu-HU' => 'הונגרית (הונגריה)',
        'hy' => 'ארמנית',
        'hy-AM' => 'ארמנית (ארמניה)',
        'id' => 'אינדונזית',
        'id-ID' => 'אינדונזית (אינדונזיה)',
        'ig' => 'איגבו',
        'ig-NG' => 'איגבו (ניגריה)',
        'ii' => 'סיצ׳ואן יי',
        'ii-CN' => 'סיצ׳ואן יי (סין)',
        'is' => 'איסלנדית',
        'is-IS' => 'איסלנדית (איסלנד)',
        'it' => 'איטלקית',
        'it-CH' => 'איטלקית (שווייץ)',
        'it-IT' => 'איטלקית (איטליה)',
        'it-SM' => 'איטלקית (סן מרינו)',
        'ja' => 'יפנית',
        'ja-JP' => 'יפנית (יפן)',
        'jgo' => 'נגומה',
        'jgo-CM' => 'נגומה (קמרון)',
        'jmc' => 'מצ׳אמה',
        'jmc-TZ' => 'מצ׳אמה (טנזניה)',
        'ka' => 'גאורגית',
        'ka-GE' => 'גאורגית (גאורגיה)',
        'kab' => 'קבילה',
        'kab-DZ' => 'קבילה (אלג׳יריה)',
        'kam' => 'קמבה',
        'kam-KE' => 'קמבה (קניה)',
        'kde' => 'מקונדה',
        'kde-TZ' => 'מקונדה (טנזניה)',
        'kea' => 'קאבוורדיאנו',
        'kea-CV' => 'קאבוורדיאנו (כף ורדה)',
        'khq' => 'קוירה צ׳יני',
        'khq-ML' => 'קוירה צ׳יני (מאלי)',
        'ki' => 'קיקויו',
        'ki-KE' => 'קיקויו (קניה)',
        'kk' => 'קזחית',
        'kk-KZ' => 'קזחית (קזחסטן)',
        'kkj' => 'קאקו',
        'kkj-CM' => 'קאקו (קמרון)',
        'kl' => 'קאלאליסוטית',
        'kl-GL' => 'קאלאליסוטית (גרינלנד)',
        'kln' => 'קאלנג׳ין',
        'kln-KE' => 'קאלנג׳ין (קניה)',
        'km' => 'קמרית',
        'km-KH' => 'קמרית (קמבודיה)',
        'kn' => 'קנאדה',
        'kn-IN' => 'קנאדה (הודו)',
        'ko' => 'קוריאנית',
        'ko-KP' => 'קוריאנית (קוריאה הצפונית)',
        'ko-KR' => 'קוריאנית (קוריאה הדרומית)',
        'kok' => 'קונקאני',
        'kok-IN' => 'קונקאני (הודו)',
        'ks' => 'קשמירית',
        'ks-IN' => 'קשמירית (הודו)',
        'ksb' => 'שמבאלה',
        'ksb-TZ' => 'שמבאלה (טנזניה)',
        'ksf' => 'באפיה',
        'ksf-CM' => 'באפיה (קמרון)',
        'ksh' => 'קולוניאן',
        'ksh-DE' => 'קולוניאן (גרמניה)',
        'kw' => 'קורנית',
        'kw-GB' => 'קורנית (הממלכה המאוחדת)',
        'ky' => 'קירגיזית',
        'ky-KG' => 'קירגיזית (קירגיזסטן)',
        'lag' => 'לאנגי',
        'lag-TZ' => 'לאנגי (טנזניה)',
        'lb' => 'לוקסמבורגית',
        'lb-LU' => 'לוקסמבורגית (לוקסמבורג)',
        'lg' => 'גאנדה',
        'lg-UG' => 'גאנדה (אוגנדה)',
        'lkt' => 'לקוטה',
        'lkt-US' => 'לקוטה (ארצות הברית)',
        'ln' => 'לינגלה',
        'ln-AO' => 'לינגלה (אנגולה)',
        'ln-CD' => 'לינגלה (קונגו - קינשאסה)',
        'ln-CF' => 'לינגלה (הרפובליקה של מרכז אפריקה)',
        'ln-CG' => 'לינגלה (קונגו - ברזאויל)',
        'lo' => 'לאית',
        'lo-LA' => 'לאית (לאוס)',
        'lrc' => 'lrc',
        'lrc-IQ' => 'lrc (עיראק)',
        'lrc-IR' => 'lrc (איראן)',
        'lt' => 'ליטאית',
        'lt-LT' => 'ליטאית (ליטא)',
        'lu' => 'לובה-קטנגה',
        'lu-CD' => 'לובה-קטנגה (קונגו - קינשאסה)',
        'luo' => 'לואו',
        'luo-KE' => 'לואו (קניה)',
        'luy' => 'לויה',
        'luy-KE' => 'לויה (קניה)',
        'lv' => 'לטבית',
        'lv-LV' => 'לטבית (לטביה)',
        'mas' => 'מאסאית',
        'mas-KE' => 'מאסאית (קניה)',
        'mas-TZ' => 'מאסאית (טנזניה)',
        'mer' => 'מרו',
        'mer-KE' => 'מרו (קניה)',
        'mfe' => 'מוריסיין',
        'mfe-MU' => 'מוריסיין (מאוריציוס)',
        'mg' => 'מלגשית',
        'mg-MG' => 'מלגשית (מדגסקר)',
        'mgh' => 'מקואה-מיטו',
        'mgh-MZ' => 'מקואה-מיטו (מוזמביק)',
        'mgo' => 'מטא',
        'mgo-CM' => 'מטא (קמרון)',
        'mk' => 'מקדונית',
        'mk-MK' => 'מקדונית (מקדוניה)',
        'ml' => 'מלאיאלם',
        'ml-IN' => 'מלאיאלם (הודו)',
        'mn' => 'מונגולית',
        'mn-MN' => 'מונגולית (מונגוליה)',
        'mr' => 'מרטהי',
        'mr-IN' => 'מרטהי (הודו)',
        'ms' => 'מלאית',
        'ms-BN' => 'מלאית (ברוניי)',
        'ms-MY' => 'מלאית (מלזיה)',
        'ms-SG' => 'מלאית (סינגפור)',
        'mt' => 'מלטית',
        'mt-MT' => 'מלטית (מלטה)',
        'mua' => 'מונדאנג',
        'mua-CM' => 'מונדאנג (קמרון)',
        'my' => 'בורמזית',
        'my-MM' => 'בורמזית (מיאנמאר [בורמה]‎)',
        'mzn' => 'mzn',
        'mzn-IR' => 'mzn (איראן)',
        'naq' => 'נאמה',
        'naq-NA' => 'נאמה (נמיביה)',
        'nb' => 'נורווגית ספרותית',
        'nb-NO' => 'נורווגית ספרותית (נורווגיה)',
        'nb-SJ' => 'נורווגית ספרותית (סוולבארד ויאן מאיין)',
        'nd' => 'צפון נדבלה',
        'nd-ZW' => 'צפון נדבלה (זימבאבווה)',
        'ne' => 'נפאלית',
        'ne-IN' => 'נפאלית (הודו)',
        'ne-NP' => 'נפאלית (נפאל)',
        'nl' => 'הולנדית',
        'nl-AW' => 'הולנדית (ארובה)',
        'nl-BE' => 'הולנדית (בלגיה)',
        'nl-BQ' => 'הולנדית (האיים הקריביים ההולנדיים)',
        'nl-CW' => 'הולנדית (קוראסאו)',
        'nl-NL' => 'הולנדית (הולנד)',
        'nl-SR' => 'הולנדית (סורינם)',
        'nl-SX' => 'הולנדית (סנט מארטן)',
        'nmg' => 'קוואסיו',
        'nmg-CM' => 'קוואסיו (קמרון)',
        'nn' => 'נורווגית חדשה',
        'nn-NO' => 'נורווגית חדשה (נורווגיה)',
        'nnh' => 'נגיאמבון',
        'nnh-CM' => 'נגיאמבון (קמרון)',
        'nus' => 'נואר',
        'nus-SS' => 'נואר (דרום סודן)',
        'nyn' => 'ניאנקולה',
        'nyn-UG' => 'ניאנקולה (אוגנדה)',
        'om' => 'אורומו',
        'om-ET' => 'אורומו (אתיופיה)',
        'om-KE' => 'אורומו (קניה)',
        'or' => 'אוריה',
        'or-IN' => 'אוריה (הודו)',
        'os' => 'אוסטית',
        'os-GE' => 'אוסטית (גאורגיה)',
        'os-RU' => 'אוסטית (רוסיה)',
        'pa' => 'פנג׳אבית',
        'pa-Arab' => 'פנג׳אבית (ערבי)',
        'pa-Arab-PK' => 'פנג׳אבית (ערבי, פקיסטן)',
        'pa-Guru' => 'פנג׳אבית (גורמוקי)',
        'pa-Guru-IN' => 'פנג׳אבית (גורמוקי, הודו)',
        'pl' => 'פולנית',
        'pl-PL' => 'פולנית (פולין)',
        'ps' => 'פאשטו',
        'ps-AF' => 'פאשטו (אפגניסטן)',
        'pt' => 'פורטוגלית',
        'pt-AO' => 'פורטוגלית (אנגולה)',
        'pt-BR' => 'פורטוגלית (ברזיל)',
        'pt-CV' => 'פורטוגלית (כף ורדה)',
        'pt-GW' => 'פורטוגלית (גיניאה-ביסאו)',
        'pt-MO' => 'פורטוגלית (מקאו - מחוז מנהלי מיוחד של סין)',
        'pt-MZ' => 'פורטוגלית (מוזמביק)',
        'pt-PT' => 'פורטוגלית (פורטוגל)',
        'pt-ST' => 'פורטוגלית (סאו טומה ופרינסיפה)',
        'pt-TL' => 'פורטוגלית (טימור לסטה)',
        'qu' => 'קצ׳ואה',
        'qu-BO' => 'קצ׳ואה (בוליביה)',
        'qu-EC' => 'קצ׳ואה (אקוודור)',
        'qu-PE' => 'קצ׳ואה (פרו)',
        'rm' => 'רומאנש',
        'rm-CH' => 'רומאנש (שווייץ)',
        'rn' => 'קירונדי',
        'rn-BI' => 'קירונדי (בורונדי)',
        'ro' => 'רומנית',
        'ro-MD' => 'רומנית (מולדובה)',
        'ro-RO' => 'רומנית (רומניה)',
        'rof' => 'רומבו',
        'rof-TZ' => 'רומבו (טנזניה)',
        'ru' => 'רוסית',
        'ru-BY' => 'רוסית (בלארוס)',
        'ru-KG' => 'רוסית (קירגיזסטן)',
        'ru-KZ' => 'רוסית (קזחסטן)',
        'ru-MD' => 'רוסית (מולדובה)',
        'ru-RU' => 'רוסית (רוסיה)',
        'ru-UA' => 'רוסית (אוקראינה)',
        'rw' => 'קינירואנדה',
        'rw-RW' => 'קינירואנדה (רואנדה)',
        'rwk' => 'רווא',
        'rwk-TZ' => 'רווא (טנזניה)',
        'sah' => 'סאחה',
        'sah-RU' => 'סאחה (רוסיה)',
        'saq' => 'סמבורו',
        'saq-KE' => 'סמבורו (קניה)',
        'sbp' => 'סאנגו',
        'sbp-TZ' => 'סאנגו (טנזניה)',
        'se' => 'לאפית צפונית',
        'se-FI' => 'לאפית צפונית (פינלנד)',
        'se-NO' => 'לאפית צפונית (נורווגיה)',
        'se-SE' => 'לאפית צפונית (שוודיה)',
        'seh' => 'סנה',
        'seh-MZ' => 'סנה (מוזמביק)',
        'ses' => 'קויראבורו סני',
        'ses-ML' => 'קויראבורו סני (מאלי)',
        'sg' => 'סנגו',
        'sg-CF' => 'סנגו (הרפובליקה של מרכז אפריקה)',
        'shi' => 'טצ׳להיט',
        'shi-Latn' => 'טצ׳להיט (לטיני)',
        'shi-Latn-MA' => 'טצ׳להיט (לטיני, מרוקו)',
        'shi-Tfng' => 'טצ׳להיט (Tfng)',
        'shi-Tfng-MA' => 'טצ׳להיט (Tfng, מרוקו)',
        'si' => 'סינהלה',
        'si-LK' => 'סינהלה (סרי לנקה)',
        'sk' => 'סלובקית',
        'sk-SK' => 'סלובקית (סלובקיה)',
        'sl' => 'סלובנית',
        'sl-SI' => 'סלובנית (סלובניה)',
        'smn' => 'אינארי סאמי',
        'smn-FI' => 'אינארי סאמי (פינלנד)',
        'sn' => 'שונה',
        'sn-ZW' => 'שונה (זימבאבווה)',
        'so' => 'סומלית',
        'so-DJ' => 'סומלית (ג׳יבוטי)',
        'so-ET' => 'סומלית (אתיופיה)',
        'so-KE' => 'סומלית (קניה)',
        'so-SO' => 'סומלית (סומליה)',
        'sq' => 'אלבנית',
        'sq-AL' => 'אלבנית (אלבניה)',
        'sq-MK' => 'אלבנית (מקדוניה)',
        'sq-XK' => 'אלבנית (קוסובו)',
        'sr' => 'סרבית',
        'sr-Cyrl' => 'סרבית (קירילי)',
        'sr-Cyrl-BA' => 'סרבית (קירילי, בוסניה והרצגובינה)',
        'sr-Cyrl-ME' => 'סרבית (קירילי, מונטנגרו)',
        'sr-Cyrl-RS' => 'סרבית (קירילי, סרביה)',
        'sr-Cyrl-XK' => 'סרבית (קירילי, קוסובו)',
        'sr-Latn' => 'סרבית (לטיני)',
        'sr-Latn-BA' => 'סרבית (לטיני, בוסניה והרצגובינה)',
        'sr-Latn-ME' => 'סרבית (לטיני, מונטנגרו)',
        'sr-Latn-RS' => 'סרבית (לטיני, סרביה)',
        'sr-Latn-XK' => 'סרבית (לטיני, קוסובו)',
        'sv' => 'שוודית',
        'sv-AX' => 'שוודית (איי אולנד)',
        'sv-FI' => 'שוודית (פינלנד)',
        'sv-SE' => 'שוודית (שוודיה)',
        'sw' => 'סווהילית',
        'sw-CD' => 'סווהילית (קונגו - קינשאסה)',
        'sw-KE' => 'סווהילית (קניה)',
        'sw-TZ' => 'סווהילית (טנזניה)',
        'sw-UG' => 'סווהילית (אוגנדה)',
        'ta' => 'טמילית',
        'ta-IN' => 'טמילית (הודו)',
        'ta-LK' => 'טמילית (סרי לנקה)',
        'ta-MY' => 'טמילית (מלזיה)',
        'ta-SG' => 'טמילית (סינגפור)',
        'te' => 'טלוגו',
        'te-IN' => 'טלוגו (הודו)',
        'teo' => 'טסו',
        'teo-KE' => 'טסו (קניה)',
        'teo-UG' => 'טסו (אוגנדה)',
        'th' => 'תאית',
        'th-TH' => 'תאית (תאילנד)',
        'ti' => 'טיגרינאית',
        'ti-ER' => 'טיגרינאית (אריתריאה)',
        'ti-ET' => 'טיגרינאית (אתיופיה)',
        'to' => 'טונגן',
        'to-TO' => 'טונגן (טונגה)',
        'tr' => 'טורקית',
        'tr-CY' => 'טורקית (קפריסין)',
        'tr-TR' => 'טורקית (טורקיה)',
        'twq' => 'טסוואק',
        'twq-NE' => 'טסוואק (ניז׳ר)',
        'tzm' => 'טמזייט של מרכז מרוקו',
        'tzm-MA' => 'טמזייט של מרכז מרוקו (מרוקו)',
        'ug' => 'אויגהור',
        'ug-CN' => 'אויגהור (סין)',
        'uk' => 'אוקראינית',
        'uk-UA' => 'אוקראינית (אוקראינה)',
        'ur' => 'אורדו',
        'ur-IN' => 'אורדו (הודו)',
        'ur-PK' => 'אורדו (פקיסטן)',
        'uz' => 'אוזבקית',
        'uz-Arab' => 'אוזבקית (ערבי)',
        'uz-Arab-AF' => 'אוזבקית (ערבי, אפגניסטן)',
        'uz-Cyrl' => 'אוזבקית (קירילי)',
        'uz-Cyrl-UZ' => 'אוזבקית (קירילי, אוזבקיסטן)',
        'uz-Latn' => 'אוזבקית (לטיני)',
        'uz-Latn-UZ' => 'אוזבקית (לטיני, אוזבקיסטן)',
        'vai' => 'ואי',
        'vai-Latn' => 'ואי (לטיני)',
        'vai-Latn-LR' => 'ואי (לטיני, ליבריה)',
        'vai-Vaii' => 'ואי (Vaii)',
        'vai-Vaii-LR' => 'ואי (Vaii, ליבריה)',
        'vi' => 'ויאטנמית',
        'vi-VN' => 'ויאטנמית (וייטנאם)',
        'vun' => 'וונג׳ו',
        'vun-TZ' => 'וונג׳ו (טנזניה)',
        'wae' => 'וואלסר',
        'wae-CH' => 'וואלסר (שווייץ)',
        'xog' => 'סוגה',
        'xog-UG' => 'סוגה (אוגנדה)',
        'yav' => 'יאנגבן',
        'yav-CM' => 'יאנגבן (קמרון)',
        'yi' => 'יידיש',
        'yi-001' => 'יידיש (העולם)',
        'yo' => 'יורובה',
        'yo-BJ' => 'יורובה (בנין)',
        'yo-NG' => 'יורובה (ניגריה)',
        'yue' => 'קנטונזית',
        'yue-HK' => 'קנטונזית (הונג קונג - מחוז מנהלי מיוחד של סין)',
        'zgh' => 'תמזיע׳ת מרוקאית תקנית',
        'zgh-MA' => 'תמזיע׳ת מרוקאית תקנית (מרוקו)',
        'zh' => 'סינית',
        'zh-Hans' => 'סינית (מפושט)',
        'zh-Hans-CN' => 'סינית (מפושט, סין)',
        'zh-Hans-HK' => 'סינית (מפושט, הונג קונג - מחוז מנהלי מיוחד של סין)',
        'zh-Hans-MO' => 'סינית (מפושט, מקאו - מחוז מנהלי מיוחד של סין)',
        'zh-Hans-SG' => 'סינית (מפושט, סינגפור)',
        'zh-Hant' => 'סינית (מסורתי)',
        'zh-Hant-HK' => 'סינית (מסורתי, הונג קונג - מחוז מנהלי מיוחד של סין)',
        'zh-Hant-MO' => 'סינית (מסורתי, מקאו - מחוז מנהלי מיוחד של סין)',
        'zh-Hant-TW' => 'סינית (מסורתי, טייוואן)',
        'zu' => 'זולו',
        'zu-ZA' => 'זולו (דרום אפריקה)',
    ],
];
