<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.y',
            'time' => 'HH.mm',
            'datetime' => 'd.M.y, HH.mm',
        ],
        'medium' => [
            'date' => 'd. MMM y',
            'time' => 'HH.mm.ss',
            'datetime' => 'd. MMM y, HH.mm.ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'HH.mm.ss z',
            'datetime' => 'd. MMMM y \'kl\'. HH.mm.ss z',
        ],
        'full' => [
            'date' => 'EEEE d. MMMM y',
            'time' => '\'kl\'. HH.mm.ss zzzz',
            'datetime' => 'EEEE d. MMMM y \'kl\'. HH.mm.ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'formiddag',
    'pmName' => 'ettermiddag',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '−',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '−',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'mai',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.',
        ],
        'full' => [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'mai',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.',
        ],
        'full' => [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø.',
            'må.',
            'ty.',
            'on.',
            'to.',
            'fr.',
            'la.',
        ],
        'medium' => [
            'sø.',
            'må.',
            'ty.',
            'on.',
            'to.',
            'fr.',
            'la.',
        ],
        'full' => [
            'søndag',
            'måndag',
            'tysdag',
            'onsdag',
            'torsdag',
            'fredag',
            'laurdag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø.',
            'må.',
            'ty.',
            'on.',
            'to.',
            'fr.',
            'la.',
        ],
        'medium' => [
            'sø.',
            'må.',
            'ty.',
            'on.',
            'to.',
            'fr.',
            'la.',
        ],
        'full' => [
            'søndag',
            'måndag',
            'tysdag',
            'onsdag',
            'torsdag',
            'fredag',
            'laurdag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Sør-Afrika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amharisk',
        'am-ET' => 'amharisk (Etiopia)',
        'ar' => 'arabisk',
        'ar-001' => 'arabisk (verda)',
        'ar-AE' => 'arabisk (Dei sameinte arabiske emirata)',
        'ar-BH' => 'arabisk (Bahrain)',
        'ar-DJ' => 'arabisk (Djibouti)',
        'ar-DZ' => 'arabisk (Algerie)',
        'ar-EG' => 'arabisk (Egypt)',
        'ar-EH' => 'arabisk (Vest-Sahara)',
        'ar-ER' => 'arabisk (Eritrea)',
        'ar-IL' => 'arabisk (Israel)',
        'ar-IQ' => 'arabisk (Irak)',
        'ar-JO' => 'arabisk (Jordan)',
        'ar-KM' => 'arabisk (Komorene)',
        'ar-KW' => 'arabisk (Kuwait)',
        'ar-LB' => 'arabisk (Libanon)',
        'ar-LY' => 'arabisk (Libya)',
        'ar-MA' => 'arabisk (Marokko)',
        'ar-MR' => 'arabisk (Mauritania)',
        'ar-OM' => 'arabisk (Oman)',
        'ar-PS' => 'arabisk (Palestinsk territorium)',
        'ar-QA' => 'arabisk (Qatar)',
        'ar-SA' => 'arabisk (Saudi Arabia)',
        'ar-SD' => 'arabisk (Sudan)',
        'ar-SO' => 'arabisk (Somalia)',
        'ar-SS' => 'arabisk (SS)',
        'ar-SY' => 'arabisk (Syria)',
        'ar-TD' => 'arabisk (Tchad)',
        'ar-TN' => 'arabisk (Tunisia)',
        'ar-YE' => 'arabisk (Yemen)',
        'as' => 'assamisk',
        'as-IN' => 'assamisk (India)',
        'asa' => 'asu (Tanzania)',
        'asa-TZ' => 'asu (Tanzania) (Tanzania)',
        'ast' => 'asturisk',
        'ast-ES' => 'asturisk (Spania)',
        'az' => 'aserbajdsjansk',
        'az-Cyrl' => 'aserbajdsjansk (kyrillisk)',
        'az-Cyrl-AZ' => 'aserbajdsjansk (kyrillisk, Aserbajdsjan)',
        'az-Latn' => 'aserbajdsjansk (latinsk)',
        'az-Latn-AZ' => 'aserbajdsjansk (latinsk, Aserbajdsjan)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Kamerun)',
        'be' => 'kviterussisk',
        'be-BY' => 'kviterussisk (Kviterussland)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena (Tanzania)',
        'bez-TZ' => 'bena (Tanzania) (Tanzania)',
        'bg' => 'bulgarsk',
        'bg-BG' => 'bulgarsk (Bulgaria)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (India)',
        'bo' => 'tibetansk',
        'bo-CN' => 'tibetansk (Kina)',
        'bo-IN' => 'tibetansk (India)',
        'br' => 'bretonsk',
        'br-FR' => 'bretonsk (Frankrike)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosnisk',
        'bs-Cyrl' => 'bosnisk (kyrillisk)',
        'bs-Cyrl-BA' => 'bosnisk (kyrillisk, Bosnia og Hercegovina)',
        'bs-Latn' => 'bosnisk (latinsk)',
        'bs-Latn-BA' => 'bosnisk (latinsk, Bosnia og Hercegovina)',
        'ca' => 'katalansk',
        'ca-AD' => 'katalansk (Andorra)',
        'ca-ES' => 'katalansk (Spania)',
        'ca-FR' => 'katalansk (Frankrike)',
        'ca-IT' => 'katalansk (Italia)',
        'ce' => 'tsjetsjensk',
        'ce-RU' => 'tsjetsjensk (Russland)',
        'cgg' => 'cgg',
        'cgg-UG' => 'cgg (Uganda)',
        'chr' => 'cherokee',
        'chr-US' => 'cherokee (USA)',
        'cs' => 'tsjekkisk',
        'cs-CZ' => 'tsjekkisk (Tsjekkia)',
        'cy' => 'walisisk',
        'cy-GB' => 'walisisk (Storbritannia)',
        'da' => 'dansk',
        'da-DK' => 'dansk (Danmark)',
        'da-GL' => 'dansk (Grønland)',
        'dav' => 'dav',
        'dav-KE' => 'dav (Kenya)',
        'de' => 'tysk',
        'de-AT' => 'tysk (Austerrike)',
        'de-BE' => 'tysk (Belgia)',
        'de-CH' => 'tysk (Sveits)',
        'de-DE' => 'tysk (Tyskland)',
        'de-LI' => 'tysk (Liechtenstein)',
        'de-LU' => 'tysk (Luxembourg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'lågsorbisk',
        'dsb-DE' => 'lågsorbisk (Tyskland)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhutan)',
        'ebu' => 'kiembu',
        'ebu-KE' => 'kiembu (Kenya)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'gresk',
        'el-CY' => 'gresk (Kypros)',
        'el-GR' => 'gresk (Hellas)',
        'en' => 'engelsk',
        'en-001' => 'engelsk (verda)',
        'en-150' => 'engelsk (Europa)',
        'en-AG' => 'engelsk (Antigua og Barbuda)',
        'en-AI' => 'engelsk (Anguilla)',
        'en-AS' => 'engelsk (Amerikansk Samoa)',
        'en-AT' => 'engelsk (Austerrike)',
        'en-AU' => 'engelsk (Australia)',
        'en-BB' => 'engelsk (Barbados)',
        'en-BE' => 'engelsk (Belgia)',
        'en-BI' => 'engelsk (Burundi)',
        'en-BM' => 'engelsk (Bermuda)',
        'en-BS' => 'engelsk (Bahamas)',
        'en-BW' => 'engelsk (Botswana)',
        'en-BZ' => 'engelsk (Belize)',
        'en-CA' => 'engelsk (Canada)',
        'en-CC' => 'engelsk (Kokosøyane)',
        'en-CH' => 'engelsk (Sveits)',
        'en-CK' => 'engelsk (Cookøyane)',
        'en-CM' => 'engelsk (Kamerun)',
        'en-CX' => 'engelsk (Christmasøya)',
        'en-CY' => 'engelsk (Kypros)',
        'en-DE' => 'engelsk (Tyskland)',
        'en-DG' => 'engelsk (Diego Garcia)',
        'en-DK' => 'engelsk (Danmark)',
        'en-DM' => 'engelsk (Dominica)',
        'en-ER' => 'engelsk (Eritrea)',
        'en-FI' => 'engelsk (Finland)',
        'en-FJ' => 'engelsk (Fiji)',
        'en-FK' => 'engelsk (Falklandsøyane)',
        'en-FM' => 'engelsk (Mikronesiaføderasjonen)',
        'en-GB' => 'engelsk (Storbritannia)',
        'en-GD' => 'engelsk (Grenada)',
        'en-GG' => 'engelsk (Guernsey)',
        'en-GH' => 'engelsk (Ghana)',
        'en-GI' => 'engelsk (Gibraltar)',
        'en-GM' => 'engelsk (Gambia)',
        'en-GU' => 'engelsk (Guam)',
        'en-GY' => 'engelsk (Guyana)',
        'en-HK' => 'engelsk (Hongkong S.A.R. Kina)',
        'en-IE' => 'engelsk (Irland)',
        'en-IL' => 'engelsk (Israel)',
        'en-IM' => 'engelsk (Man)',
        'en-IN' => 'engelsk (India)',
        'en-IO' => 'engelsk (Britiske område i Det indiske hav)',
        'en-JE' => 'engelsk (Jersey)',
        'en-JM' => 'engelsk (Jamaica)',
        'en-KE' => 'engelsk (Kenya)',
        'en-KI' => 'engelsk (Kiribati)',
        'en-KN' => 'engelsk (St. Christopher og Nevis)',
        'en-KY' => 'engelsk (Caymanøyane)',
        'en-LC' => 'engelsk (St. Lucia)',
        'en-LR' => 'engelsk (Liberia)',
        'en-LS' => 'engelsk (Lesotho)',
        'en-MG' => 'engelsk (Madagaskar)',
        'en-MH' => 'engelsk (Marshalløyane)',
        'en-MO' => 'engelsk (Macao S.A.R. Kina)',
        'en-MP' => 'engelsk (Nord-Marianane)',
        'en-MS' => 'engelsk (Montserrat)',
        'en-MT' => 'engelsk (Malta)',
        'en-MU' => 'engelsk (Mauritius)',
        'en-MW' => 'engelsk (Malawi)',
        'en-MY' => 'engelsk (Malaysia)',
        'en-NA' => 'engelsk (Namibia)',
        'en-NF' => 'engelsk (Norfolkøyane)',
        'en-NG' => 'engelsk (Nigeria)',
        'en-NL' => 'engelsk (Nederland)',
        'en-NR' => 'engelsk (Nauru)',
        'en-NU' => 'engelsk (Niue)',
        'en-NZ' => 'engelsk (New Zealand)',
        'en-PG' => 'engelsk (Papua Ny-Guinea)',
        'en-PH' => 'engelsk (Filippinane)',
        'en-PK' => 'engelsk (Pakistan)',
        'en-PN' => 'engelsk (Pitcairn)',
        'en-PR' => 'engelsk (Puerto Rico)',
        'en-PW' => 'engelsk (Palau)',
        'en-RW' => 'engelsk (Rwanda)',
        'en-SB' => 'engelsk (Salomonøyane)',
        'en-SC' => 'engelsk (Seychellane)',
        'en-SD' => 'engelsk (Sudan)',
        'en-SE' => 'engelsk (Sverige)',
        'en-SG' => 'engelsk (Singapore)',
        'en-SH' => 'engelsk (Saint Helena)',
        'en-SI' => 'engelsk (Slovenia)',
        'en-SL' => 'engelsk (Sierra Leone)',
        'en-SS' => 'engelsk (SS)',
        'en-SX' => 'engelsk (SX)',
        'en-SZ' => 'engelsk (Swaziland)',
        'en-TC' => 'engelsk (Turks- og Caicosøyane)',
        'en-TK' => 'engelsk (Tokelau)',
        'en-TO' => 'engelsk (Tonga)',
        'en-TT' => 'engelsk (Trinidad og Tobago)',
        'en-TV' => 'engelsk (Tuvalu)',
        'en-TZ' => 'engelsk (Tanzania)',
        'en-UG' => 'engelsk (Uganda)',
        'en-UM' => 'engelsk (USAs ytre småøyar)',
        'en-US' => 'engelsk (USA)',
        'en-US-POSIX' => 'engelsk (USA, dataspråk)',
        'en-VC' => 'engelsk (St. Vincent og Grenadinane)',
        'en-VG' => 'engelsk (Dei britiske jomfruøyane)',
        'en-VI' => 'engelsk (Dei amerikanske jomfruøyane)',
        'en-VU' => 'engelsk (Vanuatu)',
        'en-WS' => 'engelsk (Samoa)',
        'en-ZA' => 'engelsk (Sør-Afrika)',
        'en-ZM' => 'engelsk (Zambia)',
        'en-ZW' => 'engelsk (Zimbabwe)',
        'eo' => 'esperanto',
        'es' => 'spansk',
        'es-419' => 'spansk (Latin-Amerika)',
        'es-AR' => 'spansk (Argentina)',
        'es-BO' => 'spansk (Bolivia)',
        'es-CL' => 'spansk (Chile)',
        'es-CO' => 'spansk (Colombia)',
        'es-CR' => 'spansk (Costa Rica)',
        'es-CU' => 'spansk (Cuba)',
        'es-DO' => 'spansk (Den dominikanske republikken)',
        'es-EA' => 'spansk (Ceuta og Melilla)',
        'es-EC' => 'spansk (Ecuador)',
        'es-ES' => 'spansk (Spania)',
        'es-GQ' => 'spansk (Ekvatorial-Guinea)',
        'es-GT' => 'spansk (Guatemala)',
        'es-HN' => 'spansk (Honduras)',
        'es-IC' => 'spansk (Kanariøyane)',
        'es-MX' => 'spansk (Mexico)',
        'es-NI' => 'spansk (Nicaragua)',
        'es-PA' => 'spansk (Panama)',
        'es-PE' => 'spansk (Peru)',
        'es-PH' => 'spansk (Filippinane)',
        'es-PR' => 'spansk (Puerto Rico)',
        'es-PY' => 'spansk (Paraguay)',
        'es-SV' => 'spansk (El Salvador)',
        'es-US' => 'spansk (USA)',
        'es-UY' => 'spansk (Uruguay)',
        'es-VE' => 'spansk (Venezuela)',
        'et' => 'estisk',
        'et-EE' => 'estisk (Estland)',
        'eu' => 'baskisk',
        'eu-ES' => 'baskisk (Spania)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'persisk',
        'fa-AF' => 'persisk (Afghanistan)',
        'fa-IR' => 'persisk (Iran)',
        'ff' => 'fulani',
        'ff-CM' => 'fulani (Kamerun)',
        'ff-GN' => 'fulani (Guinea)',
        'ff-MR' => 'fulani (Mauritania)',
        'ff-SN' => 'fulani (Senegal)',
        'fi' => 'finsk',
        'fi-FI' => 'finsk (Finland)',
        'fil' => 'filippinsk',
        'fil-PH' => 'filippinsk (Filippinane)',
        'fo' => 'færøysk',
        'fo-DK' => 'færøysk (Danmark)',
        'fo-FO' => 'færøysk (Færøyane)',
        'fr' => 'fransk',
        'fr-BE' => 'fransk (Belgia)',
        'fr-BF' => 'fransk (Burkina Faso)',
        'fr-BI' => 'fransk (Burundi)',
        'fr-BJ' => 'fransk (Benin)',
        'fr-BL' => 'fransk (Saint Barthélemy)',
        'fr-CA' => 'fransk (Canada)',
        'fr-CD' => 'fransk (Kongo-Kinshasa)',
        'fr-CF' => 'fransk (Den sentralafrikanske republikken)',
        'fr-CG' => 'fransk (Kongo-Brazzaville)',
        'fr-CH' => 'fransk (Sveits)',
        'fr-CI' => 'fransk (Elfenbeinskysten)',
        'fr-CM' => 'fransk (Kamerun)',
        'fr-DJ' => 'fransk (Djibouti)',
        'fr-DZ' => 'fransk (Algerie)',
        'fr-FR' => 'fransk (Frankrike)',
        'fr-GA' => 'fransk (Gabon)',
        'fr-GF' => 'fransk (Fransk Guyana)',
        'fr-GN' => 'fransk (Guinea)',
        'fr-GP' => 'fransk (Guadeloupe)',
        'fr-GQ' => 'fransk (Ekvatorial-Guinea)',
        'fr-HT' => 'fransk (Haiti)',
        'fr-KM' => 'fransk (Komorene)',
        'fr-LU' => 'fransk (Luxembourg)',
        'fr-MA' => 'fransk (Marokko)',
        'fr-MC' => 'fransk (Monaco)',
        'fr-MF' => 'fransk (Saint Martin)',
        'fr-MG' => 'fransk (Madagaskar)',
        'fr-ML' => 'fransk (Mali)',
        'fr-MQ' => 'fransk (Martinique)',
        'fr-MR' => 'fransk (Mauritania)',
        'fr-MU' => 'fransk (Mauritius)',
        'fr-NC' => 'fransk (Ny-Caledonia)',
        'fr-NE' => 'fransk (Niger)',
        'fr-PF' => 'fransk (Fransk Polynesia)',
        'fr-PM' => 'fransk (St. Pierre og Miquelon)',
        'fr-RE' => 'fransk (Réunion)',
        'fr-RW' => 'fransk (Rwanda)',
        'fr-SC' => 'fransk (Seychellane)',
        'fr-SN' => 'fransk (Senegal)',
        'fr-SY' => 'fransk (Syria)',
        'fr-TD' => 'fransk (Tchad)',
        'fr-TG' => 'fransk (Togo)',
        'fr-TN' => 'fransk (Tunisia)',
        'fr-VU' => 'fransk (Vanuatu)',
        'fr-WF' => 'fransk (Wallis og Futuna)',
        'fr-YT' => 'fransk (Mayotte)',
        'fur' => 'friuliansk',
        'fur-IT' => 'friuliansk (Italia)',
        'fy' => 'vestfrisisk',
        'fy-NL' => 'vestfrisisk (Nederland)',
        'ga' => 'irsk',
        'ga-IE' => 'irsk (Irland)',
        'gd' => 'skotsk-gælisk',
        'gd-GB' => 'skotsk-gælisk (Storbritannia)',
        'gl' => 'galicisk',
        'gl-ES' => 'galicisk (Spania)',
        'gsw' => 'sveitsertysk',
        'gsw-CH' => 'sveitsertysk (Sveits)',
        'gsw-FR' => 'sveitsertysk (Frankrike)',
        'gsw-LI' => 'sveitsertysk (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (India)',
        'guz' => 'guz',
        'guz-KE' => 'guz (Kenya)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiisk',
        'haw-US' => 'hawaiisk (USA)',
        'he' => 'hebraisk',
        'he-IL' => 'hebraisk (Israel)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (India)',
        'hr' => 'kroatisk',
        'hr-BA' => 'kroatisk (Bosnia og Hercegovina)',
        'hr-HR' => 'kroatisk (Kroatia)',
        'hsb' => 'høgsorbisk',
        'hsb-DE' => 'høgsorbisk (Tyskland)',
        'hu' => 'ungarsk',
        'hu-HU' => 'ungarsk (Ungarn)',
        'hy' => 'armensk',
        'hy-AM' => 'armensk (Armenia)',
        'id' => 'indonesisk',
        'id-ID' => 'indonesisk (Indonesia)',
        'ig' => 'ibo',
        'ig-NG' => 'ibo (Nigeria)',
        'ii' => 'sichuan-yi',
        'ii-CN' => 'sichuan-yi (Kina)',
        'is' => 'islandsk',
        'is-IS' => 'islandsk (Island)',
        'it' => 'italiensk',
        'it-CH' => 'italiensk (Sveits)',
        'it-IT' => 'italiensk (Italia)',
        'it-SM' => 'italiensk (San Marino)',
        'ja' => 'japansk',
        'ja-JP' => 'japansk (Japan)',
        'jgo' => 'jgo',
        'jgo-CM' => 'jgo (Kamerun)',
        'jmc' => 'jmc',
        'jmc-TZ' => 'jmc (Tanzania)',
        'ka' => 'georgisk',
        'ka-GE' => 'georgisk (Georgia)',
        'kab' => 'kabylsk',
        'kab-DZ' => 'kabylsk (Algerie)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'kde',
        'kde-TZ' => 'kde (Tanzania)',
        'kea' => 'kapverdisk',
        'kea-CV' => 'kapverdisk (Kapp Verde)',
        'khq' => 'khq',
        'khq-ML' => 'khq (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kasakhisk',
        'kk-KZ' => 'kasakhisk (Kasakhstan)',
        'kkj' => 'kkj',
        'kkj-CM' => 'kkj (Kamerun)',
        'kl' => 'kalaallisut; grønlandsk',
        'kl-GL' => 'kalaallisut; grønlandsk (Grønland)',
        'kln' => 'kln',
        'kln-KE' => 'kln (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Kambodsja)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (India)',
        'ko' => 'koreansk',
        'ko-KP' => 'koreansk (Nord-Korea)',
        'ko-KR' => 'koreansk (Sør-Korea)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (India)',
        'ks' => 'kasjmiri',
        'ks-IN' => 'kasjmiri (India)',
        'ksb' => 'ksb',
        'ksb-TZ' => 'ksb (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'ksh',
        'ksh-DE' => 'ksh (Tyskland)',
        'kw' => 'kornisk',
        'kw-GB' => 'kornisk (Storbritannia)',
        'ky' => 'kirgisisk',
        'ky-KG' => 'kirgisisk (Kirgisistan)',
        'lag' => 'lag',
        'lag-TZ' => 'lag (Tanzania)',
        'lb' => 'luxemburgsk',
        'lb-LU' => 'luxemburgsk (Luxembourg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lkt',
        'lkt-US' => 'lkt (USA)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Kongo-Kinshasa)',
        'ln-CF' => 'lingala (Den sentralafrikanske republikken)',
        'ln-CG' => 'lingala (Kongo-Brazzaville)',
        'lo' => 'laotisk',
        'lo-LA' => 'laotisk (Laos)',
        'lrc' => 'lrc',
        'lrc-IQ' => 'lrc (Irak)',
        'lrc-IR' => 'lrc (Iran)',
        'lt' => 'litauisk',
        'lt-LT' => 'litauisk (Litauen)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Kongo-Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'luy',
        'luy-KE' => 'luy (Kenya)',
        'lv' => 'latvisk',
        'lv-LV' => 'latvisk (Latvia)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzania)',
        'mer' => 'mer',
        'mer-KE' => 'mer (Kenya)',
        'mfe' => 'mfe',
        'mfe-MU' => 'mfe (Mauritius)',
        'mg' => 'madagassisk',
        'mg-MG' => 'madagassisk (Madagaskar)',
        'mgh' => 'mgh',
        'mgh-MZ' => 'mgh (Mosambik)',
        'mgo' => 'mgo',
        'mgo-CM' => 'mgo (Kamerun)',
        'mk' => 'makedonsk',
        'mk-MK' => 'makedonsk (Makedonia)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (India)',
        'mn' => 'mongolsk',
        'mn-MN' => 'mongolsk (Mongolia)',
        'mr' => 'marathi',
        'mr-IN' => 'marathi (India)',
        'ms' => 'malayisk',
        'ms-BN' => 'malayisk (Brunei Darussalam)',
        'ms-MY' => 'malayisk (Malaysia)',
        'ms-SG' => 'malayisk (Singapore)',
        'mt' => 'maltesisk',
        'mt-MT' => 'maltesisk (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'burmesisk',
        'my-MM' => 'burmesisk (Myanmar)',
        'mzn' => 'mzn',
        'mzn-IR' => 'mzn (Iran)',
        'naq' => 'naq',
        'naq-NA' => 'naq (Namibia)',
        'nb' => 'bokmål',
        'nb-NO' => 'bokmål (Noreg)',
        'nb-SJ' => 'bokmål (Svalbard og Jan Mayen)',
        'nd' => 'nord-ndebele',
        'nd-ZW' => 'nord-ndebele (Zimbabwe)',
        'ne' => 'nepalsk',
        'ne-IN' => 'nepalsk (India)',
        'ne-NP' => 'nepalsk (Nepal)',
        'nl' => 'nederlandsk',
        'nl-AW' => 'nederlandsk (Aruba)',
        'nl-BE' => 'nederlandsk (Belgia)',
        'nl-BQ' => 'nederlandsk (BQ)',
        'nl-CW' => 'nederlandsk (CW)',
        'nl-NL' => 'nederlandsk (Nederland)',
        'nl-SR' => 'nederlandsk (Surinam)',
        'nl-SX' => 'nederlandsk (SX)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Kamerun)',
        'nn' => 'nynorsk',
        'nn-NO' => 'nynorsk (Noreg)',
        'nnh' => 'nnh',
        'nnh-CM' => 'nnh (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (SS)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopia)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'oriya',
        'or-IN' => 'oriya (India)',
        'os' => 'ossetisk',
        'os-GE' => 'ossetisk (Georgia)',
        'os-RU' => 'ossetisk (Russland)',
        'pa' => 'panjabi',
        'pa-Arab' => 'panjabi (arabisk)',
        'pa-Arab-PK' => 'panjabi (arabisk, Pakistan)',
        'pa-Guru' => 'panjabi (gurmukhi)',
        'pa-Guru-IN' => 'panjabi (gurmukhi, India)',
        'pl' => 'polsk',
        'pl-PL' => 'polsk (Polen)',
        'ps' => 'pashto',
        'ps-AF' => 'pashto (Afghanistan)',
        'pt' => 'portugisisk',
        'pt-AO' => 'portugisisk (Angola)',
        'pt-BR' => 'portugisisk (Brasil)',
        'pt-CV' => 'portugisisk (Kapp Verde)',
        'pt-GW' => 'portugisisk (Guinea-Bissau)',
        'pt-MO' => 'portugisisk (Macao S.A.R. Kina)',
        'pt-MZ' => 'portugisisk (Mosambik)',
        'pt-PT' => 'portugisisk (Portugal)',
        'pt-ST' => 'portugisisk (São Tomé og Príncipe)',
        'pt-TL' => 'portugisisk (Aust-Timor)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Peru)',
        'rm' => 'retoromansk',
        'rm-CH' => 'retoromansk (Sveits)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumensk',
        'ro-MD' => 'rumensk (Moldova)',
        'ro-RO' => 'rumensk (Romania)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'russisk',
        'ru-BY' => 'russisk (Kviterussland)',
        'ru-KG' => 'russisk (Kirgisistan)',
        'ru-KZ' => 'russisk (Kasakhstan)',
        'ru-MD' => 'russisk (Moldova)',
        'ru-RU' => 'russisk (Russland)',
        'ru-UA' => 'russisk (Ukraina)',
        'rw' => 'kinjarwanda',
        'rw-RW' => 'kinjarwanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'jakutsk',
        'sah-RU' => 'jakutsk (Russland)',
        'saq' => 'saq',
        'saq-KE' => 'saq (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'nordsamisk',
        'se-FI' => 'nordsamisk (Finland)',
        'se-NO' => 'nordsamisk (Noreg)',
        'se-SE' => 'nordsamisk (Sverige)',
        'seh' => 'seh',
        'seh-MZ' => 'seh (Mosambik)',
        'ses' => 'ses',
        'ses-ML' => 'ses (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Den sentralafrikanske republikken)',
        'shi' => 'shi',
        'shi-Latn' => 'shi (latinsk)',
        'shi-Latn-MA' => 'shi (latinsk, Marokko)',
        'shi-Tfng' => 'shi (tifinagh)',
        'shi-Tfng-MA' => 'shi (tifinagh, Marokko)',
        'si' => 'singalesisk',
        'si-LK' => 'singalesisk (Sri Lanka)',
        'sk' => 'slovakisk',
        'sk-SK' => 'slovakisk (Slovakia)',
        'sl' => 'slovensk',
        'sl-SI' => 'slovensk (Slovenia)',
        'smn' => 'enaresamisk',
        'smn-FI' => 'enaresamisk (Finland)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somali',
        'so-DJ' => 'somali (Djibouti)',
        'so-ET' => 'somali (Etiopia)',
        'so-KE' => 'somali (Kenya)',
        'so-SO' => 'somali (Somalia)',
        'sq' => 'albansk',
        'sq-AL' => 'albansk (Albania)',
        'sq-MK' => 'albansk (Makedonia)',
        'sq-XK' => 'albansk (XK)',
        'sr' => 'serbisk',
        'sr-Cyrl' => 'serbisk (kyrillisk)',
        'sr-Cyrl-BA' => 'serbisk (kyrillisk, Bosnia og Hercegovina)',
        'sr-Cyrl-ME' => 'serbisk (kyrillisk, Montenegro)',
        'sr-Cyrl-RS' => 'serbisk (kyrillisk, Serbia)',
        'sr-Cyrl-XK' => 'serbisk (kyrillisk, XK)',
        'sr-Latn' => 'serbisk (latinsk)',
        'sr-Latn-BA' => 'serbisk (latinsk, Bosnia og Hercegovina)',
        'sr-Latn-ME' => 'serbisk (latinsk, Montenegro)',
        'sr-Latn-RS' => 'serbisk (latinsk, Serbia)',
        'sr-Latn-XK' => 'serbisk (latinsk, XK)',
        'sv' => 'svensk',
        'sv-AX' => 'svensk (Åland)',
        'sv-FI' => 'svensk (Finland)',
        'sv-SE' => 'svensk (Sverige)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Kongo-Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzania)',
        'sw-UG' => 'swahili (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (India)',
        'ta-LK' => 'tamil (Sri Lanka)',
        'ta-MY' => 'tamil (Malaysia)',
        'ta-SG' => 'tamil (Singapore)',
        'te' => 'telugu',
        'te-IN' => 'telugu (India)',
        'teo' => 'teo',
        'teo-KE' => 'teo (Kenya)',
        'teo-UG' => 'teo (Uganda)',
        'th' => 'thai',
        'th-TH' => 'thai (Thailand)',
        'ti' => 'tigrinja',
        'ti-ER' => 'tigrinja (Eritrea)',
        'ti-ET' => 'tigrinja (Etiopia)',
        'to' => 'tonga (Tonga-øyane)',
        'to-TO' => 'tonga (Tonga-øyane) (Tonga)',
        'tr' => 'tyrkisk',
        'tr-CY' => 'tyrkisk (Kypros)',
        'tr-TR' => 'tyrkisk (Tyrkia)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'tzm',
        'tzm-MA' => 'tzm (Marokko)',
        'ug' => 'uigurisk',
        'ug-CN' => 'uigurisk (Kina)',
        'uk' => 'ukrainsk',
        'uk-UA' => 'ukrainsk (Ukraina)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (India)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'usbekisk',
        'uz-Arab' => 'usbekisk (arabisk)',
        'uz-Arab-AF' => 'usbekisk (arabisk, Afghanistan)',
        'uz-Cyrl' => 'usbekisk (kyrillisk)',
        'uz-Cyrl-UZ' => 'usbekisk (kyrillisk, Usbekistan)',
        'uz-Latn' => 'usbekisk (latinsk)',
        'uz-Latn-UZ' => 'usbekisk (latinsk, Usbekistan)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latinsk)',
        'vai-Latn-LR' => 'vai (latinsk, Liberia)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Liberia)',
        'vi' => 'vietnamesisk',
        'vi-VN' => 'vietnamesisk (Vietnam)',
        'vun' => 'vun',
        'vun-TZ' => 'vun (Tanzania)',
        'wae' => 'wae',
        'wae-CH' => 'wae (Sveits)',
        'xog' => 'xog',
        'xog-UG' => 'xog (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Kamerun)',
        'yi' => 'jiddisk',
        'yi-001' => 'jiddisk (verda)',
        'yo' => 'joruba',
        'yo-BJ' => 'joruba (Benin)',
        'yo-NG' => 'joruba (Nigeria)',
        'yue' => 'kantonesisk',
        'yue-HK' => 'kantonesisk (Hongkong S.A.R. Kina)',
        'zgh' => 'zgh',
        'zgh-MA' => 'zgh (Marokko)',
        'zh' => 'kinesisk',
        'zh-Hans' => 'kinesisk (forenkla kinesisk)',
        'zh-Hans-CN' => 'kinesisk (forenkla kinesisk, Kina)',
        'zh-Hans-HK' => 'kinesisk (forenkla kinesisk, Hongkong S.A.R. Kina)',
        'zh-Hans-MO' => 'kinesisk (forenkla kinesisk, Macao S.A.R. Kina)',
        'zh-Hans-SG' => 'kinesisk (forenkla kinesisk, Singapore)',
        'zh-Hant' => 'kinesisk (tradisjonell kinesisk)',
        'zh-Hant-HK' => 'kinesisk (tradisjonell kinesisk, Hongkong S.A.R. Kina)',
        'zh-Hant-MO' => 'kinesisk (tradisjonell kinesisk, Macao S.A.R. Kina)',
        'zh-Hant-TW' => 'kinesisk (tradisjonell kinesisk, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Sør-Afrika)',
    ],
];
