<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.y',
            'time' => 'HH:mm',
            'datetime' => 'd.M.y, HH:mm',
        ],
        'medium' => [
            'date' => 'd.M.y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd.M.y, HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE, d MMMM y HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD',
        'BRL' => 'R$',
        'CAD' => 'CAD',
        'CNY' => 'CNY',
        'EUR' => '€',
        'GBP' => 'GBP',
        'HKD' => 'HKD',
        'ILS' => 'ILS',
        'INR' => 'INR',
        'JPY' => 'JPY',
        'KRW' => 'KRW',
        'MXN' => 'MXN',
        'NZD' => 'NZD',
        'THB' => 'THB',
        'TWD' => 'TWD',
        'USD' => 'USD',
        'VND' => 'VND',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            's',
            'l',
            'm',
            'k',
            'm',
            'c',
            'l',
            's',
            'w',
            'p',
            'l',
            'g',
        ],
        'medium' => [
            'sty',
            'lut',
            'mar',
            'kwi',
            'maj',
            'cze',
            'lip',
            'sie',
            'wrz',
            'paź',
            'lis',
            'gru',
        ],
        'full' => [
            'styczeń',
            'luty',
            'marzec',
            'kwiecień',
            'maj',
            'czerwiec',
            'lipiec',
            'sierpień',
            'wrzesień',
            'październik',
            'listopad',
            'grudzień',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            's',
            'l',
            'm',
            'k',
            'm',
            'c',
            'l',
            's',
            'w',
            'p',
            'l',
            'g',
        ],
        'medium' => [
            'sty',
            'lut',
            'mar',
            'kwi',
            'maj',
            'cze',
            'lip',
            'sie',
            'wrz',
            'paź',
            'lis',
            'gru',
        ],
        'full' => [
            'stycznia',
            'lutego',
            'marca',
            'kwietnia',
            'maja',
            'czerwca',
            'lipca',
            'sierpnia',
            'września',
            'października',
            'listopada',
            'grudnia',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'N',
            'P',
            'W',
            'Ś',
            'C',
            'P',
            'S',
        ],
        'short' => [
            'nie',
            'pon',
            'wto',
            'śro',
            'czw',
            'pią',
            'sob',
        ],
        'medium' => [
            'niedz.',
            'pon.',
            'wt.',
            'śr.',
            'czw.',
            'pt.',
            'sob.',
        ],
        'full' => [
            'niedziela',
            'poniedziałek',
            'wtorek',
            'środa',
            'czwartek',
            'piątek',
            'sobota',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'N',
            'P',
            'W',
            'Ś',
            'C',
            'P',
            'S',
        ],
        'short' => [
            'nie',
            'pon',
            'wto',
            'śro',
            'czw',
            'pią',
            'sob',
        ],
        'medium' => [
            'niedz.',
            'pon.',
            'wt.',
            'śr.',
            'czw.',
            'pt.',
            'sob.',
        ],
        'full' => [
            'niedziela',
            'poniedziałek',
            'wtorek',
            'środa',
            'czwartek',
            'piątek',
            'sobota',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Republika Południowej Afryki)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amharski',
        'am-ET' => 'amharski (Etiopia)',
        'ar' => 'arabski',
        'ar-001' => 'arabski (świat)',
        'ar-AE' => 'arabski (Zjednoczone Emiraty Arabskie)',
        'ar-BH' => 'arabski (Bahrajn)',
        'ar-DJ' => 'arabski (Dżibuti)',
        'ar-DZ' => 'arabski (Algieria)',
        'ar-EG' => 'arabski (Egipt)',
        'ar-EH' => 'arabski (Sahara Zachodnia)',
        'ar-ER' => 'arabski (Erytrea)',
        'ar-IL' => 'arabski (Izrael)',
        'ar-IQ' => 'arabski (Irak)',
        'ar-JO' => 'arabski (Jordania)',
        'ar-KM' => 'arabski (Komory)',
        'ar-KW' => 'arabski (Kuwejt)',
        'ar-LB' => 'arabski (Liban)',
        'ar-LY' => 'arabski (Libia)',
        'ar-MA' => 'arabski (Maroko)',
        'ar-MR' => 'arabski (Mauretania)',
        'ar-OM' => 'arabski (Oman)',
        'ar-PS' => 'arabski (Terytoria Palestyńskie)',
        'ar-QA' => 'arabski (Katar)',
        'ar-SA' => 'arabski (Arabia Saudyjska)',
        'ar-SD' => 'arabski (Sudan)',
        'ar-SO' => 'arabski (Somalia)',
        'ar-SS' => 'arabski (Sudan Południowy)',
        'ar-SY' => 'arabski (Syria)',
        'ar-TD' => 'arabski (Czad)',
        'ar-TN' => 'arabski (Tunezja)',
        'ar-YE' => 'arabski (Jemen)',
        'as' => 'asamski',
        'as-IN' => 'asamski (Indie)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturyjski',
        'ast-ES' => 'asturyjski (Hiszpania)',
        'az' => 'azerski',
        'az-Cyrl' => 'azerski (cyrylica)',
        'az-Cyrl-AZ' => 'azerski (cyrylica, Azerbejdżan)',
        'az-Latn' => 'azerski (łacińskie)',
        'az-Latn-AZ' => 'azerski (łacińskie, Azerbejdżan)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Kamerun)',
        'be' => 'białoruski',
        'be-BY' => 'białoruski (Białoruś)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'bułgarski',
        'bg-BG' => 'bułgarski (Bułgaria)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengalski',
        'bn-BD' => 'bengalski (Bangladesz)',
        'bn-IN' => 'bengalski (Indie)',
        'bo' => 'tybetański',
        'bo-CN' => 'tybetański (Chiny)',
        'bo-IN' => 'tybetański (Indie)',
        'br' => 'bretoński',
        'br-FR' => 'bretoński (Francja)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (Indie)',
        'bs' => 'bośniacki',
        'bs-Cyrl' => 'bośniacki (cyrylica)',
        'bs-Cyrl-BA' => 'bośniacki (cyrylica, Bośnia i Hercegowina)',
        'bs-Latn' => 'bośniacki (łacińskie)',
        'bs-Latn-BA' => 'bośniacki (łacińskie, Bośnia i Hercegowina)',
        'ca' => 'kataloński',
        'ca-AD' => 'kataloński (Andora)',
        'ca-ES' => 'kataloński (Hiszpania)',
        'ca-FR' => 'kataloński (Francja)',
        'ca-IT' => 'kataloński (Włochy)',
        'ce' => 'czeczeński',
        'ce-RU' => 'czeczeński (Rosja)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'czirokeski',
        'chr-US' => 'czirokeski (Stany Zjednoczone)',
        'cs' => 'czeski',
        'cs-CZ' => 'czeski (Czechy)',
        'cy' => 'walijski',
        'cy-GB' => 'walijski (Wielka Brytania)',
        'da' => 'duński',
        'da-DK' => 'duński (Dania)',
        'da-GL' => 'duński (Grenlandia)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenia)',
        'de' => 'niemiecki',
        'de-AT' => 'niemiecki (Austria)',
        'de-BE' => 'niemiecki (Belgia)',
        'de-CH' => 'niemiecki (Szwajcaria)',
        'de-DE' => 'niemiecki (Niemcy)',
        'de-LI' => 'niemiecki (Liechtenstein)',
        'de-LU' => 'niemiecki (Luksemburg)',
        'dje' => 'dżerma',
        'dje-NE' => 'dżerma (Niger)',
        'dsb' => 'dolnołużycki',
        'dsb-DE' => 'dolnołużycki (Niemcy)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'diola',
        'dyo-SN' => 'diola (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhutan)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Kenia)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'grecki',
        'el-CY' => 'grecki (Cypr)',
        'el-GR' => 'grecki (Grecja)',
        'en' => 'angielski',
        'en-001' => 'angielski (świat)',
        'en-150' => 'angielski (Europa)',
        'en-AG' => 'angielski (Antigua i Barbuda)',
        'en-AI' => 'angielski (Anguilla)',
        'en-AS' => 'angielski (Samoa Amerykańskie)',
        'en-AT' => 'angielski (Austria)',
        'en-AU' => 'angielski (Australia)',
        'en-BB' => 'angielski (Barbados)',
        'en-BE' => 'angielski (Belgia)',
        'en-BI' => 'angielski (Burundi)',
        'en-BM' => 'angielski (Bermudy)',
        'en-BS' => 'angielski (Bahamy)',
        'en-BW' => 'angielski (Botswana)',
        'en-BZ' => 'angielski (Belize)',
        'en-CA' => 'angielski (Kanada)',
        'en-CC' => 'angielski (Wyspy Kokosowe)',
        'en-CH' => 'angielski (Szwajcaria)',
        'en-CK' => 'angielski (Wyspy Cooka)',
        'en-CM' => 'angielski (Kamerun)',
        'en-CX' => 'angielski (Wyspa Bożego Narodzenia)',
        'en-CY' => 'angielski (Cypr)',
        'en-DE' => 'angielski (Niemcy)',
        'en-DG' => 'angielski (Diego Garcia)',
        'en-DK' => 'angielski (Dania)',
        'en-DM' => 'angielski (Dominika)',
        'en-ER' => 'angielski (Erytrea)',
        'en-FI' => 'angielski (Finlandia)',
        'en-FJ' => 'angielski (Fidżi)',
        'en-FK' => 'angielski (Falklandy)',
        'en-FM' => 'angielski (Mikronezja)',
        'en-GB' => 'angielski (Wielka Brytania)',
        'en-GD' => 'angielski (Grenada)',
        'en-GG' => 'angielski (Guernsey)',
        'en-GH' => 'angielski (Ghana)',
        'en-GI' => 'angielski (Gibraltar)',
        'en-GM' => 'angielski (Gambia)',
        'en-GU' => 'angielski (Guam)',
        'en-GY' => 'angielski (Gujana)',
        'en-HK' => 'angielski (SRA Hongkong [Chiny])',
        'en-IE' => 'angielski (Irlandia)',
        'en-IL' => 'angielski (Izrael)',
        'en-IM' => 'angielski (Wyspa Man)',
        'en-IN' => 'angielski (Indie)',
        'en-IO' => 'angielski (Brytyjskie Terytorium Oceanu Indyjskiego)',
        'en-JE' => 'angielski (Jersey)',
        'en-JM' => 'angielski (Jamajka)',
        'en-KE' => 'angielski (Kenia)',
        'en-KI' => 'angielski (Kiribati)',
        'en-KN' => 'angielski (Saint Kitts i Nevis)',
        'en-KY' => 'angielski (Kajmany)',
        'en-LC' => 'angielski (Saint Lucia)',
        'en-LR' => 'angielski (Liberia)',
        'en-LS' => 'angielski (Lesotho)',
        'en-MG' => 'angielski (Madagaskar)',
        'en-MH' => 'angielski (Wyspy Marshalla)',
        'en-MO' => 'angielski (SRA Makau [Chiny])',
        'en-MP' => 'angielski (Mariany Północne)',
        'en-MS' => 'angielski (Montserrat)',
        'en-MT' => 'angielski (Malta)',
        'en-MU' => 'angielski (Mauritius)',
        'en-MW' => 'angielski (Malawi)',
        'en-MY' => 'angielski (Malezja)',
        'en-NA' => 'angielski (Namibia)',
        'en-NF' => 'angielski (Norfolk)',
        'en-NG' => 'angielski (Nigeria)',
        'en-NL' => 'angielski (Holandia)',
        'en-NR' => 'angielski (Nauru)',
        'en-NU' => 'angielski (Niue)',
        'en-NZ' => 'angielski (Nowa Zelandia)',
        'en-PG' => 'angielski (Papua-Nowa Gwinea)',
        'en-PH' => 'angielski (Filipiny)',
        'en-PK' => 'angielski (Pakistan)',
        'en-PN' => 'angielski (Pitcairn)',
        'en-PR' => 'angielski (Portoryko)',
        'en-PW' => 'angielski (Palau)',
        'en-RW' => 'angielski (Rwanda)',
        'en-SB' => 'angielski (Wyspy Salomona)',
        'en-SC' => 'angielski (Seszele)',
        'en-SD' => 'angielski (Sudan)',
        'en-SE' => 'angielski (Szwecja)',
        'en-SG' => 'angielski (Singapur)',
        'en-SH' => 'angielski (Wyspa Świętej Heleny)',
        'en-SI' => 'angielski (Słowenia)',
        'en-SL' => 'angielski (Sierra Leone)',
        'en-SS' => 'angielski (Sudan Południowy)',
        'en-SX' => 'angielski (Sint Maarten)',
        'en-SZ' => 'angielski (Suazi)',
        'en-TC' => 'angielski (Turks i Caicos)',
        'en-TK' => 'angielski (Tokelau)',
        'en-TO' => 'angielski (Tonga)',
        'en-TT' => 'angielski (Trynidad i Tobago)',
        'en-TV' => 'angielski (Tuvalu)',
        'en-TZ' => 'angielski (Tanzania)',
        'en-UG' => 'angielski (Uganda)',
        'en-UM' => 'angielski (Dalekie Wyspy Mniejsze Stanów Zjednoczonych)',
        'en-US' => 'angielski (Stany Zjednoczone)',
        'en-US-POSIX' => 'angielski (Stany Zjednoczone, komputerowy)',
        'en-VC' => 'angielski (Saint Vincent i Grenadyny)',
        'en-VG' => 'angielski (Brytyjskie Wyspy Dziewicze)',
        'en-VI' => 'angielski (Wyspy Dziewicze Stanów Zjednoczonych)',
        'en-VU' => 'angielski (Vanuatu)',
        'en-WS' => 'angielski (Samoa)',
        'en-ZA' => 'angielski (Republika Południowej Afryki)',
        'en-ZM' => 'angielski (Zambia)',
        'en-ZW' => 'angielski (Zimbabwe)',
        'eo' => 'esperanto',
        'es' => 'hiszpański',
        'es-419' => 'hiszpański (Ameryka Łacińska)',
        'es-AR' => 'hiszpański (Argentyna)',
        'es-BO' => 'hiszpański (Boliwia)',
        'es-CL' => 'hiszpański (Chile)',
        'es-CO' => 'hiszpański (Kolumbia)',
        'es-CR' => 'hiszpański (Kostaryka)',
        'es-CU' => 'hiszpański (Kuba)',
        'es-DO' => 'hiszpański (Dominikana)',
        'es-EA' => 'hiszpański (Ceuta i Melilla)',
        'es-EC' => 'hiszpański (Ekwador)',
        'es-ES' => 'hiszpański (Hiszpania)',
        'es-GQ' => 'hiszpański (Gwinea Równikowa)',
        'es-GT' => 'hiszpański (Gwatemala)',
        'es-HN' => 'hiszpański (Honduras)',
        'es-IC' => 'hiszpański (Wyspy Kanaryjskie)',
        'es-MX' => 'hiszpański (Meksyk)',
        'es-NI' => 'hiszpański (Nikaragua)',
        'es-PA' => 'hiszpański (Panama)',
        'es-PE' => 'hiszpański (Peru)',
        'es-PH' => 'hiszpański (Filipiny)',
        'es-PR' => 'hiszpański (Portoryko)',
        'es-PY' => 'hiszpański (Paragwaj)',
        'es-SV' => 'hiszpański (Salwador)',
        'es-US' => 'hiszpański (Stany Zjednoczone)',
        'es-UY' => 'hiszpański (Urugwaj)',
        'es-VE' => 'hiszpański (Wenezuela)',
        'et' => 'estoński',
        'et-EE' => 'estoński (Estonia)',
        'eu' => 'baskijski',
        'eu-ES' => 'baskijski (Hiszpania)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'perski',
        'fa-AF' => 'perski (Afganistan)',
        'fa-IR' => 'perski (Iran)',
        'ff' => 'fulani',
        'ff-CM' => 'fulani (Kamerun)',
        'ff-GN' => 'fulani (Gwinea)',
        'ff-MR' => 'fulani (Mauretania)',
        'ff-SN' => 'fulani (Senegal)',
        'fi' => 'fiński',
        'fi-FI' => 'fiński (Finlandia)',
        'fil' => 'filipino',
        'fil-PH' => 'filipino (Filipiny)',
        'fo' => 'farerski',
        'fo-DK' => 'farerski (Dania)',
        'fo-FO' => 'farerski (Wyspy Owcze)',
        'fr' => 'francuski',
        'fr-BE' => 'francuski (Belgia)',
        'fr-BF' => 'francuski (Burkina Faso)',
        'fr-BI' => 'francuski (Burundi)',
        'fr-BJ' => 'francuski (Benin)',
        'fr-BL' => 'francuski (Saint-Barthélemy)',
        'fr-CA' => 'francuski (Kanada)',
        'fr-CD' => 'francuski (Demokratyczna Republika Konga)',
        'fr-CF' => 'francuski (Republika Środkowoafrykańska)',
        'fr-CG' => 'francuski (Kongo)',
        'fr-CH' => 'francuski (Szwajcaria)',
        'fr-CI' => 'francuski (Côte d’Ivoire)',
        'fr-CM' => 'francuski (Kamerun)',
        'fr-DJ' => 'francuski (Dżibuti)',
        'fr-DZ' => 'francuski (Algieria)',
        'fr-FR' => 'francuski (Francja)',
        'fr-GA' => 'francuski (Gabon)',
        'fr-GF' => 'francuski (Gujana Francuska)',
        'fr-GN' => 'francuski (Gwinea)',
        'fr-GP' => 'francuski (Gwadelupa)',
        'fr-GQ' => 'francuski (Gwinea Równikowa)',
        'fr-HT' => 'francuski (Haiti)',
        'fr-KM' => 'francuski (Komory)',
        'fr-LU' => 'francuski (Luksemburg)',
        'fr-MA' => 'francuski (Maroko)',
        'fr-MC' => 'francuski (Monako)',
        'fr-MF' => 'francuski (Saint-Martin)',
        'fr-MG' => 'francuski (Madagaskar)',
        'fr-ML' => 'francuski (Mali)',
        'fr-MQ' => 'francuski (Martynika)',
        'fr-MR' => 'francuski (Mauretania)',
        'fr-MU' => 'francuski (Mauritius)',
        'fr-NC' => 'francuski (Nowa Kaledonia)',
        'fr-NE' => 'francuski (Niger)',
        'fr-PF' => 'francuski (Polinezja Francuska)',
        'fr-PM' => 'francuski (Saint-Pierre i Miquelon)',
        'fr-RE' => 'francuski (Reunion)',
        'fr-RW' => 'francuski (Rwanda)',
        'fr-SC' => 'francuski (Seszele)',
        'fr-SN' => 'francuski (Senegal)',
        'fr-SY' => 'francuski (Syria)',
        'fr-TD' => 'francuski (Czad)',
        'fr-TG' => 'francuski (Togo)',
        'fr-TN' => 'francuski (Tunezja)',
        'fr-VU' => 'francuski (Vanuatu)',
        'fr-WF' => 'francuski (Wallis i Futuna)',
        'fr-YT' => 'francuski (Majotta)',
        'fur' => 'friulijski',
        'fur-IT' => 'friulijski (Włochy)',
        'fy' => 'zachodniofryzyjski',
        'fy-NL' => 'zachodniofryzyjski (Holandia)',
        'ga' => 'irlandzki',
        'ga-IE' => 'irlandzki (Irlandia)',
        'gd' => 'szkocki gaelicki',
        'gd-GB' => 'szkocki gaelicki (Wielka Brytania)',
        'gl' => 'galicyjski',
        'gl-ES' => 'galicyjski (Hiszpania)',
        'gsw' => 'szwajcarski niemiecki',
        'gsw-CH' => 'szwajcarski niemiecki (Szwajcaria)',
        'gsw-FR' => 'szwajcarski niemiecki (Francja)',
        'gsw-LI' => 'szwajcarski niemiecki (Liechtenstein)',
        'gu' => 'gudźaracki',
        'gu-IN' => 'gudźaracki (Indie)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenia)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Wyspa Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawajski',
        'haw-US' => 'hawajski (Stany Zjednoczone)',
        'he' => 'hebrajski',
        'he-IL' => 'hebrajski (Izrael)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (Indie)',
        'hr' => 'chorwacki',
        'hr-BA' => 'chorwacki (Bośnia i Hercegowina)',
        'hr-HR' => 'chorwacki (Chorwacja)',
        'hsb' => 'górnołużycki',
        'hsb-DE' => 'górnołużycki (Niemcy)',
        'hu' => 'węgierski',
        'hu-HU' => 'węgierski (Węgry)',
        'hy' => 'ormiański',
        'hy-AM' => 'ormiański (Armenia)',
        'id' => 'indonezyjski',
        'id-ID' => 'indonezyjski (Indonezja)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigeria)',
        'ii' => 'syczuański',
        'ii-CN' => 'syczuański (Chiny)',
        'is' => 'islandzki',
        'is-IS' => 'islandzki (Islandia)',
        'it' => 'włoski',
        'it-CH' => 'włoski (Szwajcaria)',
        'it-IT' => 'włoski (Włochy)',
        'it-SM' => 'włoski (San Marino)',
        'ja' => 'japoński',
        'ja-JP' => 'japoński (Japonia)',
        'jgo' => 'ngombe',
        'jgo-CM' => 'ngombe (Kamerun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzania)',
        'ka' => 'gruziński',
        'ka-GE' => 'gruziński (Gruzja)',
        'kab' => 'kabylski',
        'kab-DZ' => 'kabylski (Algieria)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenia)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'kreolski Wysp Zielonego Przylądka',
        'kea-CV' => 'kreolski Wysp Zielonego Przylądka (Republika Zielonego Przylądka)',
        'khq' => 'koyra chini',
        'khq-ML' => 'koyra chini (Mali)',
        'ki' => 'kikuju',
        'ki-KE' => 'kikuju (Kenia)',
        'kk' => 'kazachski',
        'kk-KZ' => 'kazachski (Kazachstan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Kamerun)',
        'kl' => 'grenlandzki',
        'kl-GL' => 'grenlandzki (Grenlandia)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenia)',
        'km' => 'khmerski',
        'km-KH' => 'khmerski (Kambodża)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (Indie)',
        'ko' => 'koreański',
        'ko-KP' => 'koreański (Korea Północna)',
        'ko-KR' => 'koreański (Korea Południowa)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (Indie)',
        'ks' => 'kaszmirski',
        'ks-IN' => 'kaszmirski (Indie)',
        'ksb' => 'sambala',
        'ksb-TZ' => 'sambala (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'gwara kolońska',
        'ksh-DE' => 'gwara kolońska (Niemcy)',
        'kw' => 'kornijski',
        'kw-GB' => 'kornijski (Wielka Brytania)',
        'ky' => 'kirgiski',
        'ky-KG' => 'kirgiski (Kirgistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'luksemburski',
        'lb-LU' => 'luksemburski (Luksemburg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (Stany Zjednoczone)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Demokratyczna Republika Konga)',
        'ln-CF' => 'lingala (Republika Środkowoafrykańska)',
        'ln-CG' => 'lingala (Kongo)',
        'lo' => 'laotański',
        'lo-LA' => 'laotański (Laos)',
        'lrc' => 'luryjski północny',
        'lrc-IQ' => 'luryjski północny (Irak)',
        'lrc-IR' => 'luryjski północny (Iran)',
        'lt' => 'litewski',
        'lt-LT' => 'litewski (Litwa)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Demokratyczna Republika Konga)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenia)',
        'luy' => 'luhya',
        'luy-KE' => 'luhya (Kenia)',
        'lv' => 'łotewski',
        'lv-LV' => 'łotewski (Łotwa)',
        'mas' => 'masajski',
        'mas-KE' => 'masajski (Kenia)',
        'mas-TZ' => 'masajski (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenia)',
        'mfe' => 'kreolski Mauritiusa',
        'mfe-MU' => 'kreolski Mauritiusa (Mauritius)',
        'mg' => 'malgaski',
        'mg-MG' => 'malgaski (Madagaskar)',
        'mgh' => 'makua',
        'mgh-MZ' => 'makua (Mozambik)',
        'mgo' => 'meta',
        'mgo-CM' => 'meta (Kamerun)',
        'mk' => 'macedoński',
        'mk-MK' => 'macedoński (Macedonia)',
        'ml' => 'malajalam',
        'ml-IN' => 'malajalam (Indie)',
        'mn' => 'mongolski',
        'mn-MN' => 'mongolski (Mongolia)',
        'mr' => 'marathi',
        'mr-IN' => 'marathi (Indie)',
        'ms' => 'malajski',
        'ms-BN' => 'malajski (Brunei Darussalam)',
        'ms-MY' => 'malajski (Malezja)',
        'ms-SG' => 'malajski (Singapur)',
        'mt' => 'maltański',
        'mt-MT' => 'maltański (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'birmański',
        'my-MM' => 'birmański (Mjanma [Birma])',
        'mzn' => 'mazanderański',
        'mzn-IR' => 'mazanderański (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'norweski (bokmål)',
        'nb-NO' => 'norweski (bokmål) (Norwegia)',
        'nb-SJ' => 'norweski (bokmål) (Svalbard i Jan Mayen)',
        'nd' => 'ndebele północny',
        'nd-ZW' => 'ndebele północny (Zimbabwe)',
        'ne' => 'nepalski',
        'ne-IN' => 'nepalski (Indie)',
        'ne-NP' => 'nepalski (Nepal)',
        'nl' => 'niderlandzki',
        'nl-AW' => 'niderlandzki (Aruba)',
        'nl-BE' => 'niderlandzki (Belgia)',
        'nl-BQ' => 'niderlandzki (Niderlandy Karaibskie)',
        'nl-CW' => 'niderlandzki (Curaçao)',
        'nl-NL' => 'niderlandzki (Holandia)',
        'nl-SR' => 'niderlandzki (Surinam)',
        'nl-SX' => 'niderlandzki (Sint Maarten)',
        'nmg' => 'ngumba',
        'nmg-CM' => 'ngumba (Kamerun)',
        'nn' => 'norweski (nynorsk)',
        'nn-NO' => 'norweski (nynorsk) (Norwegia)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sudan Południowy)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromski',
        'om-ET' => 'oromski (Etiopia)',
        'om-KE' => 'oromski (Kenia)',
        'or' => 'orija',
        'or-IN' => 'orija (Indie)',
        'os' => 'osetyjski',
        'os-GE' => 'osetyjski (Gruzja)',
        'os-RU' => 'osetyjski (Rosja)',
        'pa' => 'pendżabski',
        'pa-Arab' => 'pendżabski (arabskie)',
        'pa-Arab-PK' => 'pendżabski (arabskie, Pakistan)',
        'pa-Guru' => 'pendżabski (gurmukhi)',
        'pa-Guru-IN' => 'pendżabski (gurmukhi, Indie)',
        'pl' => 'polski',
        'pl-PL' => 'polski (Polska)',
        'ps' => 'paszto',
        'ps-AF' => 'paszto (Afganistan)',
        'pt' => 'portugalski',
        'pt-AO' => 'portugalski (Angola)',
        'pt-BR' => 'portugalski (Brazylia)',
        'pt-CV' => 'portugalski (Republika Zielonego Przylądka)',
        'pt-GW' => 'portugalski (Gwinea Bissau)',
        'pt-MO' => 'portugalski (SRA Makau [Chiny])',
        'pt-MZ' => 'portugalski (Mozambik)',
        'pt-PT' => 'portugalski (Portugalia)',
        'pt-ST' => 'portugalski (Wyspy Świętego Tomasza i Książęca)',
        'pt-TL' => 'portugalski (Timor Wschodni)',
        'qu' => 'keczua',
        'qu-BO' => 'keczua (Boliwia)',
        'qu-EC' => 'keczua (Ekwador)',
        'qu-PE' => 'keczua (Peru)',
        'rm' => 'retoromański',
        'rm-CH' => 'retoromański (Szwajcaria)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumuński',
        'ro-MD' => 'rumuński (Mołdawia)',
        'ro-RO' => 'rumuński (Rumunia)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'rosyjski',
        'ru-BY' => 'rosyjski (Białoruś)',
        'ru-KG' => 'rosyjski (Kirgistan)',
        'ru-KZ' => 'rosyjski (Kazachstan)',
        'ru-MD' => 'rosyjski (Mołdawia)',
        'ru-RU' => 'rosyjski (Rosja)',
        'ru-UA' => 'rosyjski (Ukraina)',
        'rw' => 'kinya-ruanda',
        'rw-RW' => 'kinya-ruanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'jakucki',
        'sah-RU' => 'jakucki (Rosja)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenia)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'lapoński północny',
        'se-FI' => 'lapoński północny (Finlandia)',
        'se-NO' => 'lapoński północny (Norwegia)',
        'se-SE' => 'lapoński północny (Szwecja)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambik)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Republika Środkowoafrykańska)',
        'shi' => 'tashelhiyt',
        'shi-Latn' => 'tashelhiyt (łacińskie)',
        'shi-Latn-MA' => 'tashelhiyt (łacińskie, Maroko)',
        'shi-Tfng' => 'tashelhiyt (tifinagh [berberski])',
        'shi-Tfng-MA' => 'tashelhiyt (tifinagh [berberski], Maroko)',
        'si' => 'syngaleski',
        'si-LK' => 'syngaleski (Sri Lanka)',
        'sk' => 'słowacki',
        'sk-SK' => 'słowacki (Słowacja)',
        'sl' => 'słoweński',
        'sl-SI' => 'słoweński (Słowenia)',
        'smn' => 'lapoński Inari',
        'smn-FI' => 'lapoński Inari (Finlandia)',
        'sn' => 'szona',
        'sn-ZW' => 'szona (Zimbabwe)',
        'so' => 'somalijski',
        'so-DJ' => 'somalijski (Dżibuti)',
        'so-ET' => 'somalijski (Etiopia)',
        'so-KE' => 'somalijski (Kenia)',
        'so-SO' => 'somalijski (Somalia)',
        'sq' => 'albański',
        'sq-AL' => 'albański (Albania)',
        'sq-MK' => 'albański (Macedonia)',
        'sq-XK' => 'albański (Kosowo)',
        'sr' => 'serbski',
        'sr-Cyrl' => 'serbski (cyrylica)',
        'sr-Cyrl-BA' => 'serbski (cyrylica, Bośnia i Hercegowina)',
        'sr-Cyrl-ME' => 'serbski (cyrylica, Czarnogóra)',
        'sr-Cyrl-RS' => 'serbski (cyrylica, Serbia)',
        'sr-Cyrl-XK' => 'serbski (cyrylica, Kosowo)',
        'sr-Latn' => 'serbski (łacińskie)',
        'sr-Latn-BA' => 'serbski (łacińskie, Bośnia i Hercegowina)',
        'sr-Latn-ME' => 'serbski (łacińskie, Czarnogóra)',
        'sr-Latn-RS' => 'serbski (łacińskie, Serbia)',
        'sr-Latn-XK' => 'serbski (łacińskie, Kosowo)',
        'sv' => 'szwedzki',
        'sv-AX' => 'szwedzki (Wyspy Alandzkie)',
        'sv-FI' => 'szwedzki (Finlandia)',
        'sv-SE' => 'szwedzki (Szwecja)',
        'sw' => 'suahili',
        'sw-CD' => 'suahili (Demokratyczna Republika Konga)',
        'sw-KE' => 'suahili (Kenia)',
        'sw-TZ' => 'suahili (Tanzania)',
        'sw-UG' => 'suahili (Uganda)',
        'ta' => 'tamilski',
        'ta-IN' => 'tamilski (Indie)',
        'ta-LK' => 'tamilski (Sri Lanka)',
        'ta-MY' => 'tamilski (Malezja)',
        'ta-SG' => 'tamilski (Singapur)',
        'te' => 'telugu',
        'te-IN' => 'telugu (Indie)',
        'teo' => 'ateso',
        'teo-KE' => 'ateso (Kenia)',
        'teo-UG' => 'ateso (Uganda)',
        'th' => 'tajski',
        'th-TH' => 'tajski (Tajlandia)',
        'ti' => 'tigrinia',
        'ti-ER' => 'tigrinia (Erytrea)',
        'ti-ET' => 'tigrinia (Etiopia)',
        'to' => 'tonga',
        'to-TO' => 'tonga (Tonga)',
        'tr' => 'turecki',
        'tr-CY' => 'turecki (Cypr)',
        'tr-TR' => 'turecki (Turcja)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'centralnomarokański tamazight',
        'tzm-MA' => 'centralnomarokański tamazight (Maroko)',
        'ug' => 'ujgurski',
        'ug-CN' => 'ujgurski (Chiny)',
        'uk' => 'ukraiński',
        'uk-UA' => 'ukraiński (Ukraina)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (Indie)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'uzbecki',
        'uz-Arab' => 'uzbecki (arabskie)',
        'uz-Arab-AF' => 'uzbecki (arabskie, Afganistan)',
        'uz-Cyrl' => 'uzbecki (cyrylica)',
        'uz-Cyrl-UZ' => 'uzbecki (cyrylica, Uzbekistan)',
        'uz-Latn' => 'uzbecki (łacińskie)',
        'uz-Latn-UZ' => 'uzbecki (łacińskie, Uzbekistan)',
        'vai' => 'wai',
        'vai-Latn' => 'wai (łacińskie)',
        'vai-Latn-LR' => 'wai (łacińskie, Liberia)',
        'vai-Vaii' => 'wai (vai)',
        'vai-Vaii-LR' => 'wai (vai, Liberia)',
        'vi' => 'wietnamski',
        'vi-VN' => 'wietnamski (Wietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Szwajcaria)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Kamerun)',
        'yi' => 'jidysz',
        'yi-001' => 'jidysz (świat)',
        'yo' => 'joruba',
        'yo-BJ' => 'joruba (Benin)',
        'yo-NG' => 'joruba (Nigeria)',
        'yue' => 'kantoński',
        'yue-HK' => 'kantoński (SRA Hongkong [Chiny])',
        'zgh' => 'standardowy marokański tamazight',
        'zgh-MA' => 'standardowy marokański tamazight (Maroko)',
        'zh' => 'chiński',
        'zh-Hans' => 'chiński (uproszczone)',
        'zh-Hans-CN' => 'chiński (uproszczone, Chiny)',
        'zh-Hans-HK' => 'chiński (uproszczone, SRA Hongkong [Chiny])',
        'zh-Hans-MO' => 'chiński (uproszczone, SRA Makau [Chiny])',
        'zh-Hans-SG' => 'chiński (uproszczone, Singapur)',
        'zh-Hant' => 'chiński (tradycyjne)',
        'zh-Hant-HK' => 'chiński (tradycyjne, SRA Hongkong [Chiny])',
        'zh-Hant-MO' => 'chiński (tradycyjne, SRA Makau [Chiny])',
        'zh-Hant-TW' => 'chiński (tradycyjne, Tajwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Republika Południowej Afryki)',
    ],
];
