<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y-M-d',
            'time' => 'HH:mm',
            'datetime' => 'y-M-d HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d MMMM y',
            'time' => '\'kl\'. HH:mm:ss zzzz',
            'datetime' => 'EEEE d MMMM y \'kl\'. HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'fm',
    'pmName' => 'em',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '−',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '−',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => '×10^',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => '¤¤¤',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD',
        'BRL' => 'BR$',
        'CAD' => 'CA$',
        'CNY' => 'CNY',
        'EUR' => '€',
        'GBP' => 'GBP',
        'HKD' => 'HKD',
        'ILS' => '₪',
        'INR' => 'INR',
        'JPY' => 'JPY',
        'KRW' => 'KRW',
        'MXN' => 'MX$',
        'NZD' => 'NZD',
        'THB' => 'THB',
        'TWD' => 'TWD',
        'USD' => 'US$',
        'VND' => 'VND',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'maj',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'januari',
            'februari',
            'mars',
            'april',
            'maj',
            'juni',
            'juli',
            'augusti',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'maj',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'januari',
            'februari',
            'mars',
            'april',
            'maj',
            'juni',
            'juli',
            'augusti',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sö',
            'må',
            'ti',
            'on',
            'to',
            'fr',
            'lö',
        ],
        'medium' => [
            'sön',
            'mån',
            'tis',
            'ons',
            'tors',
            'fre',
            'lör',
        ],
        'full' => [
            'söndag',
            'måndag',
            'tisdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lördag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sö',
            'må',
            'ti',
            'on',
            'to',
            'fr',
            'lö',
        ],
        'medium' => [
            'sön',
            'mån',
            'tis',
            'ons',
            'tors',
            'fre',
            'lör',
        ],
        'full' => [
            'söndag',
            'måndag',
            'tisdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lördag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Sydafrika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amhariska',
        'am-ET' => 'amhariska (Etiopien)',
        'ar' => 'arabiska',
        'ar-001' => 'arabiska (världen)',
        'ar-AE' => 'arabiska (Förenade Arabemiraten)',
        'ar-BH' => 'arabiska (Bahrain)',
        'ar-DJ' => 'arabiska (Djibouti)',
        'ar-DZ' => 'arabiska (Algeriet)',
        'ar-EG' => 'arabiska (Egypten)',
        'ar-EH' => 'arabiska (Västsahara)',
        'ar-ER' => 'arabiska (Eritrea)',
        'ar-IL' => 'arabiska (Israel)',
        'ar-IQ' => 'arabiska (Irak)',
        'ar-JO' => 'arabiska (Jordanien)',
        'ar-KM' => 'arabiska (Komorerna)',
        'ar-KW' => 'arabiska (Kuwait)',
        'ar-LB' => 'arabiska (Libanon)',
        'ar-LY' => 'arabiska (Libyen)',
        'ar-MA' => 'arabiska (Marocko)',
        'ar-MR' => 'arabiska (Mauretanien)',
        'ar-OM' => 'arabiska (Oman)',
        'ar-PS' => 'arabiska (Palestinska territorierna)',
        'ar-QA' => 'arabiska (Qatar)',
        'ar-SA' => 'arabiska (Saudiarabien)',
        'ar-SD' => 'arabiska (Sudan)',
        'ar-SO' => 'arabiska (Somalia)',
        'ar-SS' => 'arabiska (Sydsudan)',
        'ar-SY' => 'arabiska (Syrien)',
        'ar-TD' => 'arabiska (Tchad)',
        'ar-TN' => 'arabiska (Tunisien)',
        'ar-YE' => 'arabiska (Jemen)',
        'as' => 'assamesiska',
        'as-IN' => 'assamesiska (Indien)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturiska',
        'ast-ES' => 'asturiska (Spanien)',
        'az' => 'azerbajdzjanska',
        'az-Cyrl' => 'azerbajdzjanska (kyrilliska)',
        'az-Cyrl-AZ' => 'azerbajdzjanska (kyrilliska, Azerbajdzjan)',
        'az-Latn' => 'azerbajdzjanska (latinska)',
        'az-Latn-AZ' => 'azerbajdzjanska (latinska, Azerbajdzjan)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Kamerun)',
        'be' => 'vitryska',
        'be-BY' => 'vitryska (Vitryssland)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'bulgariska',
        'bg-BG' => 'bulgariska (Bulgarien)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (Indien)',
        'bo' => 'tibetanska',
        'bo-CN' => 'tibetanska (Kina)',
        'bo-IN' => 'tibetanska (Indien)',
        'br' => 'bretonska',
        'br-FR' => 'bretonska (Frankrike)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (Indien)',
        'bs' => 'bosniska',
        'bs-Cyrl' => 'bosniska (kyrilliska)',
        'bs-Cyrl-BA' => 'bosniska (kyrilliska, Bosnien och Hercegovina)',
        'bs-Latn' => 'bosniska (latinska)',
        'bs-Latn-BA' => 'bosniska (latinska, Bosnien och Hercegovina)',
        'ca' => 'katalanska',
        'ca-AD' => 'katalanska (Andorra)',
        'ca-ES' => 'katalanska (Spanien)',
        'ca-FR' => 'katalanska (Frankrike)',
        'ca-IT' => 'katalanska (Italien)',
        'ce' => 'tjetjenska',
        'ce-RU' => 'tjetjenska (Ryssland)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'cherokesiska',
        'chr-US' => 'cherokesiska (USA)',
        'cs' => 'tjeckiska',
        'cs-CZ' => 'tjeckiska (Tjeckien)',
        'cy' => 'walesiska',
        'cy-GB' => 'walesiska (Storbritannien)',
        'da' => 'danska',
        'da-DK' => 'danska (Danmark)',
        'da-GL' => 'danska (Grönland)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'tyska',
        'de-AT' => 'tyska (Österrike)',
        'de-BE' => 'tyska (Belgien)',
        'de-CH' => 'tyska (Schweiz)',
        'de-DE' => 'tyska (Tyskland)',
        'de-LI' => 'tyska (Liechtenstein)',
        'de-LU' => 'tyska (Luxemburg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'lågsorbiska',
        'dsb-DE' => 'lågsorbiska (Tyskland)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'bhutanesiska',
        'dz-BT' => 'bhutanesiska (Bhutan)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Kenya)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'grekiska',
        'el-CY' => 'grekiska (Cypern)',
        'el-GR' => 'grekiska (Grekland)',
        'en' => 'engelska',
        'en-001' => 'engelska (världen)',
        'en-150' => 'engelska (Europa)',
        'en-AG' => 'engelska (Antigua och Barbuda)',
        'en-AI' => 'engelska (Anguilla)',
        'en-AS' => 'engelska (Amerikanska Samoa)',
        'en-AT' => 'engelska (Österrike)',
        'en-AU' => 'engelska (Australien)',
        'en-BB' => 'engelska (Barbados)',
        'en-BE' => 'engelska (Belgien)',
        'en-BI' => 'engelska (Burundi)',
        'en-BM' => 'engelska (Bermuda)',
        'en-BS' => 'engelska (Bahamas)',
        'en-BW' => 'engelska (Botswana)',
        'en-BZ' => 'engelska (Belize)',
        'en-CA' => 'engelska (Kanada)',
        'en-CC' => 'engelska (Kokosöarna)',
        'en-CH' => 'engelska (Schweiz)',
        'en-CK' => 'engelska (Cooköarna)',
        'en-CM' => 'engelska (Kamerun)',
        'en-CX' => 'engelska (Julön)',
        'en-CY' => 'engelska (Cypern)',
        'en-DE' => 'engelska (Tyskland)',
        'en-DG' => 'engelska (Diego Garcia)',
        'en-DK' => 'engelska (Danmark)',
        'en-DM' => 'engelska (Dominica)',
        'en-ER' => 'engelska (Eritrea)',
        'en-FI' => 'engelska (Finland)',
        'en-FJ' => 'engelska (Fiji)',
        'en-FK' => 'engelska (Falklandsöarna)',
        'en-FM' => 'engelska (Mikronesien)',
        'en-GB' => 'engelska (Storbritannien)',
        'en-GD' => 'engelska (Grenada)',
        'en-GG' => 'engelska (Guernsey)',
        'en-GH' => 'engelska (Ghana)',
        'en-GI' => 'engelska (Gibraltar)',
        'en-GM' => 'engelska (Gambia)',
        'en-GU' => 'engelska (Guam)',
        'en-GY' => 'engelska (Guyana)',
        'en-HK' => 'engelska (Hongkong, S.A.R. Kina)',
        'en-IE' => 'engelska (Irland)',
        'en-IL' => 'engelska (Israel)',
        'en-IM' => 'engelska (Isle of Man)',
        'en-IN' => 'engelska (Indien)',
        'en-IO' => 'engelska (Brittiska territoriet i Indiska oceanen)',
        'en-JE' => 'engelska (Jersey)',
        'en-JM' => 'engelska (Jamaica)',
        'en-KE' => 'engelska (Kenya)',
        'en-KI' => 'engelska (Kiribati)',
        'en-KN' => 'engelska (S:t Kitts och Nevis)',
        'en-KY' => 'engelska (Caymanöarna)',
        'en-LC' => 'engelska (S:t Lucia)',
        'en-LR' => 'engelska (Liberia)',
        'en-LS' => 'engelska (Lesotho)',
        'en-MG' => 'engelska (Madagaskar)',
        'en-MH' => 'engelska (Marshallöarna)',
        'en-MO' => 'engelska (Macao, S.A.R. Kina)',
        'en-MP' => 'engelska (Nordmarianerna)',
        'en-MS' => 'engelska (Montserrat)',
        'en-MT' => 'engelska (Malta)',
        'en-MU' => 'engelska (Mauritius)',
        'en-MW' => 'engelska (Malawi)',
        'en-MY' => 'engelska (Malaysia)',
        'en-NA' => 'engelska (Namibia)',
        'en-NF' => 'engelska (Norfolkön)',
        'en-NG' => 'engelska (Nigeria)',
        'en-NL' => 'engelska (Nederländerna)',
        'en-NR' => 'engelska (Nauru)',
        'en-NU' => 'engelska (Niue)',
        'en-NZ' => 'engelska (Nya Zeeland)',
        'en-PG' => 'engelska (Papua Nya Guinea)',
        'en-PH' => 'engelska (Filippinerna)',
        'en-PK' => 'engelska (Pakistan)',
        'en-PN' => 'engelska (Pitcairnöarna)',
        'en-PR' => 'engelska (Puerto Rico)',
        'en-PW' => 'engelska (Palau)',
        'en-RW' => 'engelska (Rwanda)',
        'en-SB' => 'engelska (Salomonöarna)',
        'en-SC' => 'engelska (Seychellerna)',
        'en-SD' => 'engelska (Sudan)',
        'en-SE' => 'engelska (Sverige)',
        'en-SG' => 'engelska (Singapore)',
        'en-SH' => 'engelska (S:t Helena)',
        'en-SI' => 'engelska (Slovenien)',
        'en-SL' => 'engelska (Sierra Leone)',
        'en-SS' => 'engelska (Sydsudan)',
        'en-SX' => 'engelska (Sint Maarten)',
        'en-SZ' => 'engelska (Swaziland)',
        'en-TC' => 'engelska (Turks- och Caicosöarna)',
        'en-TK' => 'engelska (Tokelau)',
        'en-TO' => 'engelska (Tonga)',
        'en-TT' => 'engelska (Trinidad och Tobago)',
        'en-TV' => 'engelska (Tuvalu)',
        'en-TZ' => 'engelska (Tanzania)',
        'en-UG' => 'engelska (Uganda)',
        'en-UM' => 'engelska (USA:s yttre öar)',
        'en-US' => 'engelska (USA)',
        'en-US-POSIX' => 'engelska (USA, Posix)',
        'en-VC' => 'engelska (S:t Vincent och Grenadinerna)',
        'en-VG' => 'engelska (Brittiska Jungfruöarna)',
        'en-VI' => 'engelska (Amerikanska Jungfruöarna)',
        'en-VU' => 'engelska (Vanuatu)',
        'en-WS' => 'engelska (Samoa)',
        'en-ZA' => 'engelska (Sydafrika)',
        'en-ZM' => 'engelska (Zambia)',
        'en-ZW' => 'engelska (Zimbabwe)',
        'eo' => 'esperanto',
        'es' => 'spanska',
        'es-419' => 'spanska (Latinamerika)',
        'es-AR' => 'spanska (Argentina)',
        'es-BO' => 'spanska (Bolivia)',
        'es-CL' => 'spanska (Chile)',
        'es-CO' => 'spanska (Colombia)',
        'es-CR' => 'spanska (Costa Rica)',
        'es-CU' => 'spanska (Kuba)',
        'es-DO' => 'spanska (Dominikanska republiken)',
        'es-EA' => 'spanska (Ceuta och Melilla)',
        'es-EC' => 'spanska (Ecuador)',
        'es-ES' => 'spanska (Spanien)',
        'es-GQ' => 'spanska (Ekvatorialguinea)',
        'es-GT' => 'spanska (Guatemala)',
        'es-HN' => 'spanska (Honduras)',
        'es-IC' => 'spanska (Kanarieöarna)',
        'es-MX' => 'spanska (Mexiko)',
        'es-NI' => 'spanska (Nicaragua)',
        'es-PA' => 'spanska (Panama)',
        'es-PE' => 'spanska (Peru)',
        'es-PH' => 'spanska (Filippinerna)',
        'es-PR' => 'spanska (Puerto Rico)',
        'es-PY' => 'spanska (Paraguay)',
        'es-SV' => 'spanska (El Salvador)',
        'es-US' => 'spanska (USA)',
        'es-UY' => 'spanska (Uruguay)',
        'es-VE' => 'spanska (Venezuela)',
        'et' => 'estniska',
        'et-EE' => 'estniska (Estland)',
        'eu' => 'baskiska',
        'eu-ES' => 'baskiska (Spanien)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'persiska',
        'fa-AF' => 'persiska (Afghanistan)',
        'fa-IR' => 'persiska (Iran)',
        'ff' => 'fulani',
        'ff-CM' => 'fulani (Kamerun)',
        'ff-GN' => 'fulani (Guinea)',
        'ff-MR' => 'fulani (Mauretanien)',
        'ff-SN' => 'fulani (Senegal)',
        'fi' => 'finska',
        'fi-FI' => 'finska (Finland)',
        'fil' => 'filippinska',
        'fil-PH' => 'filippinska (Filippinerna)',
        'fo' => 'färöiska',
        'fo-DK' => 'färöiska (Danmark)',
        'fo-FO' => 'färöiska (Färöarna)',
        'fr' => 'franska',
        'fr-BE' => 'franska (Belgien)',
        'fr-BF' => 'franska (Burkina Faso)',
        'fr-BI' => 'franska (Burundi)',
        'fr-BJ' => 'franska (Benin)',
        'fr-BL' => 'franska (S:t Barthélemy)',
        'fr-CA' => 'franska (Kanada)',
        'fr-CD' => 'franska (Kongo-Kinshasa)',
        'fr-CF' => 'franska (Centralafrikanska republiken)',
        'fr-CG' => 'franska (Kongo-Brazzaville)',
        'fr-CH' => 'franska (Schweiz)',
        'fr-CI' => 'franska (Elfenbenskusten)',
        'fr-CM' => 'franska (Kamerun)',
        'fr-DJ' => 'franska (Djibouti)',
        'fr-DZ' => 'franska (Algeriet)',
        'fr-FR' => 'franska (Frankrike)',
        'fr-GA' => 'franska (Gabon)',
        'fr-GF' => 'franska (Franska Guyana)',
        'fr-GN' => 'franska (Guinea)',
        'fr-GP' => 'franska (Guadeloupe)',
        'fr-GQ' => 'franska (Ekvatorialguinea)',
        'fr-HT' => 'franska (Haiti)',
        'fr-KM' => 'franska (Komorerna)',
        'fr-LU' => 'franska (Luxemburg)',
        'fr-MA' => 'franska (Marocko)',
        'fr-MC' => 'franska (Monaco)',
        'fr-MF' => 'franska (S:t Martin)',
        'fr-MG' => 'franska (Madagaskar)',
        'fr-ML' => 'franska (Mali)',
        'fr-MQ' => 'franska (Martinique)',
        'fr-MR' => 'franska (Mauretanien)',
        'fr-MU' => 'franska (Mauritius)',
        'fr-NC' => 'franska (Nya Kaledonien)',
        'fr-NE' => 'franska (Niger)',
        'fr-PF' => 'franska (Franska Polynesien)',
        'fr-PM' => 'franska (S:t Pierre och Miquelon)',
        'fr-RE' => 'franska (Réunion)',
        'fr-RW' => 'franska (Rwanda)',
        'fr-SC' => 'franska (Seychellerna)',
        'fr-SN' => 'franska (Senegal)',
        'fr-SY' => 'franska (Syrien)',
        'fr-TD' => 'franska (Tchad)',
        'fr-TG' => 'franska (Togo)',
        'fr-TN' => 'franska (Tunisien)',
        'fr-VU' => 'franska (Vanuatu)',
        'fr-WF' => 'franska (Wallis- och Futunaöarna)',
        'fr-YT' => 'franska (Mayotte)',
        'fur' => 'friulianska',
        'fur-IT' => 'friulianska (Italien)',
        'fy' => 'västfrisiska',
        'fy-NL' => 'västfrisiska (Nederländerna)',
        'ga' => 'iriska',
        'ga-IE' => 'iriska (Irland)',
        'gd' => 'skotsk gäliska',
        'gd-GB' => 'skotsk gäliska (Storbritannien)',
        'gl' => 'galiciska',
        'gl-ES' => 'galiciska (Spanien)',
        'gsw' => 'schweizertyska',
        'gsw-CH' => 'schweizertyska (Schweiz)',
        'gsw-FR' => 'schweizertyska (Frankrike)',
        'gsw-LI' => 'schweizertyska (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (Indien)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenya)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Isle of Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiiska',
        'haw-US' => 'hawaiiska (USA)',
        'he' => 'hebreiska',
        'he-IL' => 'hebreiska (Israel)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (Indien)',
        'hr' => 'kroatiska',
        'hr-BA' => 'kroatiska (Bosnien och Hercegovina)',
        'hr-HR' => 'kroatiska (Kroatien)',
        'hsb' => 'högsorbiska',
        'hsb-DE' => 'högsorbiska (Tyskland)',
        'hu' => 'ungerska',
        'hu-HU' => 'ungerska (Ungern)',
        'hy' => 'armeniska',
        'hy-AM' => 'armeniska (Armenien)',
        'id' => 'indonesiska',
        'id-ID' => 'indonesiska (Indonesien)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigeria)',
        'ii' => 'szezuan i',
        'ii-CN' => 'szezuan i (Kina)',
        'is' => 'isländska',
        'is-IS' => 'isländska (Island)',
        'it' => 'italienska',
        'it-CH' => 'italienska (Schweiz)',
        'it-IT' => 'italienska (Italien)',
        'it-SM' => 'italienska (San Marino)',
        'ja' => 'japanska',
        'ja-JP' => 'japanska (Japan)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Kamerun)',
        'jmc' => 'kimashami',
        'jmc-TZ' => 'kimashami (Tanzania)',
        'ka' => 'georgiska',
        'ka-GE' => 'georgiska (Georgien)',
        'kab' => 'kabyliska',
        'kab-DZ' => 'kabyliska (Algeriet)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'kapverdiska',
        'kea-CV' => 'kapverdiska (Kap Verde)',
        'khq' => 'Timbuktu-songhoy',
        'khq-ML' => 'Timbuktu-songhoy (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kazakiska',
        'kk-KZ' => 'kazakiska (Kazakstan)',
        'kkj' => 'mkako',
        'kkj-CM' => 'mkako (Kamerun)',
        'kl' => 'grönländska',
        'kl-GL' => 'grönländska (Grönland)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenya)',
        'km' => 'kambodjanska',
        'km-KH' => 'kambodjanska (Kambodja)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (Indien)',
        'ko' => 'koreanska',
        'ko-KP' => 'koreanska (Nordkorea)',
        'ko-KR' => 'koreanska (Sydkorea)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (Indien)',
        'ks' => 'kashmiriska',
        'ks-IN' => 'kashmiriska (Indien)',
        'ksb' => 'kisambaa',
        'ksb-TZ' => 'kisambaa (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'kölniska',
        'ksh-DE' => 'kölniska (Tyskland)',
        'kw' => 'korniska',
        'kw-GB' => 'korniska (Storbritannien)',
        'ky' => 'kirgisiska',
        'ky-KG' => 'kirgisiska (Kirgizistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'luxemburgiska',
        'lb-LU' => 'luxemburgiska (Luxemburg)',
        'lg' => 'luganda',
        'lg-UG' => 'luganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (USA)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Kongo-Kinshasa)',
        'ln-CF' => 'lingala (Centralafrikanska republiken)',
        'ln-CG' => 'lingala (Kongo-Brazzaville)',
        'lo' => 'laotiska',
        'lo-LA' => 'laotiska (Laos)',
        'lrc' => 'nordluri',
        'lrc-IQ' => 'nordluri (Irak)',
        'lrc-IR' => 'nordluri (Iran)',
        'lt' => 'litauiska',
        'lt-LT' => 'litauiska (Litauen)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Kongo-Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'luhya',
        'luy-KE' => 'luhya (Kenya)',
        'lv' => 'lettiska',
        'lv-LV' => 'lettiska (Lettland)',
        'mas' => 'massajiska',
        'mas-KE' => 'massajiska (Kenya)',
        'mas-TZ' => 'massajiska (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenya)',
        'mfe' => 'mauritansk kreol',
        'mfe-MU' => 'mauritansk kreol (Mauritius)',
        'mg' => 'malagassiska',
        'mg-MG' => 'malagassiska (Madagaskar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Moçambique)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Kamerun)',
        'mk' => 'makedonska',
        'mk-MK' => 'makedonska (Makedonien)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (Indien)',
        'mn' => 'mongoliska',
        'mn-MN' => 'mongoliska (Mongoliet)',
        'mr' => 'marathi',
        'mr-IN' => 'marathi (Indien)',
        'ms' => 'malajiska',
        'ms-BN' => 'malajiska (Brunei)',
        'ms-MY' => 'malajiska (Malaysia)',
        'ms-SG' => 'malajiska (Singapore)',
        'mt' => 'maltesiska',
        'mt-MT' => 'maltesiska (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'burmesiska',
        'my-MM' => 'burmesiska (Myanmar [Burma])',
        'mzn' => 'mazanderani',
        'mzn-IR' => 'mazanderani (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'norskt bokmål',
        'nb-NO' => 'norskt bokmål (Norge)',
        'nb-SJ' => 'norskt bokmål (Svalbard och Jan Mayen)',
        'nd' => 'nordndebele',
        'nd-ZW' => 'nordndebele (Zimbabwe)',
        'ne' => 'nepalesiska',
        'ne-IN' => 'nepalesiska (Indien)',
        'ne-NP' => 'nepalesiska (Nepal)',
        'nl' => 'nederländska',
        'nl-AW' => 'nederländska (Aruba)',
        'nl-BE' => 'nederländska (Belgien)',
        'nl-BQ' => 'nederländska (Karibiska Nederländerna)',
        'nl-CW' => 'nederländska (Curaçao)',
        'nl-NL' => 'nederländska (Nederländerna)',
        'nl-SR' => 'nederländska (Surinam)',
        'nl-SX' => 'nederländska (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Kamerun)',
        'nn' => 'nynorska',
        'nn-NO' => 'nynorska (Norge)',
        'nnh' => 'bamileké-ngiemboon',
        'nnh-CM' => 'bamileké-ngiemboon (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sydsudan)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopien)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'oriya',
        'or-IN' => 'oriya (Indien)',
        'os' => 'ossetiska',
        'os-GE' => 'ossetiska (Georgien)',
        'os-RU' => 'ossetiska (Ryssland)',
        'pa' => 'punjabi',
        'pa-Arab' => 'punjabi (arabiska)',
        'pa-Arab-PK' => 'punjabi (arabiska, Pakistan)',
        'pa-Guru' => 'punjabi (gurmukhi)',
        'pa-Guru-IN' => 'punjabi (gurmukhi, Indien)',
        'pl' => 'polska',
        'pl-PL' => 'polska (Polen)',
        'ps' => 'afghanska',
        'ps-AF' => 'afghanska (Afghanistan)',
        'pt' => 'portugisiska',
        'pt-AO' => 'portugisiska (Angola)',
        'pt-BR' => 'portugisiska (Brasilien)',
        'pt-CV' => 'portugisiska (Kap Verde)',
        'pt-GW' => 'portugisiska (Guinea-Bissau)',
        'pt-MO' => 'portugisiska (Macao, S.A.R. Kina)',
        'pt-MZ' => 'portugisiska (Moçambique)',
        'pt-PT' => 'portugisiska (Portugal)',
        'pt-ST' => 'portugisiska (São Tomé och Príncipe)',
        'pt-TL' => 'portugisiska (Östtimor)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Peru)',
        'rm' => 'rätoromanska',
        'rm-CH' => 'rätoromanska (Schweiz)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumänska',
        'ro-MD' => 'rumänska (Moldavien)',
        'ro-RO' => 'rumänska (Rumänien)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'ryska',
        'ru-BY' => 'ryska (Vitryssland)',
        'ru-KG' => 'ryska (Kirgizistan)',
        'ru-KZ' => 'ryska (Kazakstan)',
        'ru-MD' => 'ryska (Moldavien)',
        'ru-RU' => 'ryska (Ryssland)',
        'ru-UA' => 'ryska (Ukraina)',
        'rw' => 'kinjarwanda',
        'rw-RW' => 'kinjarwanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'jakutiska',
        'sah-RU' => 'jakutiska (Ryssland)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'se' => 'nordsamiska',
        'se-FI' => 'nordsamiska (Finland)',
        'se-NO' => 'nordsamiska (Norge)',
        'se-SE' => 'nordsamiska (Sverige)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Moçambique)',
        'ses' => 'Gao-songhay',
        'ses-ML' => 'Gao-songhay (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Centralafrikanska republiken)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (latinska)',
        'shi-Latn-MA' => 'tachelhit (latinska, Marocko)',
        'shi-Tfng' => 'tachelhit (tifinaghiska)',
        'shi-Tfng-MA' => 'tachelhit (tifinaghiska, Marocko)',
        'si' => 'singalesiska',
        'si-LK' => 'singalesiska (Sri Lanka)',
        'sk' => 'slovakiska',
        'sk-SK' => 'slovakiska (Slovakien)',
        'sl' => 'slovenska',
        'sl-SI' => 'slovenska (Slovenien)',
        'smn' => 'enaresamiska',
        'smn-FI' => 'enaresamiska (Finland)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somaliska',
        'so-DJ' => 'somaliska (Djibouti)',
        'so-ET' => 'somaliska (Etiopien)',
        'so-KE' => 'somaliska (Kenya)',
        'so-SO' => 'somaliska (Somalia)',
        'sq' => 'albanska',
        'sq-AL' => 'albanska (Albanien)',
        'sq-MK' => 'albanska (Makedonien)',
        'sq-XK' => 'albanska (Kosovo)',
        'sr' => 'serbiska',
        'sr-Cyrl' => 'serbiska (kyrilliska)',
        'sr-Cyrl-BA' => 'serbiska (kyrilliska, Bosnien och Hercegovina)',
        'sr-Cyrl-ME' => 'serbiska (kyrilliska, Montenegro)',
        'sr-Cyrl-RS' => 'serbiska (kyrilliska, Serbien)',
        'sr-Cyrl-XK' => 'serbiska (kyrilliska, Kosovo)',
        'sr-Latn' => 'serbiska (latinska)',
        'sr-Latn-BA' => 'serbiska (latinska, Bosnien och Hercegovina)',
        'sr-Latn-ME' => 'serbiska (latinska, Montenegro)',
        'sr-Latn-RS' => 'serbiska (latinska, Serbien)',
        'sr-Latn-XK' => 'serbiska (latinska, Kosovo)',
        'sv' => 'svenska',
        'sv-AX' => 'svenska (Åland)',
        'sv-FI' => 'svenska (Finland)',
        'sv-SE' => 'svenska (Sverige)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Kongo-Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzania)',
        'sw-UG' => 'swahili (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (Indien)',
        'ta-LK' => 'tamil (Sri Lanka)',
        'ta-MY' => 'tamil (Malaysia)',
        'ta-SG' => 'tamil (Singapore)',
        'te' => 'telugiska',
        'te-IN' => 'telugiska (Indien)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenya)',
        'teo-UG' => 'teso (Uganda)',
        'th' => 'thailändska',
        'th-TH' => 'thailändska (Thailand)',
        'ti' => 'tigrinja',
        'ti-ER' => 'tigrinja (Eritrea)',
        'ti-ET' => 'tigrinja (Etiopien)',
        'to' => 'tonganska',
        'to-TO' => 'tonganska (Tonga)',
        'tr' => 'turkiska',
        'tr-CY' => 'turkiska (Cypern)',
        'tr-TR' => 'turkiska (Turkiet)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'centralmarockansk tamazight',
        'tzm-MA' => 'centralmarockansk tamazight (Marocko)',
        'ug' => 'uiguriska',
        'ug-CN' => 'uiguriska (Kina)',
        'uk' => 'ukrainska',
        'uk-UA' => 'ukrainska (Ukraina)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (Indien)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'uzbekiska',
        'uz-Arab' => 'uzbekiska (arabiska)',
        'uz-Arab-AF' => 'uzbekiska (arabiska, Afghanistan)',
        'uz-Cyrl' => 'uzbekiska (kyrilliska)',
        'uz-Cyrl-UZ' => 'uzbekiska (kyrilliska, Uzbekistan)',
        'uz-Latn' => 'uzbekiska (latinska)',
        'uz-Latn-UZ' => 'uzbekiska (latinska, Uzbekistan)',
        'vai' => 'vaj',
        'vai-Latn' => 'vaj (latinska)',
        'vai-Latn-LR' => 'vaj (latinska, Liberia)',
        'vai-Vaii' => 'vaj (vaj)',
        'vai-Vaii-LR' => 'vaj (vaj, Liberia)',
        'vi' => 'vietnamesiska',
        'vi-VN' => 'vietnamesiska (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walsertyska',
        'wae-CH' => 'walsertyska (Schweiz)',
        'xog' => 'lusoga',
        'xog-UG' => 'lusoga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Kamerun)',
        'yi' => 'jiddisch',
        'yi-001' => 'jiddisch (världen)',
        'yo' => 'yoruba',
        'yo-BJ' => 'yoruba (Benin)',
        'yo-NG' => 'yoruba (Nigeria)',
        'yue' => 'kantonesiska',
        'yue-HK' => 'kantonesiska (Hongkong, S.A.R. Kina)',
        'zgh' => 'marockansk standard-tamazight',
        'zgh-MA' => 'marockansk standard-tamazight (Marocko)',
        'zh' => 'kinesiska',
        'zh-Hans' => 'kinesiska (förenklade)',
        'zh-Hans-CN' => 'kinesiska (förenklade, Kina)',
        'zh-Hans-HK' => 'kinesiska (förenklade, Hongkong, S.A.R. Kina)',
        'zh-Hans-MO' => 'kinesiska (förenklade, Macao, S.A.R. Kina)',
        'zh-Hans-SG' => 'kinesiska (förenklade, Singapore)',
        'zh-Hant' => 'kinesiska (traditionella)',
        'zh-Hant-HK' => 'kinesiska (traditionella, Hongkong, S.A.R. Kina)',
        'zh-Hant-MO' => 'kinesiska (traditionella, Macao, S.A.R. Kina)',
        'zh-Hant-TW' => 'kinesiska (traditionella, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Sydafrika)',
    ],
];
