<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.y',
            'time' => 'HH:mm',
            'datetime' => 'd.M.y HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'd MMMM y EEEE',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'd MMMM y EEEE HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '%#,##0',
        'scientific' => '#E0',
    ],
    'amName' => 'ÖÖ',
    'pmName' => 'ÖS',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A',
        ],
        'medium' => [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara',
        ],
        'full' => [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A',
        ],
        'medium' => [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara',
        ],
        'full' => [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'P',
            'P',
            'S',
            'Ç',
            'P',
            'C',
            'C',
        ],
        'short' => [
            'Pa',
            'Pt',
            'Sa',
            'Ça',
            'Pe',
            'Cu',
            'Ct',
        ],
        'medium' => [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt',
        ],
        'full' => [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'P',
            'P',
            'S',
            'Ç',
            'P',
            'C',
            'C',
        ],
        'short' => [
            'Pa',
            'Pt',
            'Sa',
            'Ça',
            'Pe',
            'Cu',
            'Ct',
        ],
        'medium' => [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt',
        ],
        'full' => [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaanca',
        'af-NA' => 'Afrikaanca (Namibya)',
        'af-ZA' => 'Afrikaanca (Güney Afrika)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Kamerun)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Gana)',
        'am' => 'Amharca',
        'am-ET' => 'Amharca (Etiyopya)',
        'ar' => 'Arapça',
        'ar-001' => 'Arapça (Dünya)',
        'ar-AE' => 'Arapça (Birleşik Arap Emirlikleri)',
        'ar-BH' => 'Arapça (Bahreyn)',
        'ar-DJ' => 'Arapça (Cibuti)',
        'ar-DZ' => 'Arapça (Cezayir)',
        'ar-EG' => 'Arapça (Mısır)',
        'ar-EH' => 'Arapça (Batı Sahara)',
        'ar-ER' => 'Arapça (Eritre)',
        'ar-IL' => 'Arapça (İsrail)',
        'ar-IQ' => 'Arapça (Irak)',
        'ar-JO' => 'Arapça (Ürdün)',
        'ar-KM' => 'Arapça (Komorlar)',
        'ar-KW' => 'Arapça (Kuveyt)',
        'ar-LB' => 'Arapça (Lübnan)',
        'ar-LY' => 'Arapça (Libya)',
        'ar-MA' => 'Arapça (Fas)',
        'ar-MR' => 'Arapça (Moritanya)',
        'ar-OM' => 'Arapça (Umman)',
        'ar-PS' => 'Arapça (Filistin Bölgeleri)',
        'ar-QA' => 'Arapça (Katar)',
        'ar-SA' => 'Arapça (Suudi Arabistan)',
        'ar-SD' => 'Arapça (Sudan)',
        'ar-SO' => 'Arapça (Somali)',
        'ar-SS' => 'Arapça (Güney Sudan)',
        'ar-SY' => 'Arapça (Suriye)',
        'ar-TD' => 'Arapça (Çad)',
        'ar-TN' => 'Arapça (Tunus)',
        'ar-YE' => 'Arapça (Yemen)',
        'as' => 'Assamca',
        'as-IN' => 'Assamca (Hindistan)',
        'asa' => 'Asu',
        'asa-TZ' => 'Asu (Tanzanya)',
        'ast' => 'Asturyasca',
        'ast-ES' => 'Asturyasca (İspanya)',
        'az' => 'Azerice',
        'az-Cyrl' => 'Azerice (Kiril)',
        'az-Cyrl-AZ' => 'Azerice (Kiril, Azerbaycan)',
        'az-Latn' => 'Azerice (Latin)',
        'az-Latn-AZ' => 'Azerice (Latin, Azerbaycan)',
        'bas' => 'Basa Dili',
        'bas-CM' => 'Basa Dili (Kamerun)',
        'be' => 'Beyaz Rusça',
        'be-BY' => 'Beyaz Rusça (Beyaz Rusya)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Zambiya)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tanzanya)',
        'bg' => 'Bulgarca',
        'bg-BG' => 'Bulgarca (Bulgaristan)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bengalce',
        'bn-BD' => 'Bengalce (Bangladeş)',
        'bn-IN' => 'Bengalce (Hindistan)',
        'bo' => 'Tibetçe',
        'bo-CN' => 'Tibetçe (Çin)',
        'bo-IN' => 'Tibetçe (Hindistan)',
        'br' => 'Bretonca',
        'br-FR' => 'Bretonca (Fransa)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (Hindistan)',
        'bs' => 'Boşnakça',
        'bs-Cyrl' => 'Boşnakça (Kiril)',
        'bs-Cyrl-BA' => 'Boşnakça (Kiril, Bosna Hersek)',
        'bs-Latn' => 'Boşnakça (Latin)',
        'bs-Latn-BA' => 'Boşnakça (Latin, Bosna Hersek)',
        'ca' => 'Katalanca',
        'ca-AD' => 'Katalanca (Andorra)',
        'ca-ES' => 'Katalanca (İspanya)',
        'ca-FR' => 'Katalanca (Fransa)',
        'ca-IT' => 'Katalanca (İtalya)',
        'ce' => 'Çeçence',
        'ce-RU' => 'Çeçence (Rusya)',
        'cgg' => 'Kigaca',
        'cgg-UG' => 'Kigaca (Uganda)',
        'chr' => 'Çerokice',
        'chr-US' => 'Çerokice (ABD)',
        'cs' => 'Çekçe',
        'cs-CZ' => 'Çekçe (Çek Cumhuriyeti)',
        'cy' => 'Galce',
        'cy-GB' => 'Galce (Birleşik Krallık)',
        'da' => 'Danca',
        'da-DK' => 'Danca (Danimarka)',
        'da-GL' => 'Danca (Grönland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenya)',
        'de' => 'Almanca',
        'de-AT' => 'Almanca (Avusturya)',
        'de-BE' => 'Almanca (Belçika)',
        'de-CH' => 'Almanca (İsviçre)',
        'de-DE' => 'Almanca (Almanya)',
        'de-LI' => 'Almanca (Liechtenstein)',
        'de-LU' => 'Almanca (Lüksemburg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Nijer)',
        'dsb' => 'Aşağı Sorbça',
        'dsb-DE' => 'Aşağı Sorbça (Almanya)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Kamerun)',
        'dyo' => 'Jola-Fonyi',
        'dyo-SN' => 'Jola-Fonyi (Senegal)',
        'dz' => 'Butan Dili',
        'dz-BT' => 'Butan Dili (Butan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenya)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Gana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Yunanca',
        'el-CY' => 'Yunanca (Kıbrıs)',
        'el-GR' => 'Yunanca (Yunanistan)',
        'en' => 'İngilizce',
        'en-001' => 'İngilizce (Dünya)',
        'en-150' => 'İngilizce (Avrupa)',
        'en-AG' => 'İngilizce (Antigua ve Barbuda)',
        'en-AI' => 'İngilizce (Anguilla)',
        'en-AS' => 'İngilizce (Amerikan Samoası)',
        'en-AT' => 'İngilizce (Avusturya)',
        'en-AU' => 'İngilizce (Avustralya)',
        'en-BB' => 'İngilizce (Barbados)',
        'en-BE' => 'İngilizce (Belçika)',
        'en-BI' => 'İngilizce (Burundi)',
        'en-BM' => 'İngilizce (Bermuda)',
        'en-BS' => 'İngilizce (Bahamalar)',
        'en-BW' => 'İngilizce (Botsvana)',
        'en-BZ' => 'İngilizce (Belize)',
        'en-CA' => 'İngilizce (Kanada)',
        'en-CC' => 'İngilizce (Cocos [Keeling] Adaları)',
        'en-CH' => 'İngilizce (İsviçre)',
        'en-CK' => 'İngilizce (Cook Adaları)',
        'en-CM' => 'İngilizce (Kamerun)',
        'en-CX' => 'İngilizce (Christmas Adası)',
        'en-CY' => 'İngilizce (Kıbrıs)',
        'en-DE' => 'İngilizce (Almanya)',
        'en-DG' => 'İngilizce (Diego Garcia)',
        'en-DK' => 'İngilizce (Danimarka)',
        'en-DM' => 'İngilizce (Dominika)',
        'en-ER' => 'İngilizce (Eritre)',
        'en-FI' => 'İngilizce (Finlandiya)',
        'en-FJ' => 'İngilizce (Fiji)',
        'en-FK' => 'İngilizce (Falkland Adaları)',
        'en-FM' => 'İngilizce (Mikronezya)',
        'en-GB' => 'İngilizce (Birleşik Krallık)',
        'en-GD' => 'İngilizce (Grenada)',
        'en-GG' => 'İngilizce (Guernsey)',
        'en-GH' => 'İngilizce (Gana)',
        'en-GI' => 'İngilizce (Cebelitarık)',
        'en-GM' => 'İngilizce (Gambiya)',
        'en-GU' => 'İngilizce (Guam)',
        'en-GY' => 'İngilizce (Guyana)',
        'en-HK' => 'İngilizce (Çin Hong Kong ÖYB)',
        'en-IE' => 'İngilizce (İrlanda)',
        'en-IL' => 'İngilizce (İsrail)',
        'en-IM' => 'İngilizce (Man Adası)',
        'en-IN' => 'İngilizce (Hindistan)',
        'en-IO' => 'İngilizce (Britanya Hint Okyanusu Toprakları)',
        'en-JE' => 'İngilizce (Jersey)',
        'en-JM' => 'İngilizce (Jamaika)',
        'en-KE' => 'İngilizce (Kenya)',
        'en-KI' => 'İngilizce (Kiribati)',
        'en-KN' => 'İngilizce (Saint Kitts ve Nevis)',
        'en-KY' => 'İngilizce (Cayman Adaları)',
        'en-LC' => 'İngilizce (Saint Lucia)',
        'en-LR' => 'İngilizce (Liberya)',
        'en-LS' => 'İngilizce (Lesoto)',
        'en-MG' => 'İngilizce (Madagaskar)',
        'en-MH' => 'İngilizce (Marshall Adaları)',
        'en-MO' => 'İngilizce (Çin Makao ÖYB)',
        'en-MP' => 'İngilizce (Kuzey Mariana Adaları)',
        'en-MS' => 'İngilizce (Montserrat)',
        'en-MT' => 'İngilizce (Malta)',
        'en-MU' => 'İngilizce (Mauritius)',
        'en-MW' => 'İngilizce (Malavi)',
        'en-MY' => 'İngilizce (Malezya)',
        'en-NA' => 'İngilizce (Namibya)',
        'en-NF' => 'İngilizce (Norfolk Adası)',
        'en-NG' => 'İngilizce (Nijerya)',
        'en-NL' => 'İngilizce (Hollanda)',
        'en-NR' => 'İngilizce (Nauru)',
        'en-NU' => 'İngilizce (Niue)',
        'en-NZ' => 'İngilizce (Yeni Zelanda)',
        'en-PG' => 'İngilizce (Papua Yeni Gine)',
        'en-PH' => 'İngilizce (Filipinler)',
        'en-PK' => 'İngilizce (Pakistan)',
        'en-PN' => 'İngilizce (Pitcairn Adaları)',
        'en-PR' => 'İngilizce (Porto Riko)',
        'en-PW' => 'İngilizce (Palau)',
        'en-RW' => 'İngilizce (Ruanda)',
        'en-SB' => 'İngilizce (Solomon Adaları)',
        'en-SC' => 'İngilizce (Seyşeller)',
        'en-SD' => 'İngilizce (Sudan)',
        'en-SE' => 'İngilizce (İsveç)',
        'en-SG' => 'İngilizce (Singapur)',
        'en-SH' => 'İngilizce (Saint Helena)',
        'en-SI' => 'İngilizce (Slovenya)',
        'en-SL' => 'İngilizce (Sierra Leone)',
        'en-SS' => 'İngilizce (Güney Sudan)',
        'en-SX' => 'İngilizce (Sint Maarten)',
        'en-SZ' => 'İngilizce (Svaziland)',
        'en-TC' => 'İngilizce (Turks ve Caicos Adaları)',
        'en-TK' => 'İngilizce (Tokelau)',
        'en-TO' => 'İngilizce (Tonga)',
        'en-TT' => 'İngilizce (Trinidad ve Tobago)',
        'en-TV' => 'İngilizce (Tuvalu)',
        'en-TZ' => 'İngilizce (Tanzanya)',
        'en-UG' => 'İngilizce (Uganda)',
        'en-UM' => 'İngilizce (ABD Uzak Adaları)',
        'en-US' => 'İngilizce (ABD)',
        'en-US-POSIX' => 'İngilizce (ABD, Bilgisayar)',
        'en-VC' => 'İngilizce (Saint Vincent ve Grenadinler)',
        'en-VG' => 'İngilizce (Britanya Virjin Adaları)',
        'en-VI' => 'İngilizce (ABD Virjin Adaları)',
        'en-VU' => 'İngilizce (Vanuatu)',
        'en-WS' => 'İngilizce (Samoa)',
        'en-ZA' => 'İngilizce (Güney Afrika)',
        'en-ZM' => 'İngilizce (Zambiya)',
        'en-ZW' => 'İngilizce (Zimbabve)',
        'eo' => 'Esperanto',
        'es' => 'İspanyolca',
        'es-419' => 'İspanyolca (Latin Amerika)',
        'es-AR' => 'İspanyolca (Arjantin)',
        'es-BO' => 'İspanyolca (Bolivya)',
        'es-CL' => 'İspanyolca (Şili)',
        'es-CO' => 'İspanyolca (Kolombiya)',
        'es-CR' => 'İspanyolca (Kosta Rika)',
        'es-CU' => 'İspanyolca (Küba)',
        'es-DO' => 'İspanyolca (Dominik Cumhuriyeti)',
        'es-EA' => 'İspanyolca (Septe ve Melilla)',
        'es-EC' => 'İspanyolca (Ekvador)',
        'es-ES' => 'İspanyolca (İspanya)',
        'es-GQ' => 'İspanyolca (Ekvator Ginesi)',
        'es-GT' => 'İspanyolca (Guatemala)',
        'es-HN' => 'İspanyolca (Honduras)',
        'es-IC' => 'İspanyolca (Kanarya Adaları)',
        'es-MX' => 'İspanyolca (Meksika)',
        'es-NI' => 'İspanyolca (Nikaragua)',
        'es-PA' => 'İspanyolca (Panama)',
        'es-PE' => 'İspanyolca (Peru)',
        'es-PH' => 'İspanyolca (Filipinler)',
        'es-PR' => 'İspanyolca (Porto Riko)',
        'es-PY' => 'İspanyolca (Paraguay)',
        'es-SV' => 'İspanyolca (El Salvador)',
        'es-US' => 'İspanyolca (ABD)',
        'es-UY' => 'İspanyolca (Uruguay)',
        'es-VE' => 'İspanyolca (Venezuela)',
        'et' => 'Estonca',
        'et-EE' => 'Estonca (Estonya)',
        'eu' => 'Baskça',
        'eu-ES' => 'Baskça (İspanya)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Kamerun)',
        'fa' => 'Farsça',
        'fa-AF' => 'Farsça (Afganistan)',
        'fa-IR' => 'Farsça (İran)',
        'ff' => 'Fulah',
        'ff-CM' => 'Fulah (Kamerun)',
        'ff-GN' => 'Fulah (Gine)',
        'ff-MR' => 'Fulah (Moritanya)',
        'ff-SN' => 'Fulah (Senegal)',
        'fi' => 'Fince',
        'fi-FI' => 'Fince (Finlandiya)',
        'fil' => 'Filipince',
        'fil-PH' => 'Filipince (Filipinler)',
        'fo' => 'Faroe Dili',
        'fo-DK' => 'Faroe Dili (Danimarka)',
        'fo-FO' => 'Faroe Dili (Faroe Adaları)',
        'fr' => 'Fransızca',
        'fr-BE' => 'Fransızca (Belçika)',
        'fr-BF' => 'Fransızca (Burkina Faso)',
        'fr-BI' => 'Fransızca (Burundi)',
        'fr-BJ' => 'Fransızca (Benin)',
        'fr-BL' => 'Fransızca (Saint Barthelemy)',
        'fr-CA' => 'Fransızca (Kanada)',
        'fr-CD' => 'Fransızca (Kongo - Kinşasa)',
        'fr-CF' => 'Fransızca (Orta Afrika Cumhuriyeti)',
        'fr-CG' => 'Fransızca (Kongo - Brazavil)',
        'fr-CH' => 'Fransızca (İsviçre)',
        'fr-CI' => 'Fransızca (Fildişi Sahili)',
        'fr-CM' => 'Fransızca (Kamerun)',
        'fr-DJ' => 'Fransızca (Cibuti)',
        'fr-DZ' => 'Fransızca (Cezayir)',
        'fr-FR' => 'Fransızca (Fransa)',
        'fr-GA' => 'Fransızca (Gabon)',
        'fr-GF' => 'Fransızca (Fransız Guyanası)',
        'fr-GN' => 'Fransızca (Gine)',
        'fr-GP' => 'Fransızca (Guadalupe)',
        'fr-GQ' => 'Fransızca (Ekvator Ginesi)',
        'fr-HT' => 'Fransızca (Haiti)',
        'fr-KM' => 'Fransızca (Komorlar)',
        'fr-LU' => 'Fransızca (Lüksemburg)',
        'fr-MA' => 'Fransızca (Fas)',
        'fr-MC' => 'Fransızca (Monako)',
        'fr-MF' => 'Fransızca (Saint Martin)',
        'fr-MG' => 'Fransızca (Madagaskar)',
        'fr-ML' => 'Fransızca (Mali)',
        'fr-MQ' => 'Fransızca (Martinik)',
        'fr-MR' => 'Fransızca (Moritanya)',
        'fr-MU' => 'Fransızca (Mauritius)',
        'fr-NC' => 'Fransızca (Yeni Kaledonya)',
        'fr-NE' => 'Fransızca (Nijer)',
        'fr-PF' => 'Fransızca (Fransız Polinezyası)',
        'fr-PM' => 'Fransızca (Saint Pierre ve Miquelon)',
        'fr-RE' => 'Fransızca (Réunion)',
        'fr-RW' => 'Fransızca (Ruanda)',
        'fr-SC' => 'Fransızca (Seyşeller)',
        'fr-SN' => 'Fransızca (Senegal)',
        'fr-SY' => 'Fransızca (Suriye)',
        'fr-TD' => 'Fransızca (Çad)',
        'fr-TG' => 'Fransızca (Togo)',
        'fr-TN' => 'Fransızca (Tunus)',
        'fr-VU' => 'Fransızca (Vanuatu)',
        'fr-WF' => 'Fransızca (Wallis ve Futuna Adaları)',
        'fr-YT' => 'Fransızca (Mayotte)',
        'fur' => 'Friulian',
        'fur-IT' => 'Friulian (İtalya)',
        'fy' => 'Batı Frizcesi',
        'fy-NL' => 'Batı Frizcesi (Hollanda)',
        'ga' => 'İrlandaca',
        'ga-IE' => 'İrlandaca (İrlanda)',
        'gd' => 'İskoç Gal Dili',
        'gd-GB' => 'İskoç Gal Dili (Birleşik Krallık)',
        'gl' => 'Galiçyaca',
        'gl-ES' => 'Galiçyaca (İspanya)',
        'gsw' => 'İsviçre Almancası',
        'gsw-CH' => 'İsviçre Almancası (İsviçre)',
        'gsw-FR' => 'İsviçre Almancası (Fransa)',
        'gsw-LI' => 'İsviçre Almancası (Liechtenstein)',
        'gu' => 'Güceratça',
        'gu-IN' => 'Güceratça (Hindistan)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenya)',
        'gv' => 'Manks',
        'gv-IM' => 'Manks (Man Adası)',
        'ha' => 'Hausa',
        'ha-GH' => 'Hausa (Gana)',
        'ha-NE' => 'Hausa (Nijer)',
        'ha-NG' => 'Hausa (Nijerya)',
        'haw' => 'Hawaii Dili',
        'haw-US' => 'Hawaii Dili (ABD)',
        'he' => 'İbranice',
        'he-IL' => 'İbranice (İsrail)',
        'hi' => 'Hintçe',
        'hi-IN' => 'Hintçe (Hindistan)',
        'hr' => 'Hırvatça',
        'hr-BA' => 'Hırvatça (Bosna Hersek)',
        'hr-HR' => 'Hırvatça (Hırvatistan)',
        'hsb' => 'Yukarı Sorbça',
        'hsb-DE' => 'Yukarı Sorbça (Almanya)',
        'hu' => 'Macarca',
        'hu-HU' => 'Macarca (Macaristan)',
        'hy' => 'Ermenice',
        'hy-AM' => 'Ermenice (Ermenistan)',
        'id' => 'Endonezce',
        'id-ID' => 'Endonezce (Endonezya)',
        'ig' => 'İbo Dili',
        'ig-NG' => 'İbo Dili (Nijerya)',
        'ii' => 'Sichuan Yi',
        'ii-CN' => 'Sichuan Yi (Çin)',
        'is' => 'İzlandaca',
        'is-IS' => 'İzlandaca (İzlanda)',
        'it' => 'İtalyanca',
        'it-CH' => 'İtalyanca (İsviçre)',
        'it-IT' => 'İtalyanca (İtalya)',
        'it-SM' => 'İtalyanca (San Marino)',
        'ja' => 'Japonca',
        'ja-JP' => 'Japonca (Japonya)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Kamerun)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tanzanya)',
        'ka' => 'Gürcüce',
        'ka-GE' => 'Gürcüce (Gürcistan)',
        'kab' => 'Kabiliyece',
        'kab-DZ' => 'Kabiliyece (Cezayir)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenya)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tanzanya)',
        'kea' => 'Kabuverdianu',
        'kea-CV' => 'Kabuverdianu (Cape Verde)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Kikuyu',
        'ki-KE' => 'Kikuyu (Kenya)',
        'kk' => 'Kazakça',
        'kk-KZ' => 'Kazakça (Kazakistan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Kamerun)',
        'kl' => 'Grönland Dili',
        'kl-GL' => 'Grönland Dili (Grönland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenya)',
        'km' => 'Kmerce',
        'km-KH' => 'Kmerce (Kamboçya)',
        'kn' => 'Kannada',
        'kn-IN' => 'Kannada (Hindistan)',
        'ko' => 'Korece',
        'ko-KP' => 'Korece (Kuzey Kore)',
        'ko-KR' => 'Korece (Güney Kore)',
        'kok' => 'Konkani',
        'kok-IN' => 'Konkani (Hindistan)',
        'ks' => 'Keşmirce',
        'ks-IN' => 'Keşmirce (Hindistan)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tanzanya)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Kamerun)',
        'ksh' => 'Köln Diyalekti',
        'ksh-DE' => 'Köln Diyalekti (Almanya)',
        'kw' => 'Kernevekçe',
        'kw-GB' => 'Kernevekçe (Birleşik Krallık)',
        'ky' => 'Kırgızca',
        'ky-KG' => 'Kırgızca (Kırgızistan)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tanzanya)',
        'lb' => 'Lüksemburgca',
        'lb-LU' => 'Lüksemburgca (Lüksemburg)',
        'lg' => 'Ganda',
        'lg-UG' => 'Ganda (Uganda)',
        'lkt' => 'Lakotaca',
        'lkt-US' => 'Lakotaca (ABD)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Kongo - Kinşasa)',
        'ln-CF' => 'Lingala (Orta Afrika Cumhuriyeti)',
        'ln-CG' => 'Lingala (Kongo - Brazavil)',
        'lo' => 'Laoca',
        'lo-LA' => 'Laoca (Laos)',
        'lrc' => 'Kuzey Luri',
        'lrc-IQ' => 'Kuzey Luri (Irak)',
        'lrc-IR' => 'Kuzey Luri (İran)',
        'lt' => 'Litvanca',
        'lt-LT' => 'Litvanca (Litvanya)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Kongo - Kinşasa)',
        'luo' => 'Luo',
        'luo-KE' => 'Luo (Kenya)',
        'luy' => 'Luyia',
        'luy-KE' => 'Luyia (Kenya)',
        'lv' => 'Letonca',
        'lv-LV' => 'Letonca (Letonya)',
        'mas' => 'Masai',
        'mas-KE' => 'Masai (Kenya)',
        'mas-TZ' => 'Masai (Tanzanya)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenya)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Malgaşça',
        'mg-MG' => 'Malgaşça (Madagaskar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mozambik)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Kamerun)',
        'mk' => 'Makedonca',
        'mk-MK' => 'Makedonca (Makedonya)',
        'ml' => 'Malayalam',
        'ml-IN' => 'Malayalam (Hindistan)',
        'mn' => 'Moğolca',
        'mn-MN' => 'Moğolca (Moğolistan)',
        'mr' => 'Marathi',
        'mr-IN' => 'Marathi (Hindistan)',
        'ms' => 'Malayca',
        'ms-BN' => 'Malayca (Brunei)',
        'ms-MY' => 'Malayca (Malezya)',
        'ms-SG' => 'Malayca (Singapur)',
        'mt' => 'Maltaca',
        'mt-MT' => 'Maltaca (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Kamerun)',
        'my' => 'Burmaca',
        'my-MM' => 'Burmaca (Myanmar [Burma])',
        'mzn' => 'Mazenderanca',
        'mzn-IR' => 'Mazenderanca (İran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibya)',
        'nb' => 'Norveççe Bokmål',
        'nb-NO' => 'Norveççe Bokmål (Norveç)',
        'nb-SJ' => 'Norveççe Bokmål (Svalbard ve Jan Mayen Adaları)',
        'nd' => 'Kuzey Ndebele',
        'nd-ZW' => 'Kuzey Ndebele (Zimbabve)',
        'ne' => 'Nepalce',
        'ne-IN' => 'Nepalce (Hindistan)',
        'ne-NP' => 'Nepalce (Nepal)',
        'nl' => 'Hollandaca',
        'nl-AW' => 'Hollandaca (Aruba)',
        'nl-BE' => 'Hollandaca (Belçika)',
        'nl-BQ' => 'Hollandaca (Karayip Hollanda)',
        'nl-CW' => 'Hollandaca (Curaçao)',
        'nl-NL' => 'Hollandaca (Hollanda)',
        'nl-SR' => 'Hollandaca (Surinam)',
        'nl-SX' => 'Hollandaca (Sint Maarten)',
        'nmg' => 'Kwasio',
        'nmg-CM' => 'Kwasio (Kamerun)',
        'nn' => 'Norveççe Nynorsk',
        'nn-NO' => 'Norveççe Nynorsk (Norveç)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Kamerun)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (Güney Sudan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Uganda)',
        'om' => 'Oromo',
        'om-ET' => 'Oromo (Etiyopya)',
        'om-KE' => 'Oromo (Kenya)',
        'or' => 'Oriya Dili',
        'or-IN' => 'Oriya Dili (Hindistan)',
        'os' => 'Osetçe',
        'os-GE' => 'Osetçe (Gürcistan)',
        'os-RU' => 'Osetçe (Rusya)',
        'pa' => 'Pencapça',
        'pa-Arab' => 'Pencapça (Arap)',
        'pa-Arab-PK' => 'Pencapça (Arap, Pakistan)',
        'pa-Guru' => 'Pencapça (Gurmukhi)',
        'pa-Guru-IN' => 'Pencapça (Gurmukhi, Hindistan)',
        'pl' => 'Lehçe',
        'pl-PL' => 'Lehçe (Polonya)',
        'ps' => 'Peştuca',
        'ps-AF' => 'Peştuca (Afganistan)',
        'pt' => 'Portekizce',
        'pt-AO' => 'Portekizce (Angola)',
        'pt-BR' => 'Portekizce (Brezilya)',
        'pt-CV' => 'Portekizce (Cape Verde)',
        'pt-GW' => 'Portekizce (Gine-Bissau)',
        'pt-MO' => 'Portekizce (Çin Makao ÖYB)',
        'pt-MZ' => 'Portekizce (Mozambik)',
        'pt-PT' => 'Portekizce (Portekiz)',
        'pt-ST' => 'Portekizce (São Tomé ve Príncipe)',
        'pt-TL' => 'Portekizce (Timor-Leste)',
        'qu' => 'Keçuvaca',
        'qu-BO' => 'Keçuvaca (Bolivya)',
        'qu-EC' => 'Keçuvaca (Ekvador)',
        'qu-PE' => 'Keçuvaca (Peru)',
        'rm' => 'Romanşça',
        'rm-CH' => 'Romanşça (İsviçre)',
        'rn' => 'Kirundi',
        'rn-BI' => 'Kirundi (Burundi)',
        'ro' => 'Romence',
        'ro-MD' => 'Romence (Moldova)',
        'ro-RO' => 'Romence (Romanya)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tanzanya)',
        'ru' => 'Rusça',
        'ru-BY' => 'Rusça (Beyaz Rusya)',
        'ru-KG' => 'Rusça (Kırgızistan)',
        'ru-KZ' => 'Rusça (Kazakistan)',
        'ru-MD' => 'Rusça (Moldova)',
        'ru-RU' => 'Rusça (Rusya)',
        'ru-UA' => 'Rusça (Ukrayna)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Ruanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tanzanya)',
        'sah' => 'Yakutça',
        'sah-RU' => 'Yakutça (Rusya)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenya)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tanzanya)',
        'se' => 'Kuzey Sami',
        'se-FI' => 'Kuzey Sami (Finlandiya)',
        'se-NO' => 'Kuzey Sami (Norveç)',
        'se-SE' => 'Kuzey Sami (İsveç)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mozambik)',
        'ses' => 'Koyraboro Senni',
        'ses-ML' => 'Koyraboro Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Orta Afrika Cumhuriyeti)',
        'shi' => 'Taşelhit',
        'shi-Latn' => 'Taşelhit (Latin)',
        'shi-Latn-MA' => 'Taşelhit (Latin, Fas)',
        'shi-Tfng' => 'Taşelhit (Tifinagh)',
        'shi-Tfng-MA' => 'Taşelhit (Tifinagh, Fas)',
        'si' => 'Seylanca',
        'si-LK' => 'Seylanca (Sri Lanka)',
        'sk' => 'Slovakça',
        'sk-SK' => 'Slovakça (Slovakya)',
        'sl' => 'Slovence',
        'sl-SI' => 'Slovence (Slovenya)',
        'smn' => 'Inari Sami',
        'smn-FI' => 'Inari Sami (Finlandiya)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Zimbabve)',
        'so' => 'Somalice',
        'so-DJ' => 'Somalice (Cibuti)',
        'so-ET' => 'Somalice (Etiyopya)',
        'so-KE' => 'Somalice (Kenya)',
        'so-SO' => 'Somalice (Somali)',
        'sq' => 'Arnavutça',
        'sq-AL' => 'Arnavutça (Arnavutluk)',
        'sq-MK' => 'Arnavutça (Makedonya)',
        'sq-XK' => 'Arnavutça (Kosova)',
        'sr' => 'Sırpça',
        'sr-Cyrl' => 'Sırpça (Kiril)',
        'sr-Cyrl-BA' => 'Sırpça (Kiril, Bosna Hersek)',
        'sr-Cyrl-ME' => 'Sırpça (Kiril, Karadağ)',
        'sr-Cyrl-RS' => 'Sırpça (Kiril, Sırbistan)',
        'sr-Cyrl-XK' => 'Sırpça (Kiril, Kosova)',
        'sr-Latn' => 'Sırpça (Latin)',
        'sr-Latn-BA' => 'Sırpça (Latin, Bosna Hersek)',
        'sr-Latn-ME' => 'Sırpça (Latin, Karadağ)',
        'sr-Latn-RS' => 'Sırpça (Latin, Sırbistan)',
        'sr-Latn-XK' => 'Sırpça (Latin, Kosova)',
        'sv' => 'İsveççe',
        'sv-AX' => 'İsveççe (Åland Adaları)',
        'sv-FI' => 'İsveççe (Finlandiya)',
        'sv-SE' => 'İsveççe (İsveç)',
        'sw' => 'Svahili',
        'sw-CD' => 'Svahili (Kongo - Kinşasa)',
        'sw-KE' => 'Svahili (Kenya)',
        'sw-TZ' => 'Svahili (Tanzanya)',
        'sw-UG' => 'Svahili (Uganda)',
        'ta' => 'Tamilce',
        'ta-IN' => 'Tamilce (Hindistan)',
        'ta-LK' => 'Tamilce (Sri Lanka)',
        'ta-MY' => 'Tamilce (Malezya)',
        'ta-SG' => 'Tamilce (Singapur)',
        'te' => 'Telugu Dili',
        'te-IN' => 'Telugu Dili (Hindistan)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenya)',
        'teo-UG' => 'Teso (Uganda)',
        'th' => 'Tayca',
        'th-TH' => 'Tayca (Tayland)',
        'ti' => 'Tigrinya',
        'ti-ER' => 'Tigrinya (Eritre)',
        'ti-ET' => 'Tigrinya (Etiyopya)',
        'to' => 'Tongaca',
        'to-TO' => 'Tongaca (Tonga)',
        'tr' => 'Türkçe',
        'tr-CY' => 'Türkçe (Kıbrıs)',
        'tr-TR' => 'Türkçe (Türkiye)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Nijer)',
        'tzm' => 'Orta Fas Tamazigti',
        'tzm-MA' => 'Orta Fas Tamazigti (Fas)',
        'ug' => 'Uygurca',
        'ug-CN' => 'Uygurca (Çin)',
        'uk' => 'Ukraynaca',
        'uk-UA' => 'Ukraynaca (Ukrayna)',
        'ur' => 'Urduca',
        'ur-IN' => 'Urduca (Hindistan)',
        'ur-PK' => 'Urduca (Pakistan)',
        'uz' => 'Özbekçe',
        'uz-Arab' => 'Özbekçe (Arap)',
        'uz-Arab-AF' => 'Özbekçe (Arap, Afganistan)',
        'uz-Cyrl' => 'Özbekçe (Kiril)',
        'uz-Cyrl-UZ' => 'Özbekçe (Kiril, Özbekistan)',
        'uz-Latn' => 'Özbekçe (Latin)',
        'uz-Latn-UZ' => 'Özbekçe (Latin, Özbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Latin)',
        'vai-Latn-LR' => 'Vai (Latin, Liberya)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberya)',
        'vi' => 'Vietnamca',
        'vi-VN' => 'Vietnamca (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tanzanya)',
        'wae' => 'Walser',
        'wae-CH' => 'Walser (İsviçre)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Uganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Kamerun)',
        'yi' => 'Yidiş',
        'yi-001' => 'Yidiş (Dünya)',
        'yo' => 'Yorubaca',
        'yo-BJ' => 'Yorubaca (Benin)',
        'yo-NG' => 'Yorubaca (Nijerya)',
        'yue' => 'Kantonca',
        'yue-HK' => 'Kantonca (Çin Hong Kong ÖYB)',
        'zgh' => 'Standart Berberi Dili Tamazight',
        'zgh-MA' => 'Standart Berberi Dili Tamazight (Fas)',
        'zh' => 'Çince',
        'zh-Hans' => 'Çince (Basitleştirilmiş)',
        'zh-Hans-CN' => 'Çince (Basitleştirilmiş, Çin)',
        'zh-Hans-HK' => 'Çince (Basitleştirilmiş, Çin Hong Kong ÖYB)',
        'zh-Hans-MO' => 'Çince (Basitleştirilmiş, Çin Makao ÖYB)',
        'zh-Hans-SG' => 'Çince (Basitleştirilmiş, Singapur)',
        'zh-Hant' => 'Çince (Geleneksel)',
        'zh-Hant-HK' => 'Çince (Geleneksel, Çin Hong Kong ÖYB)',
        'zh-Hant-MO' => 'Çince (Geleneksel, Çin Makao ÖYB)',
        'zh-Hant-TW' => 'Çince (Geleneksel, Tayvan)',
        'zu' => 'Zuluca',
        'zu-ZA' => 'Zuluca (Güney Afrika)',
    ],
];
