<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y/M/d',
            'time' => 'ah:mm',
            'datetime' => 'y/M/d ah:mm',
        ],
        'medium' => [
            'date' => 'y年M月d日',
            'time' => 'ah:mm:ss',
            'datetime' => 'y年M月d日 ah:mm:ss',
        ],
        'long' => [
            'date' => 'y年M月d日',
            'time' => 'z ah:mm:ss',
            'datetime' => 'y年M月d日 z ah:mm:ss',
        ],
        'full' => [
            'date' => 'y年M月d日EEEE',
            'time' => 'zzzz ah:mm:ss',
            'datetime' => 'y年M月d日EEEE zzzz ah:mm:ss',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => '上午',
    'pmName' => '下午',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => '￥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '￦',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            '日',
            '一',
            '二',
            '三',
            '四',
            '五',
            '六',
        ],
        'short' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'medium' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'full' => [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            '日',
            '一',
            '二',
            '三',
            '四',
            '五',
            '六',
        ],
        'short' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'medium' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'full' => [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六',
        ],
    ],
    'localeDisplayNames' => [
        'af' => '南非荷兰文',
        'af-NA' => '南非荷兰文（纳米比亚）',
        'af-ZA' => '南非荷兰文（南非）',
        'agq' => '亚罕文',
        'agq-CM' => '亚罕文（喀麦隆）',
        'ak' => '阿肯文',
        'ak-GH' => '阿肯文（加纳）',
        'am' => '阿姆哈拉文',
        'am-ET' => '阿姆哈拉文（埃塞俄比亚）',
        'ar' => '阿拉伯文',
        'ar-001' => '阿拉伯文（世界）',
        'ar-AE' => '阿拉伯文（阿拉伯联合酋长国）',
        'ar-BH' => '阿拉伯文（巴林）',
        'ar-DJ' => '阿拉伯文（吉布提）',
        'ar-DZ' => '阿拉伯文（阿尔及利亚）',
        'ar-EG' => '阿拉伯文（埃及）',
        'ar-EH' => '阿拉伯文（西撒哈拉）',
        'ar-ER' => '阿拉伯文（厄立特里亚）',
        'ar-IL' => '阿拉伯文（以色列）',
        'ar-IQ' => '阿拉伯文（伊拉克）',
        'ar-JO' => '阿拉伯文（约旦）',
        'ar-KM' => '阿拉伯文（科摩罗）',
        'ar-KW' => '阿拉伯文（科威特）',
        'ar-LB' => '阿拉伯文（黎巴嫩）',
        'ar-LY' => '阿拉伯文（利比亚）',
        'ar-MA' => '阿拉伯文（摩洛哥）',
        'ar-MR' => '阿拉伯文（毛里塔尼亚）',
        'ar-OM' => '阿拉伯文（阿曼）',
        'ar-PS' => '阿拉伯文（巴勒斯坦领土）',
        'ar-QA' => '阿拉伯文（卡塔尔）',
        'ar-SA' => '阿拉伯文（沙特阿拉伯）',
        'ar-SD' => '阿拉伯文（苏丹）',
        'ar-SO' => '阿拉伯文（索马里）',
        'ar-SS' => '阿拉伯文（南苏丹）',
        'ar-SY' => '阿拉伯文（叙利亚）',
        'ar-TD' => '阿拉伯文（乍得）',
        'ar-TN' => '阿拉伯文（突尼斯）',
        'ar-YE' => '阿拉伯文（也门）',
        'as' => '阿萨姆文',
        'as-IN' => '阿萨姆文（印度）',
        'asa' => '阿苏文',
        'asa-TZ' => '阿苏文（坦桑尼亚）',
        'ast' => '阿斯图里亚思特文',
        'ast-ES' => '阿斯图里亚思特文（西班牙）',
        'az' => '阿塞拜疆文',
        'az-Cyrl' => '阿塞拜疆文（西里尔文）',
        'az-Cyrl-AZ' => '阿塞拜疆文（西里尔文、阿塞拜疆）',
        'az-Latn' => '阿塞拜疆文（拉丁文）',
        'az-Latn-AZ' => '阿塞拜疆文（拉丁文、阿塞拜疆）',
        'bas' => '巴萨文',
        'bas-CM' => '巴萨文（喀麦隆）',
        'be' => '白俄罗斯文',
        'be-BY' => '白俄罗斯文（白俄罗斯）',
        'bem' => '别姆巴文',
        'bem-ZM' => '别姆巴文（赞比亚）',
        'bez' => '贝纳文',
        'bez-TZ' => '贝纳文（坦桑尼亚）',
        'bg' => '保加利亚文',
        'bg-BG' => '保加利亚文（保加利亚）',
        'bm' => '班巴拉文',
        'bm-ML' => '班巴拉文（马里）',
        'bn' => '孟加拉文',
        'bn-BD' => '孟加拉文（孟加拉国）',
        'bn-IN' => '孟加拉文（印度）',
        'bo' => '藏文',
        'bo-CN' => '藏文（中国）',
        'bo-IN' => '藏文（印度）',
        'br' => '布里多尼文',
        'br-FR' => '布里多尼文（法国）',
        'brx' => '博多文',
        'brx-IN' => '博多文（印度）',
        'bs' => '波斯尼亚文',
        'bs-Cyrl' => '波斯尼亚文（西里尔文）',
        'bs-Cyrl-BA' => '波斯尼亚文（西里尔文、波斯尼亚和黑塞哥维那）',
        'bs-Latn' => '波斯尼亚文（拉丁文）',
        'bs-Latn-BA' => '波斯尼亚文（拉丁文、波斯尼亚和黑塞哥维那）',
        'ca' => '加泰罗尼亚文',
        'ca-AD' => '加泰罗尼亚文（安道尔）',
        'ca-ES' => '加泰罗尼亚文（西班牙）',
        'ca-FR' => '加泰罗尼亚文（法国）',
        'ca-IT' => '加泰罗尼亚文（意大利）',
        'ce' => '车臣文',
        'ce-RU' => '车臣文（俄罗斯）',
        'cgg' => '奇加文',
        'cgg-UG' => '奇加文（乌干达）',
        'chr' => '彻罗基文',
        'chr-US' => '彻罗基文（美国）',
        'cs' => '捷克文',
        'cs-CZ' => '捷克文（捷克共和国）',
        'cy' => '威尔士文',
        'cy-GB' => '威尔士文（英国）',
        'da' => '丹麦文',
        'da-DK' => '丹麦文（丹麦）',
        'da-GL' => '丹麦文（格陵兰）',
        'dav' => '台塔文',
        'dav-KE' => '台塔文（肯尼亚）',
        'de' => '德文',
        'de-AT' => '德文（奥地利）',
        'de-BE' => '德文（比利时）',
        'de-CH' => '德文（瑞士）',
        'de-DE' => '德文（德国）',
        'de-LI' => '德文（列支敦士登）',
        'de-LU' => '德文（卢森堡）',
        'dje' => '哲尔马文',
        'dje-NE' => '哲尔马文（尼日尔）',
        'dsb' => '下索布文',
        'dsb-DE' => '下索布文（德国）',
        'dua' => '都阿拉文',
        'dua-CM' => '都阿拉文（喀麦隆）',
        'dyo' => '朱拉文',
        'dyo-SN' => '朱拉文（塞内加尔）',
        'dz' => '不丹文',
        'dz-BT' => '不丹文（不丹）',
        'ebu' => '恩布文',
        'ebu-KE' => '恩布文（肯尼亚）',
        'ee' => '埃维文',
        'ee-GH' => '埃维文（加纳）',
        'ee-TG' => '埃维文（多哥）',
        'el' => '希腊文',
        'el-CY' => '希腊文（塞浦路斯）',
        'el-GR' => '希腊文（希腊）',
        'en' => '英文',
        'en-001' => '英文（世界）',
        'en-150' => '英文（欧洲）',
        'en-AG' => '英文（安提瓜和巴布达）',
        'en-AI' => '英文（安圭拉）',
        'en-AS' => '英文（美属萨摩亚）',
        'en-AT' => '英文（奥地利）',
        'en-AU' => '英文（澳大利亚）',
        'en-BB' => '英文（巴巴多斯）',
        'en-BE' => '英文（比利时）',
        'en-BI' => '英文（布隆迪）',
        'en-BM' => '英文（百慕大）',
        'en-BS' => '英文（巴哈马）',
        'en-BW' => '英文（博茨瓦纳）',
        'en-BZ' => '英文（伯利兹）',
        'en-CA' => '英文（加拿大）',
        'en-CC' => '英文（科科斯［基林］群岛）',
        'en-CH' => '英文（瑞士）',
        'en-CK' => '英文（库克群岛）',
        'en-CM' => '英文（喀麦隆）',
        'en-CX' => '英文（圣诞岛）',
        'en-CY' => '英文（塞浦路斯）',
        'en-DE' => '英文（德国）',
        'en-DG' => '英文（迪戈加西亚岛）',
        'en-DK' => '英文（丹麦）',
        'en-DM' => '英文（多米尼克）',
        'en-ER' => '英文（厄立特里亚）',
        'en-FI' => '英文（芬兰）',
        'en-FJ' => '英文（斐济）',
        'en-FK' => '英文（福克兰群岛）',
        'en-FM' => '英文（密克罗尼西亚）',
        'en-GB' => '英文（英国）',
        'en-GD' => '英文（格林纳达）',
        'en-GG' => '英文（根西岛）',
        'en-GH' => '英文（加纳）',
        'en-GI' => '英文（直布罗陀）',
        'en-GM' => '英文（冈比亚）',
        'en-GU' => '英文（关岛）',
        'en-GY' => '英文（圭亚那）',
        'en-HK' => '英文（中国香港特别行政区）',
        'en-IE' => '英文（爱尔兰）',
        'en-IL' => '英文（以色列）',
        'en-IM' => '英文（曼岛）',
        'en-IN' => '英文（印度）',
        'en-IO' => '英文（英属印度洋领地）',
        'en-JE' => '英文（泽西岛）',
        'en-JM' => '英文（牙买加）',
        'en-KE' => '英文（肯尼亚）',
        'en-KI' => '英文（基里巴斯）',
        'en-KN' => '英文（圣基茨和尼维斯）',
        'en-KY' => '英文（开曼群岛）',
        'en-LC' => '英文（圣卢西亚）',
        'en-LR' => '英文（利比里亚）',
        'en-LS' => '英文（莱索托）',
        'en-MG' => '英文（马达加斯加）',
        'en-MH' => '英文（马绍尔群岛）',
        'en-MO' => '英文（中国澳门特别行政区）',
        'en-MP' => '英文（北马里亚纳群岛）',
        'en-MS' => '英文（蒙特塞拉特）',
        'en-MT' => '英文（马耳他）',
        'en-MU' => '英文（毛里求斯）',
        'en-MW' => '英文（马拉维）',
        'en-MY' => '英文（马来西亚）',
        'en-NA' => '英文（纳米比亚）',
        'en-NF' => '英文（诺福克岛）',
        'en-NG' => '英文（尼日利亚）',
        'en-NL' => '英文（荷兰）',
        'en-NR' => '英文（瑙鲁）',
        'en-NU' => '英文（纽埃）',
        'en-NZ' => '英文（新西兰）',
        'en-PG' => '英文（巴布亚新几内亚）',
        'en-PH' => '英文（菲律宾）',
        'en-PK' => '英文（巴基斯坦）',
        'en-PN' => '英文（皮特凯恩群岛）',
        'en-PR' => '英文（波多黎各）',
        'en-PW' => '英文（帕劳）',
        'en-RW' => '英文（卢旺达）',
        'en-SB' => '英文（所罗门群岛）',
        'en-SC' => '英文（塞舌尔）',
        'en-SD' => '英文（苏丹）',
        'en-SE' => '英文（瑞典）',
        'en-SG' => '英文（新加坡）',
        'en-SH' => '英文（圣赫勒拿）',
        'en-SI' => '英文（斯洛文尼亚）',
        'en-SL' => '英文（塞拉利昂）',
        'en-SS' => '英文（南苏丹）',
        'en-SX' => '英文（荷属圣马丁）',
        'en-SZ' => '英文（斯威士兰）',
        'en-TC' => '英文（特克斯和凯科斯群岛）',
        'en-TK' => '英文（托克劳）',
        'en-TO' => '英文（汤加）',
        'en-TT' => '英文（特立尼达和多巴哥）',
        'en-TV' => '英文（图瓦卢）',
        'en-TZ' => '英文（坦桑尼亚）',
        'en-UG' => '英文（乌干达）',
        'en-UM' => '英文（美国本土外小岛屿）',
        'en-US' => '英文（美国）',
        'en-US-POSIX' => '英文（美国、电脑）',
        'en-VC' => '英文（圣文森特和格林纳丁斯）',
        'en-VG' => '英文（英属维京群岛）',
        'en-VI' => '英文（美属维京群岛）',
        'en-VU' => '英文（瓦努阿图）',
        'en-WS' => '英文（萨摩亚）',
        'en-ZA' => '英文（南非）',
        'en-ZM' => '英文（赞比亚）',
        'en-ZW' => '英文（津巴布韦）',
        'eo' => '世界文',
        'es' => '西班牙文',
        'es-419' => '西班牙文（拉丁美洲）',
        'es-AR' => '西班牙文（阿根廷）',
        'es-BO' => '西班牙文（玻利维亚）',
        'es-CL' => '西班牙文（智利）',
        'es-CO' => '西班牙文（哥伦比亚）',
        'es-CR' => '西班牙文（哥斯达黎加）',
        'es-CU' => '西班牙文（古巴）',
        'es-DO' => '西班牙文（多米尼加共和国）',
        'es-EA' => '西班牙文（休达及梅利利亚）',
        'es-EC' => '西班牙文（厄瓜多尔）',
        'es-ES' => '西班牙文（西班牙）',
        'es-GQ' => '西班牙文（赤道几内亚）',
        'es-GT' => '西班牙文（危地马拉）',
        'es-HN' => '西班牙文（洪都拉斯）',
        'es-IC' => '西班牙文（加纳利群岛）',
        'es-MX' => '西班牙文（墨西哥）',
        'es-NI' => '西班牙文（尼加拉瓜）',
        'es-PA' => '西班牙文（巴拿马）',
        'es-PE' => '西班牙文（秘鲁）',
        'es-PH' => '西班牙文（菲律宾）',
        'es-PR' => '西班牙文（波多黎各）',
        'es-PY' => '西班牙文（巴拉圭）',
        'es-SV' => '西班牙文（萨尔瓦多）',
        'es-US' => '西班牙文（美国）',
        'es-UY' => '西班牙文（乌拉圭）',
        'es-VE' => '西班牙文（委内瑞拉）',
        'et' => '爱沙尼亚文',
        'et-EE' => '爱沙尼亚文（爱沙尼亚）',
        'eu' => '巴斯克文',
        'eu-ES' => '巴斯克文（西班牙）',
        'ewo' => '旺杜文',
        'ewo-CM' => '旺杜文（喀麦隆）',
        'fa' => '波斯文',
        'fa-AF' => '波斯文（阿富汗）',
        'fa-IR' => '波斯文（伊朗）',
        'ff' => '夫拉文',
        'ff-CM' => '夫拉文（喀麦隆）',
        'ff-GN' => '夫拉文（几内亚）',
        'ff-MR' => '夫拉文（毛里塔尼亚）',
        'ff-SN' => '夫拉文（塞内加尔）',
        'fi' => '芬兰文',
        'fi-FI' => '芬兰文（芬兰）',
        'fil' => '菲律宾文',
        'fil-PH' => '菲律宾文（菲律宾）',
        'fo' => '法罗文',
        'fo-DK' => '法罗文（丹麦）',
        'fo-FO' => '法罗文（法罗群岛）',
        'fr' => '法文',
        'fr-BE' => '法文（比利时）',
        'fr-BF' => '法文（布基纳法索）',
        'fr-BI' => '法文（布隆迪）',
        'fr-BJ' => '法文（贝宁）',
        'fr-BL' => '法文（圣巴泰勒米）',
        'fr-CA' => '法文（加拿大）',
        'fr-CD' => '法文（刚果［金］）',
        'fr-CF' => '法文（中非共和国）',
        'fr-CG' => '法文（刚果［布］）',
        'fr-CH' => '法文（瑞士）',
        'fr-CI' => '法文（科特迪瓦）',
        'fr-CM' => '法文（喀麦隆）',
        'fr-DJ' => '法文（吉布提）',
        'fr-DZ' => '法文（阿尔及利亚）',
        'fr-FR' => '法文（法国）',
        'fr-GA' => '法文（加蓬）',
        'fr-GF' => '法文（法属圭亚那）',
        'fr-GN' => '法文（几内亚）',
        'fr-GP' => '法文（瓜德罗普）',
        'fr-GQ' => '法文（赤道几内亚）',
        'fr-HT' => '法文（海地）',
        'fr-KM' => '法文（科摩罗）',
        'fr-LU' => '法文（卢森堡）',
        'fr-MA' => '法文（摩洛哥）',
        'fr-MC' => '法文（摩纳哥）',
        'fr-MF' => '法文（法属圣马丁）',
        'fr-MG' => '法文（马达加斯加）',
        'fr-ML' => '法文（马里）',
        'fr-MQ' => '法文（马提尼克）',
        'fr-MR' => '法文（毛里塔尼亚）',
        'fr-MU' => '法文（毛里求斯）',
        'fr-NC' => '法文（新喀里多尼亚）',
        'fr-NE' => '法文（尼日尔）',
        'fr-PF' => '法文（法属波利尼西亚）',
        'fr-PM' => '法文（圣皮埃尔和密克隆群岛）',
        'fr-RE' => '法文（留尼汪）',
        'fr-RW' => '法文（卢旺达）',
        'fr-SC' => '法文（塞舌尔）',
        'fr-SN' => '法文（塞内加尔）',
        'fr-SY' => '法文（叙利亚）',
        'fr-TD' => '法文（乍得）',
        'fr-TG' => '法文（多哥）',
        'fr-TN' => '法文（突尼斯）',
        'fr-VU' => '法文（瓦努阿图）',
        'fr-WF' => '法文（瓦利斯和富图纳）',
        'fr-YT' => '法文（马约特）',
        'fur' => '弗留利文',
        'fur-IT' => '弗留利文（意大利）',
        'fy' => '西弗里西亚文',
        'fy-NL' => '西弗里西亚文（荷兰）',
        'ga' => '爱尔兰文',
        'ga-IE' => '爱尔兰文（爱尔兰）',
        'gd' => '苏格兰盖尔文',
        'gd-GB' => '苏格兰盖尔文（英国）',
        'gl' => '加利西亚文',
        'gl-ES' => '加利西亚文（西班牙）',
        'gsw' => '瑞士德文',
        'gsw-CH' => '瑞士德文（瑞士）',
        'gsw-FR' => '瑞士德文（法国）',
        'gsw-LI' => '瑞士德文（列支敦士登）',
        'gu' => '古吉拉特文',
        'gu-IN' => '古吉拉特文（印度）',
        'guz' => '古西文',
        'guz-KE' => '古西文（肯尼亚）',
        'gv' => '马恩岛文',
        'gv-IM' => '马恩岛文（曼岛）',
        'ha' => '豪萨文',
        'ha-GH' => '豪萨文（加纳）',
        'ha-NE' => '豪萨文（尼日尔）',
        'ha-NG' => '豪萨文（尼日利亚）',
        'haw' => '夏威夷文',
        'haw-US' => '夏威夷文（美国）',
        'he' => '希伯来文',
        'he-IL' => '希伯来文（以色列）',
        'hi' => '印地文',
        'hi-IN' => '印地文（印度）',
        'hr' => '克罗地亚文',
        'hr-BA' => '克罗地亚文（波斯尼亚和黑塞哥维那）',
        'hr-HR' => '克罗地亚文（克罗地亚）',
        'hsb' => '上索布文',
        'hsb-DE' => '上索布文（德国）',
        'hu' => '匈牙利文',
        'hu-HU' => '匈牙利文（匈牙利）',
        'hy' => '亚美尼亚文',
        'hy-AM' => '亚美尼亚文（亚美尼亚）',
        'id' => '印度尼西亚文',
        'id-ID' => '印度尼西亚文（印度尼西亚）',
        'ig' => '伊布文',
        'ig-NG' => '伊布文（尼日利亚）',
        'ii' => '四川彝文',
        'ii-CN' => '四川彝文（中国）',
        'is' => '冰岛文',
        'is-IS' => '冰岛文（冰岛）',
        'it' => '意大利文',
        'it-CH' => '意大利文（瑞士）',
        'it-IT' => '意大利文（意大利）',
        'it-SM' => '意大利文（圣马力诺）',
        'ja' => '日文',
        'ja-JP' => '日文（日本）',
        'jgo' => '恩艮巴',
        'jgo-CM' => '恩艮巴（喀麦隆）',
        'jmc' => '马切姆文',
        'jmc-TZ' => '马切姆文（坦桑尼亚）',
        'ka' => '格鲁吉亚文',
        'ka-GE' => '格鲁吉亚文（格鲁吉亚）',
        'kab' => '卡比尔文',
        'kab-DZ' => '卡比尔文（阿尔及利亚）',
        'kam' => '卡姆巴文',
        'kam-KE' => '卡姆巴文（肯尼亚）',
        'kde' => '马孔德文',
        'kde-TZ' => '马孔德文（坦桑尼亚）',
        'kea' => '卡布佛得鲁文',
        'kea-CV' => '卡布佛得鲁文（佛得角）',
        'khq' => '西桑海文',
        'khq-ML' => '西桑海文（马里）',
        'ki' => '吉库尤文',
        'ki-KE' => '吉库尤文（肯尼亚）',
        'kk' => '哈萨克文',
        'kk-KZ' => '哈萨克文（哈萨克斯坦）',
        'kkj' => '卡库文',
        'kkj-CM' => '卡库文（喀麦隆）',
        'kl' => '格陵兰文',
        'kl-GL' => '格陵兰文（格陵兰）',
        'kln' => '卡伦金文',
        'kln-KE' => '卡伦金文（肯尼亚）',
        'km' => '高棉文',
        'km-KH' => '高棉文（柬埔寨）',
        'kn' => '卡纳达文',
        'kn-IN' => '卡纳达文（印度）',
        'ko' => '韩文',
        'ko-KP' => '韩文（朝鲜）',
        'ko-KR' => '韩文（韩国）',
        'kok' => '刚卡尼文',
        'kok-IN' => '刚卡尼文（印度）',
        'ks' => '克什米尔文',
        'ks-IN' => '克什米尔文（印度）',
        'ksb' => '香巴拉文',
        'ksb-TZ' => '香巴拉文（坦桑尼亚）',
        'ksf' => '巴菲亚文',
        'ksf-CM' => '巴菲亚文（喀麦隆）',
        'ksh' => '科隆文',
        'ksh-DE' => '科隆文（德国）',
        'kw' => '凯尔特文',
        'kw-GB' => '凯尔特文（英国）',
        'ky' => '吉尔吉斯文',
        'ky-KG' => '吉尔吉斯文（吉尔吉斯斯坦）',
        'lag' => '朗吉文',
        'lag-TZ' => '朗吉文（坦桑尼亚）',
        'lb' => '卢森堡文',
        'lb-LU' => '卢森堡文（卢森堡）',
        'lg' => '卢干达文',
        'lg-UG' => '卢干达文（乌干达）',
        'lkt' => '拉科塔文',
        'lkt-US' => '拉科塔文（美国）',
        'ln' => '林加拉文',
        'ln-AO' => '林加拉文（安哥拉）',
        'ln-CD' => '林加拉文（刚果［金］）',
        'ln-CF' => '林加拉文（中非共和国）',
        'ln-CG' => '林加拉文（刚果［布］）',
        'lo' => '老挝文',
        'lo-LA' => '老挝文（老挝）',
        'lrc' => '北卢尔文',
        'lrc-IQ' => '北卢尔文（伊拉克）',
        'lrc-IR' => '北卢尔文（伊朗）',
        'lt' => '立陶宛文',
        'lt-LT' => '立陶宛文（立陶宛）',
        'lu' => '鲁巴加丹加文',
        'lu-CD' => '鲁巴加丹加文（刚果［金］）',
        'luo' => '卢奥文',
        'luo-KE' => '卢奥文（肯尼亚）',
        'luy' => '卢雅文',
        'luy-KE' => '卢雅文（肯尼亚）',
        'lv' => '拉脱维亚文',
        'lv-LV' => '拉脱维亚文（拉脱维亚）',
        'mas' => '萨伊文',
        'mas-KE' => '萨伊文（肯尼亚）',
        'mas-TZ' => '萨伊文（坦桑尼亚）',
        'mer' => '梅鲁文',
        'mer-KE' => '梅鲁文（肯尼亚）',
        'mfe' => '毛里求斯克里奥尔文',
        'mfe-MU' => '毛里求斯克里奥尔文（毛里求斯）',
        'mg' => '马尔加什文',
        'mg-MG' => '马尔加什文（马达加斯加）',
        'mgh' => '马夸文',
        'mgh-MZ' => '马夸文（莫桑比克）',
        'mgo' => '梅塔',
        'mgo-CM' => '梅塔（喀麦隆）',
        'mk' => '马其顿文',
        'mk-MK' => '马其顿文（马其顿）',
        'ml' => '马拉雅拉姆文',
        'ml-IN' => '马拉雅拉姆文（印度）',
        'mn' => '蒙古文',
        'mn-MN' => '蒙古文（蒙古）',
        'mr' => '马拉地文',
        'mr-IN' => '马拉地文（印度）',
        'ms' => '马来文',
        'ms-BN' => '马来文（文莱）',
        'ms-MY' => '马来文（马来西亚）',
        'ms-SG' => '马来文（新加坡）',
        'mt' => '马耳他文',
        'mt-MT' => '马耳他文（马耳他）',
        'mua' => '蒙当文',
        'mua-CM' => '蒙当文（喀麦隆）',
        'my' => '缅甸文',
        'my-MM' => '缅甸文（缅甸）',
        'mzn' => '马赞德兰文',
        'mzn-IR' => '马赞德兰文（伊朗）',
        'naq' => '纳马文',
        'naq-NA' => '纳马文（纳米比亚）',
        'nb' => '挪威博克马尔文',
        'nb-NO' => '挪威博克马尔文（挪威）',
        'nb-SJ' => '挪威博克马尔文（斯瓦尔巴特和扬马延）',
        'nd' => '北恩德贝勒文',
        'nd-ZW' => '北恩德贝勒文（津巴布韦）',
        'ne' => '尼泊尔文',
        'ne-IN' => '尼泊尔文（印度）',
        'ne-NP' => '尼泊尔文（尼泊尔）',
        'nl' => '荷兰文',
        'nl-AW' => '荷兰文（阿鲁巴）',
        'nl-BE' => '荷兰文（比利时）',
        'nl-BQ' => '荷兰文（荷兰加勒比区）',
        'nl-CW' => '荷兰文（库拉索）',
        'nl-NL' => '荷兰文（荷兰）',
        'nl-SR' => '荷兰文（苏里南）',
        'nl-SX' => '荷兰文（荷属圣马丁）',
        'nmg' => '夸西奥文',
        'nmg-CM' => '夸西奥文（喀麦隆）',
        'nn' => '挪威尼诺斯克文',
        'nn-NO' => '挪威尼诺斯克文（挪威）',
        'nnh' => '恩甘澎文',
        'nnh-CM' => '恩甘澎文（喀麦隆）',
        'nus' => '努埃尔文',
        'nus-SS' => '努埃尔文（南苏丹）',
        'nyn' => '尼昂科勒文',
        'nyn-UG' => '尼昂科勒文（乌干达）',
        'om' => '奥洛莫文',
        'om-ET' => '奥洛莫文（埃塞俄比亚）',
        'om-KE' => '奥洛莫文（肯尼亚）',
        'or' => '奥里亚文',
        'or-IN' => '奥里亚文（印度）',
        'os' => '奥塞梯文',
        'os-GE' => '奥塞梯文（格鲁吉亚）',
        'os-RU' => '奥塞梯文（俄罗斯）',
        'pa' => '旁遮普文',
        'pa-Arab' => '旁遮普文（阿拉伯文）',
        'pa-Arab-PK' => '旁遮普文（阿拉伯文、巴基斯坦）',
        'pa-Guru' => '旁遮普文（果鲁穆奇文）',
        'pa-Guru-IN' => '旁遮普文（果鲁穆奇文、印度）',
        'pl' => '波兰文',
        'pl-PL' => '波兰文（波兰）',
        'ps' => '普什图文',
        'ps-AF' => '普什图文（阿富汗）',
        'pt' => '葡萄牙文',
        'pt-AO' => '葡萄牙文（安哥拉）',
        'pt-BR' => '葡萄牙文（巴西）',
        'pt-CV' => '葡萄牙文（佛得角）',
        'pt-GW' => '葡萄牙文（几内亚比绍）',
        'pt-MO' => '葡萄牙文（中国澳门特别行政区）',
        'pt-MZ' => '葡萄牙文（莫桑比克）',
        'pt-PT' => '葡萄牙文（葡萄牙）',
        'pt-ST' => '葡萄牙文（圣多美和普林西比）',
        'pt-TL' => '葡萄牙文（东帝汶）',
        'qu' => '盖丘亚文',
        'qu-BO' => '盖丘亚文（玻利维亚）',
        'qu-EC' => '盖丘亚文（厄瓜多尔）',
        'qu-PE' => '盖丘亚文（秘鲁）',
        'rm' => '罗曼什文',
        'rm-CH' => '罗曼什文（瑞士）',
        'rn' => '基隆迪文',
        'rn-BI' => '基隆迪文（布隆迪）',
        'ro' => '罗马尼亚文',
        'ro-MD' => '罗马尼亚文（摩尔多瓦）',
        'ro-RO' => '罗马尼亚文（罗马尼亚）',
        'rof' => '兰博文',
        'rof-TZ' => '兰博文（坦桑尼亚）',
        'ru' => '俄文',
        'ru-BY' => '俄文（白俄罗斯）',
        'ru-KG' => '俄文（吉尔吉斯斯坦）',
        'ru-KZ' => '俄文（哈萨克斯坦）',
        'ru-MD' => '俄文（摩尔多瓦）',
        'ru-RU' => '俄文（俄罗斯）',
        'ru-UA' => '俄文（乌克兰）',
        'rw' => '卢旺达文',
        'rw-RW' => '卢旺达文（卢旺达）',
        'rwk' => '罗瓦文',
        'rwk-TZ' => '罗瓦文（坦桑尼亚）',
        'sah' => '雅库特文',
        'sah-RU' => '雅库特文（俄罗斯）',
        'saq' => '桑布鲁文',
        'saq-KE' => '桑布鲁文（肯尼亚）',
        'sbp' => '桑古文',
        'sbp-TZ' => '桑古文（坦桑尼亚）',
        'se' => '北萨米文',
        'se-FI' => '北萨米文（芬兰）',
        'se-NO' => '北萨米文（挪威）',
        'se-SE' => '北萨米文（瑞典）',
        'seh' => '塞纳文',
        'seh-MZ' => '塞纳文（莫桑比克）',
        'ses' => '东桑海文',
        'ses-ML' => '东桑海文（马里）',
        'sg' => '桑戈文',
        'sg-CF' => '桑戈文（中非共和国）',
        'shi' => '希尔哈文',
        'shi-Latn' => '希尔哈文（拉丁文）',
        'shi-Latn-MA' => '希尔哈文（拉丁文、摩洛哥）',
        'shi-Tfng' => '希尔哈文（提非纳文）',
        'shi-Tfng-MA' => '希尔哈文（提非纳文、摩洛哥）',
        'si' => '僧伽罗文',
        'si-LK' => '僧伽罗文（斯里兰卡）',
        'sk' => '斯洛伐克文',
        'sk-SK' => '斯洛伐克文（斯洛伐克）',
        'sl' => '斯洛文尼亚文',
        'sl-SI' => '斯洛文尼亚文（斯洛文尼亚）',
        'smn' => '伊纳里萨米文',
        'smn-FI' => '伊纳里萨米文（芬兰）',
        'sn' => '绍纳文',
        'sn-ZW' => '绍纳文（津巴布韦）',
        'so' => '索马里文',
        'so-DJ' => '索马里文（吉布提）',
        'so-ET' => '索马里文（埃塞俄比亚）',
        'so-KE' => '索马里文（肯尼亚）',
        'so-SO' => '索马里文（索马里）',
        'sq' => '阿尔巴尼亚文',
        'sq-AL' => '阿尔巴尼亚文（阿尔巴尼亚）',
        'sq-MK' => '阿尔巴尼亚文（马其顿）',
        'sq-XK' => '阿尔巴尼亚文（科索沃）',
        'sr' => '塞尔维亚文',
        'sr-Cyrl' => '塞尔维亚文（西里尔文）',
        'sr-Cyrl-BA' => '塞尔维亚文（西里尔文、波斯尼亚和黑塞哥维那）',
        'sr-Cyrl-ME' => '塞尔维亚文（西里尔文、黑山）',
        'sr-Cyrl-RS' => '塞尔维亚文（西里尔文、塞尔维亚）',
        'sr-Cyrl-XK' => '塞尔维亚文（西里尔文、科索沃）',
        'sr-Latn' => '塞尔维亚文（拉丁文）',
        'sr-Latn-BA' => '塞尔维亚文（拉丁文、波斯尼亚和黑塞哥维那）',
        'sr-Latn-ME' => '塞尔维亚文（拉丁文、黑山）',
        'sr-Latn-RS' => '塞尔维亚文（拉丁文、塞尔维亚）',
        'sr-Latn-XK' => '塞尔维亚文（拉丁文、科索沃）',
        'sv' => '瑞典文',
        'sv-AX' => '瑞典文（奥兰群岛）',
        'sv-FI' => '瑞典文（芬兰）',
        'sv-SE' => '瑞典文（瑞典）',
        'sw' => '斯瓦希里文',
        'sw-CD' => '斯瓦希里文（刚果［金］）',
        'sw-KE' => '斯瓦希里文（肯尼亚）',
        'sw-TZ' => '斯瓦希里文（坦桑尼亚）',
        'sw-UG' => '斯瓦希里文（乌干达）',
        'ta' => '泰米尔文',
        'ta-IN' => '泰米尔文（印度）',
        'ta-LK' => '泰米尔文（斯里兰卡）',
        'ta-MY' => '泰米尔文（马来西亚）',
        'ta-SG' => '泰米尔文（新加坡）',
        'te' => '泰卢固文',
        'te-IN' => '泰卢固文（印度）',
        'teo' => '特索文',
        'teo-KE' => '特索文（肯尼亚）',
        'teo-UG' => '特索文（乌干达）',
        'th' => '泰文',
        'th-TH' => '泰文（泰国）',
        'ti' => '提格里尼亚文',
        'ti-ER' => '提格里尼亚文（厄立特里亚）',
        'ti-ET' => '提格里尼亚文（埃塞俄比亚）',
        'to' => '汤加文',
        'to-TO' => '汤加文（汤加）',
        'tr' => '土耳其文',
        'tr-CY' => '土耳其文（塞浦路斯）',
        'tr-TR' => '土耳其文（土耳其）',
        'twq' => '北桑海文',
        'twq-NE' => '北桑海文（尼日尔）',
        'tzm' => '塔马齐格特文',
        'tzm-MA' => '塔马齐格特文（摩洛哥）',
        'ug' => '维吾尔文',
        'ug-CN' => '维吾尔文（中国）',
        'uk' => '乌克兰文',
        'uk-UA' => '乌克兰文（乌克兰）',
        'ur' => '乌尔都文',
        'ur-IN' => '乌尔都文（印度）',
        'ur-PK' => '乌尔都文（巴基斯坦）',
        'uz' => '乌兹别克文',
        'uz-Arab' => '乌兹别克文（阿拉伯文）',
        'uz-Arab-AF' => '乌兹别克文（阿拉伯文、阿富汗）',
        'uz-Cyrl' => '乌兹别克文（西里尔文）',
        'uz-Cyrl-UZ' => '乌兹别克文（西里尔文、乌兹别克斯坦）',
        'uz-Latn' => '乌兹别克文（拉丁文）',
        'uz-Latn-UZ' => '乌兹别克文（拉丁文、乌兹别克斯坦）',
        'vai' => '瓦伊文',
        'vai-Latn' => '瓦伊文（拉丁文）',
        'vai-Latn-LR' => '瓦伊文（拉丁文、利比里亚）',
        'vai-Vaii' => '瓦伊文（瓦依文）',
        'vai-Vaii-LR' => '瓦伊文（瓦依文、利比里亚）',
        'vi' => '越南文',
        'vi-VN' => '越南文（越南）',
        'vun' => '温旧文',
        'vun-TZ' => '温旧文（坦桑尼亚）',
        'wae' => '瓦尔瑟文',
        'wae-CH' => '瓦尔瑟文（瑞士）',
        'xog' => '索加文',
        'xog-UG' => '索加文（乌干达）',
        'yav' => '洋卞文',
        'yav-CM' => '洋卞文（喀麦隆）',
        'yi' => '依地文',
        'yi-001' => '依地文（世界）',
        'yo' => '约鲁巴文',
        'yo-BJ' => '约鲁巴文（贝宁）',
        'yo-NG' => '约鲁巴文（尼日利亚）',
        'yue' => '粤语',
        'yue-HK' => '粤语（中国香港特别行政区）',
        'zgh' => '标准摩洛哥塔马塞特文',
        'zgh-MA' => '标准摩洛哥塔马塞特文（摩洛哥）',
        'zh' => '中文',
        'zh-Hans' => '中文（简体）',
        'zh-Hans-CN' => '中文（简体、中国）',
        'zh-Hans-HK' => '中文（简体、中国香港特别行政区）',
        'zh-Hans-MO' => '中文（简体、中国澳门特别行政区）',
        'zh-Hans-SG' => '中文（简体、新加坡）',
        'zh-Hant' => '中文（繁体）',
        'zh-Hant-HK' => '中文（繁体、中国香港特别行政区）',
        'zh-Hant-MO' => '中文（繁体、中国澳门特别行政区）',
        'zh-Hant-TW' => '中文（繁体、台湾）',
        'zu' => '祖鲁文',
        'zu-ZA' => '祖鲁文（南非）',
    ],
];
